// Test program to send a single ECHO primitive

#include <iostream>
using namespace std;

#include <ctype.h>

#include "RodModule.h"
#include "BaseException.h"

#include "primParams.h"
#include "RCCVmeInterface.h"
#include "parameters.h"

int main(int argc, char *argv[]) {

using namespace SctPixelRod;

  const unsigned long mapSize=0xc00040;         // VME map size 
  RodPrimList primList(1);                      // Primitive List
  long myTextLength;                            // Actual length of text message
  TEXT_BUFFER_TYPE myTextType;                  // Buffer type for latest message
  long numSlaves = 4;
  PrimState returnPState;
  TextBuffState returnTState;

  std::string fileName(""), option;
  long dataLength = -1;
  int slot = -1;
  int repetitions = 1;

  unsigned long baseAddress;

  if (argc > 1) {
    for (int i=1; i<argc; i++) {
      option = argv[i];
      if (option[0] != '-') break;
      switch (option[1]) {
        case 's': {
          slot = atoi(option.substr(2).c_str());
          break;
        }
        case 'l': {
          dataLength = atoi(option.substr(2).c_str());
          break;
        }
        case 'r': {
          repetitions = atoi(option.substr(2).c_str());
          break;
        }
        default: {
          break;
        }
      }
    }
  }

// Prompt for slot number
  if (slot < 0 ) {
    cout << "Enter slot number (decimal):"; 
    cin >> slot;
    while ((slot < 1) || (slot > 21)) {
      cout << "Slot number out or range [1:21], re-enter: ";
      cin >> slot;
    }
  }
  baseAddress = slot << 24;

// Create VME interface
  RCCVmeInterface *vme1;
  try {
    vme1 = new RCCVmeInterface();
  }
  catch (VmeException &v) {
    cout << "VmeException creating VME interface." << endl;
    cout << "ErrorClass = " << v.getErrorClass() << endl;
    cout << "ErrorCode = " << v.getErrorCode() << endl; 

    return 1;
  }
  
// Create RodModule and initialize it
  RodModule* rod0 = new RodModule(baseAddress, mapSize, *vme1, numSlaves);
  try{
    rod0->initialize();
  }
  catch (HpiException &h) {
    cout << h;

    return 1;
  }
  catch (VmeException &v) {
    cout << "VmeException initialising RodModule." << endl;
    cout << "ErrorClass = " << v.getErrorClass() << endl;
    cout << "ErrorCode = " << v.getErrorCode() << endl; 

    return 1;
  }
  catch (RodException &r) {
    cout << r;

    return 1;
  }

// Create a buffer for text messages
  char * myTextBuffer;
  try {
    myTextBuffer= new char[TEXT_BUFF_SIZE];
  }
  catch (std::bad_alloc) {
    cout << "Unable to allocate text buffer in main.";
  }
// Create and Send a simple ECHO primitive
  
  long* echoData;

  if(dataLength < 0) {
    cout << "Enter number of data words: ";

    cin >> dataLength;
  }

  try {
    echoData = new long[dataLength];
  }
  catch (std::bad_alloc) {
    cout << "Unable to allocate echoData in main.";
    return 1;
  }

  for (long i=0; i<dataLength; i++) {
    echoData[i] = 0xbeef0000 | i;
  }
  RodPrimitive* echo;
  try {
    echo= new RodPrimitive(dataLength+4, 1, ECHO, R_ECHO, echoData);
  }
  catch (std::bad_alloc) {
    cout << "Unable to allocate ECHO primitive in main.";

    return 1;
  }

  primList.insert(primList.begin(), *echo);
  try {
    primList.bufferBuild();
  }
  catch (PrimListException &p) {
    cout << p.getDescriptor() << " ";
    cout << p.getData1() << ", " << p.getData2() << "\n";
  };

  if(repetitions > 1) {
    cout << "Repeating " << repetitions << "times\n";
  }

  for(int reps=0; reps<repetitions; reps++) {
    if(repetitions > 1) {
      cerr << ".";
    }

    try {
      rod0->sendPrimList(&primList);
    }
    catch (VmeException &v) {
      cout << "VmeException in SendPrimList." << endl;
      cout << "ErrorClass = " << v.getErrorClass() << endl;
      cout << "ErrorCode = " << v.getErrorCode() << endl; 

      return 1;
    }
    catch (BaseException &h) {
      cout << h;

      return 1;
    }
  
// Wait for ROD to begin executing and then wait for it to finish executing
// Check for error messages in text buffer and read them out if they exist.
// Note: this is NOT how primHandler and textHandler will be used once we
// go to threads.  This is for debugging the code only.
    do {
      try {
        returnPState = rod0->primHandler();
      }
      catch (VmeException &v) {
        cout << "VmeException in first primHandler call." << endl;
        cout << "ErrorClass = " << v.getErrorClass() << endl;
        cout << "ErrorCode = " << v.getErrorCode() << endl; 

        return 1;
      }
      try {
        returnTState = rod0->textHandler();
      }
      catch (VmeException &v) {
        cout << "VmeException in first textHandler call." << endl;
        cout << "ErrorClass = " << v.getErrorClass() << endl;
        cout << "ErrorCode = " << v.getErrorCode() << endl; 

        return 1;
      }
      if (returnTState == TEXT_RQ_SET) {
        do {
          try {
            returnTState = rod0->textHandler();
          }
          catch (VmeException &v) {
            cout << "VmeException in second textHandler call." << endl;
            cout << "ErrorClass = " << v.getErrorClass() << endl;
            cout << "ErrorCode = " << v.getErrorCode() << endl; 

            return 1;
          }
        } while (returnTState != TEXT_READOUT);
        rod0->getTextBuffer(myTextBuffer, myTextLength, myTextType);
        rod0->clearTextBuffer();
        for (int i=0; i<myTextLength; i++) {
          cout << myTextBuffer[i];
          if (0==(i+1)%64) cout << endl;
        }
        cout << endl; 
      }
    } while (returnPState != PRIM_EXECUTING); 
    do {
      try {
        returnPState = rod0->primHandler();
      }
      catch (RodException &r) {
        cout << r;
        return 1;
      }
      catch (VmeException &v) {
        cout << "VmeException in second primHandler call." << endl;
        cout << "ErrorClass = " << v.getErrorClass() << endl;
        cout << "ErrorCode = " << v.getErrorCode() << endl; 

        return 1;
      }
    } while (returnPState != PRIM_WAITING && returnPState != PRIM_IDLE); 
  
// Retrieve output buffer
    RodOutList* outList = rod0->getOutList();

    if(outList) {
// Print results (User processing of outList)
      UINT32 outLength = UINT32(outList->getLength());
      unsigned long* outBody = outList->getBody();
      UINT32 outIndex = UINT32(outBody[1]);
      UINT32 outNumPrims = outBody[2];
      UINT32 outPrimVersion = outBody[3];
      if(reps == 0) {
        cout << "outLength = " << outLength << ", outIndex = " << outIndex << 
                ", outNumPrims = " << outNumPrims << ", outPrimVersion = " << 
                outPrimVersion <<'\n';
      }
      int outPtr = 4;
      for (UINT32 j=0; j<outNumPrims; j++) {
        UINT32 primLength = outBody[outPtr++];
        UINT32 primIndex = outBody[outPtr++];
        UINT32 primId = outBody[outPtr++];
        UINT32 primVersion = outBody[outPtr++];

        if(reps>=1) {
          for(UINT32 i=0; i<primLength-4; i++) {
            if(outBody[i+outPtr] != echoData[i]) {
              cout << "Echo Check failed in word " << i << " of repetition " << reps << "\n";
              cout << "0x" << hex << outBody[i+outPtr] << " != 0x" << echoData[i] << dec << endl;
              return 1;
            }
          }
        } else {
          cout << "primLength = " << primLength << ", primIndex = " << primIndex << 
                  ", primId = " << primId << ", primVersion = " << primVersion << '\n';
          cout << "ECHO data: " << endl;
          hex(cout);

          for (UINT32 i=0; i<primLength-4; i++) {
            cout.width(8);
            cout << outBody[i+outPtr] <<" ";
            if (0 == (i+1)%8) cout << endl; 
          };
          if (0 != (primLength-4)%8) cout << endl;
          dec(cout);
        }
      };

// Copy to local buffer
      unsigned long* myOutBody;
      try {
        myOutBody= new unsigned long[outLength];
      }
      catch (std::bad_alloc) {
        cout << "Unable to allocate myOutBody in main." << endl;

        return 1;
      }
      for (UINT32 i=0; i<outLength; i++) {
        myOutBody[i] = outBody[i];
      };

      delete [] myOutBody;
      rod0->deleteOutList();
    } else {
      cout << "No response from echo primitive!\n";
    }
  }

  if(repetitions > 1)
    cerr << endl;

// Test ostream output
  cout << "Rod Status:" << endl << *rod0 << endl;

  cout << "Check text buffers before exiting:\n";

  try {
    returnTState = rod0->textHandler();
  }
  catch (VmeException &v) {
    cout << "VmeException in first textHandler call." << endl;
    cout << "ErrorClass = " << v.getErrorClass() << endl;
    cout << "ErrorCode = " << v.getErrorCode() << endl; 

    return 1;
  }
  if (returnTState == TEXT_RQ_SET) {
    do {
      try {
        returnTState = rod0->textHandler();
      }
      catch (VmeException &v) {
        cout << "VmeException in second textHandler call." << endl;
        cout << "ErrorClass = " << v.getErrorClass() << endl;
        cout << "ErrorCode = " << v.getErrorCode() << endl; 

        return 1;
      }
    } while (returnTState != TEXT_READOUT);
    rod0->getTextBuffer(myTextBuffer, myTextLength, myTextType);
    rod0->clearTextBuffer();
    for (int i=0; i<myTextLength; i++) {
      cout << myTextBuffer[i];
      if (0==(i+1)%64) cout << endl;
    }
    cout << endl; 
  }


  cout << "Text buffers checked\n";
  
// Test reset of master DSP 
/*  try { 
    rod0->resetMasterDsp();
  }
  catch (VmeException &v) {
    cout << "VmeException in resetMasterDsp()." << endl;
    cout << "ErrorClass = " << v.getErrorClass() << endl;
    cout << "ErrorCode = " << v.getErrorCode() << endl; 

    return 1;
  };
  try {
    rod0->resetAllDsps();
  }
  catch (VmeException &v) {
    cout << "VmeException in resetAllDsps()." << endl;
    cout << "ErrorClass = " << v.getErrorClass() << endl;
    cout << "ErrorCode = " << v.getErrorCode() << endl; 

    return 1;
  };
*/

// Clean up: clear primList, delete primitive, delete the outList
  primList.clear();
  delete [] echoData;
  delete echo;
  delete [] myTextBuffer;
  rod0->deleteOutList();
  
// Delete the ROD and VME objects before exiting
  delete rod0;
  delete vme1;

  return 0;  
}


