/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.IOException;
import java.io.InputStream;
import org.freehep.util.io.ByteOrderInputStream;

public class ByteCountInputStream
extends ByteOrderInputStream {
    private int index;
    private int[] size;

    public ByteCountInputStream(InputStream in, boolean littleEndian, int stackDepth) {
        super(in, littleEndian);
        this.size = new int[stackDepth];
        this.index = -1;
    }

    public int read() throws IOException {
        if (this.index == -1) {
            return super.read();
        }
        if (this.size[this.index] <= 0) {
            return -1;
        }
        int n = this.index;
        this.size[n] = this.size[n] - 1;
        return super.read();
    }

    public void pushBuffer(int len) {
        if (this.index >= this.size.length - 1) {
            System.err.println("ByteCountInputStream: trying to push more buffers than stackDepth: " + this.size.length);
            return;
        }
        if (this.index >= 0) {
            if (this.size[this.index] < len) {
                System.err.println("ByteCountInputStream: trying to set a length: " + len + ", longer than the underlying buffer: " + this.size[this.index]);
                return;
            }
            int n = this.index;
            this.size[n] = this.size[n] - len;
        }
        ++this.index;
        this.size[this.index] = len;
    }

    public byte[] popBuffer() throws IOException {
        if (this.index >= 0) {
            int len = this.size[this.index];
            if (len > 0) {
                return this.readByte(len);
            }
            if (len < 0) {
                System.err.println("ByteCountInputStream: Internal Error");
            }
            --this.index;
        }
        return null;
    }

    public int getLength() {
        return this.index >= 0 ? this.size[this.index] : -1;
    }
}

