/*
 * Decompiled with CFR 0.152.
 */
package SctApi.conf.gui;

import SctApi.conf.gui.ConfigGui;
import SctApi.conf.gui.ModuleListView;
import SctApi.conf.gui.ModuleView;
import SctApi.conf.gui.RODView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.omg.CORBA.IntHolder;
import sctConf.Configuration;
import sctConf.ConfigurationException;
import sctConf.RodConfig;
import sctConf.SlaveConfig;

public class TreeView
extends JFrame {
    private ConfigGui configGui;
    private Configuration conf;
    private JTree tree;
    private final JFrame treeFrame;
    private JPopupMenu popup;
    private MyModel treeModel;
    private MURSelectDialog dialog;

    public TreeView(ConfigGui configGui, Configuration configuration) {
        super("Tree view");
        this.configGui = configGui;
        this.conf = configuration;
        this.treeModel = new MyModel(this.conf);
        this.tree = new JTree(this.treeModel);
        this.treeFrame = this;
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        this.enableEvents(64L);
        this.tree.addMouseListener(new MouseClickHandler());
        this.dialog = new MURSelectDialog(this);
        this.popup = new JPopupMenu();
        this.popup.add(new JMenuItem("Do nothing"));
        jScrollPane.setPreferredSize(new Dimension(500, 300));
        this.getContentPane().add((Component)jScrollPane, "Center");
        System.out.println("Set up GUI, wait for it to run");
    }

    public class MURSelectDialog
    extends JDialog {
        ConfigGui.Rod myRod;

        MURSelectDialog(Frame frame) {
            super(frame, "Select MUR and position", true);
            Box box = Box.createVerticalBox();
            box.add(new JLabel("" + this.myRod));
            this.getContentPane().add(box);
        }

        void setROD(ConfigGui.Rod rod) {
            this.myRod = rod;
        }

        int getMyPos() {
            return 5;
        }

        String getMySN() {
            return "2022018000000";
        }

        int getMyMUR() {
            try {
                int[] nArray = TreeView.this.conf.listMURSInRod(this.myRod.partition(), this.myRod.crate(), this.myRod.index());
                return nArray[0];
            }
            catch (ConfigurationException configurationException) {
                System.out.println("No MURs in ROD? " + (Object)((Object)configurationException));
                return 0;
            }
        }
    }

    public class MyModel
    implements TreeModel {
        Configuration conf;
        Vector listeners;

        public MyModel(Configuration configuration) {
            this.conf = configuration;
            this.listeners = new Vector();
        }

        public Object getRoot() {
            return "Partitions";
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object getChild(Object object, int n) {
            Object object2;
            block25: {
                System.out.print("getChild");
                object2 = null;
                try {
                    if (object == "Partitions") {
                        object2 = TreeView.this.configGui.getPartition(n);
                        break block25;
                    }
                    if (object instanceof ConfigGui.MyPartition) {
                        ConfigGui.MyPartition myPartition = (ConfigGui.MyPartition)object;
                        object2 = TreeView.this.configGui.getCrate(n, myPartition.index());
                        break block25;
                    }
                    if (object instanceof ConfigGui.Crate) {
                        ConfigGui.Crate crate = (ConfigGui.Crate)object;
                        int[] nArray = this.conf.listRodsInCrate(crate.partition(), crate.index());
                        object2 = TreeView.this.configGui.getRod(nArray[n], crate.index(), crate.partition());
                        break block25;
                    }
                    if (object instanceof ConfigGui.Rod) {
                        ConfigGui.Rod rod = (ConfigGui.Rod)object;
                        int[] nArray = this.conf.listMURSInRod(rod.partition(), rod.crate(), rod.index());
                        object2 = TreeView.this.configGui.getMUR(n, nArray[n], rod.partition(), rod.crate(), rod.index());
                        break block25;
                    }
                    if (object instanceof ConfigGui.MUR) {
                        ConfigGui.MUR mUR = (ConfigGui.MUR)object;
                        System.out.print(" Asked for child " + n + " of MUR " + mUR);
                        boolean bl = false;
                        String[] stringArray = this.conf.listModulesInMUR(mUR.partition(), mUR.id());
                        object2 = TreeView.this.configGui.getModule(stringArray[n]);
                        break block25;
                    }
                    if (object instanceof ConfigGui.Module) {
                        ConfigGui.Module module = (ConfigGui.Module)object;
                        IntHolder intHolder = new IntHolder();
                        IntHolder intHolder2 = new IntHolder();
                        this.conf.translateFromSN(module.toString(), intHolder, intHolder2);
                        switch (n) {
                            case 0: {
                                try {
                                    IntHolder intHolder3 = new IntHolder();
                                    IntHolder intHolder4 = new IntHolder();
                                    IntHolder intHolder5 = new IntHolder();
                                    this.conf.translateToBarrel(intHolder.value, intHolder2.value, intHolder3, intHolder4, intHolder5);
                                    object2 = "Barrel " + intHolder3.value + " Row " + intHolder4.value + " Number " + intHolder5.value;
                                }
                                catch (ConfigurationException configurationException) {
                                    object2 = "No barrel mapping defined";
                                }
                                break;
                            }
                            case 1: {
                                try {
                                    IntHolder intHolder6 = new IntHolder();
                                    IntHolder intHolder7 = new IntHolder();
                                    IntHolder intHolder8 = new IntHolder();
                                    IntHolder intHolder9 = new IntHolder();
                                    this.conf.translateToROD(intHolder.value, intHolder2.value, intHolder6, intHolder8, intHolder7, intHolder9);
                                    object2 = intHolder6.value + " " + intHolder8.value + " " + intHolder7.value + " " + intHolder9.value;
                                }
                                catch (ConfigurationException configurationException) {
                                    object2 = "No ROD mapping defined";
                                }
                                break;
                            }
                            case 2: {
                                try {
                                    IntHolder intHolder10 = new IntHolder();
                                    IntHolder intHolder11 = new IntHolder();
                                    IntHolder intHolder12 = new IntHolder();
                                    this.conf.translateToPowerSupply(intHolder.value, intHolder2.value, intHolder10, intHolder11, intHolder12);
                                    object2 = "Power: " + intHolder10.value + " " + intHolder11.value + " " + intHolder12.value;
                                }
                                catch (ConfigurationException configurationException) {
                                    object2 = "No power mapping defined";
                                }
                                break;
                            }
                            case 3: {
                                object2 = "MUR " + intHolder.value + ": " + intHolder2.value;
                                break;
                            }
                            case 4: {
                                try {
                                    this.conf.getModuleConfig(module.getSN());
                                    object2 = "Module Configuration defined";
                                }
                                catch (ConfigurationException configurationException) {
                                    object2 = "No module configuration defined!";
                                }
                                break;
                            }
                        }
                    } else if (!(object instanceof String)) {
                        // empty if block
                    }
                }
                catch (ConfigurationException configurationException) {
                    object2 = "Exception getting result";
                }
            }
            System.out.println(".");
            return object2;
        }

        public int getChildCount(Object object) {
            System.out.print("getChildCount");
            int n = 0;
            try {
                if (object == null) {
                    n = 0;
                } else if (object == "Partitions") {
                    int[] nArray = this.conf.listPartitions();
                    n = nArray.length;
                } else if (object instanceof ConfigGui.MyPartition) {
                    ConfigGui.MyPartition myPartition = (ConfigGui.MyPartition)object;
                    int[] nArray = this.conf.listCratesInPartition(myPartition.index());
                    n = nArray.length;
                } else if (object instanceof ConfigGui.Crate) {
                    ConfigGui.Crate crate = (ConfigGui.Crate)object;
                    int[] nArray = this.conf.listRodsInCrate(crate.partition(), crate.index());
                    n = nArray.length;
                } else if (object instanceof ConfigGui.Rod) {
                    ConfigGui.Rod rod = (ConfigGui.Rod)object;
                    int[] nArray = this.conf.listMURSInRod(rod.partition(), rod.crate(), rod.index());
                    n = nArray.length;
                } else if (object instanceof ConfigGui.MUR) {
                    ConfigGui.MUR mUR = (ConfigGui.MUR)object;
                    n = this.conf.listModulesInMUR(mUR.partition(), mUR.id()).length;
                } else if (object instanceof ConfigGui.Module) {
                    n = 5;
                } else if (object instanceof String) {
                    n = 0;
                }
            }
            catch (ConfigurationException configurationException) {
                n = 0;
            }
            System.out.println(" " + n + ".");
            return n;
        }

        public int getIndexOfChild(Object object, Object object2) {
            System.out.print("getIndexOfChild");
            int n = -1;
            try {
                if (object == null) {
                    n = -1;
                } else if (object == "Partitions") {
                    int[] nArray = this.conf.listPartitions();
                    int n2 = ((ConfigGui.MyPartition)object2).index();
                    int n3 = 0;
                    while (n3 < nArray.length) {
                        if (nArray[n3] == n2) {
                            n = n3;
                        }
                        ++n3;
                    }
                } else if (object instanceof ConfigGui.MyPartition) {
                    ConfigGui.Crate crate = (ConfigGui.Crate)object2;
                    ConfigGui.MyPartition myPartition = (ConfigGui.MyPartition)object;
                    int[] nArray = this.conf.listCratesInPartition(myPartition.index());
                    int n4 = crate.index();
                    int n5 = 0;
                    while (n5 < nArray.length) {
                        if (nArray[n5] == n4) {
                            n = n5;
                        }
                        ++n5;
                    }
                } else if (object instanceof ConfigGui.Crate) {
                    ConfigGui.Rod rod = (ConfigGui.Rod)object2;
                    ConfigGui.Crate crate = (ConfigGui.Crate)object;
                    int[] nArray = this.conf.listRodsInCrate(crate.partition(), crate.index());
                    int n6 = rod.index();
                    int n7 = 0;
                    while (n7 < nArray.length) {
                        if (nArray[n7] == n6) {
                            n = n7;
                        }
                        ++n7;
                    }
                } else if (object instanceof ConfigGui.Rod) {
                    ConfigGui.MUR mUR = (ConfigGui.MUR)object2;
                    ConfigGui.Rod rod = (ConfigGui.Rod)object;
                    int[] nArray = this.conf.listMURSInRod(rod.partition(), rod.crate(), rod.index());
                    int n8 = mUR.id();
                    int n9 = 0;
                    while (n9 < nArray.length) {
                        if (nArray[n9] == n8) {
                            n = n9;
                        }
                        ++n9;
                    }
                } else if (object instanceof ConfigGui.MUR) {
                    ConfigGui.Module module = (ConfigGui.Module)object2;
                    ConfigGui.MUR mUR = (ConfigGui.MUR)object;
                    String[] stringArray = this.conf.listModulesInMUR(mUR.partition(), mUR.index());
                    String string = module.getSN();
                    int n10 = 0;
                    while (n10 < stringArray.length) {
                        if (stringArray[n10] == string) {
                            n = n10;
                        }
                        ++n10;
                    }
                    IntHolder intHolder = new IntHolder();
                    IntHolder intHolder2 = new IntHolder();
                    this.conf.translateFromSN(module.toString(), intHolder, intHolder2);
                    System.out.println("translateFromSN returned MUR " + intHolder.value + " Stored is " + mUR.id());
                } else if (object instanceof ConfigGui.Module) {
                    n = 0;
                    System.out.println("Count strings...");
                } else if (object instanceof String) {
                    n = -1;
                }
            }
            catch (ConfigurationException configurationException) {
                n = 0;
            }
            System.out.println(" " + n + ".");
            return n;
        }

        public boolean isLeaf(Object object) {
            return object instanceof String && object != "Partitions";
        }

        public void valueForPathChanged(TreePath treePath, Object object) {
        }

        public void addTreeModelListener(TreeModelListener treeModelListener) {
            System.out.println("Add listener " + treeModelListener);
            this.listeners.add(treeModelListener);
        }

        public void removeTreeModelListener(TreeModelListener treeModelListener) {
            System.out.println("Remove listener " + treeModelListener);
            this.listeners.remove(treeModelListener);
        }

        public void modified(Object object) {
            Enumeration enumeration = this.listeners.elements();
            while (enumeration.hasMoreElements()) {
                TreeModelListener treeModelListener = (TreeModelListener)enumeration.nextElement();
                Object[] objectArray = new Object[]{"Partitions"};
                TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, objectArray);
                treeModelListener.treeStructureChanged(treeModelEvent);
            }
        }

        public void modified(Object[] objectArray) {
            Enumeration enumeration = this.listeners.elements();
            while (enumeration.hasMoreElements()) {
                TreeModelListener treeModelListener = (TreeModelListener)enumeration.nextElement();
                TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, objectArray);
                treeModelListener.treeStructureChanged(treeModelEvent);
            }
        }
    }

    private class ActionHandler
    implements ActionListener {
        Object target;

        public ActionHandler(String string, Object object) {
            this.target = object;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            System.out.println("Do " + string + " on " + this.target);
            if (this.target instanceof ConfigGui.Crate) {
                ConfigGui.Crate crate = (ConfigGui.Crate)this.target;
                if (string == "Clear RODs in crate") {
                    System.out.println("Don't know that one yet");
                } else if (string == "Add ROD to crate") {
                    try {
                        int[] nArray = TreeView.this.conf.listRodsInCrate(crate.partition(), crate.index());
                        RodConfig rodConfig = new RodConfig();
                        rodConfig.slaves = new SlaveConfig[4];
                        int n = 0;
                        while (n < 4) {
                            rodConfig.slaves[n] = new SlaveConfig();
                            rodConfig.slaves[n].emifFile = "";
                            rodConfig.slaves[n].ipramFile = "";
                            rodConfig.slaves[n].idramFile = "";
                            rodConfig.slaves[n].extFile = "";
                            ++n;
                        }
                        TreeView.this.conf.configureROD(crate.partition(), crate.index(), nArray.length, rodConfig);
                        Object[] objectArray = new Object[]{"Partitions", TreeView.this.configGui.getPartition(crate.partition()), this.target};
                        TreeView.this.treeModel.modified(objectArray);
                    }
                    catch (ConfigurationException configurationException) {
                        System.out.println("ROD creation failed");
                    }
                } else {
                    System.out.println("Unknown action " + string + " on Crate " + crate);
                }
            } else if (this.target instanceof ConfigGui.Rod) {
                ConfigGui.Rod rod = (ConfigGui.Rod)this.target;
                if (string == "View ROD info") {
                    RODView rODView = new RODView(TreeView.this.conf, rod);
                    rODView.addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent windowEvent) {
                            windowEvent.getWindow().dispose();
                        }
                    });
                    rODView.pack();
                    rODView.setVisible(true);
                } else if (string == "Add Module to ROD") {
                    int[] nArray = new int[100];
                    System.out.println("Adding ROD " + rod);
                    TreeView.this.dialog.setROD(rod);
                    TreeView.this.dialog.show();
                    System.out.println("Got back some selections " + TreeView.this.dialog.getMyMUR() + " " + TreeView.this.dialog.getMyPos() + " " + TreeView.this.dialog.getMySN());
                    try {
                        throw new ConfigurationException("Can't create Module - feature removed!");
                    }
                    catch (ConfigurationException configurationException) {
                        System.out.println("CreateModule failed with " + (Object)((Object)configurationException));
                    }
                } else {
                    System.out.println("Unknown action " + string + " on ROD ");
                }
            } else if (this.target instanceof ConfigGui.MUR) {
                ConfigGui.MUR mUR = (ConfigGui.MUR)this.target;
                if (string == "Add Module to MUR") {
                    Object[] objectArray;
                    Object[] objectArray2 = null;
                    int n = -1;
                    Object[] objectArray3 = new ModuleListView(TreeView.this.conf);
                    Object object = objectArray3.getList();
                    if (((Vector)object).size() == 0) {
                        System.out.println("No modules to select");
                    } else {
                        Object[] objectArray4 = new Object[((Vector)object).size()];
                        ((Vector)object).copyInto(objectArray4);
                        objectArray = (Object[])JOptionPane.showInputDialog((JComponent)actionEvent.getSource(), "Select an unused module", "Module selector", 2, null, objectArray4, objectArray4[0]);
                        System.out.println("Found a module! " + (String)objectArray);
                        objectArray2 = objectArray;
                    }
                    try {
                        objectArray3 = TreeView.this.conf.listModulesInMUR(mUR.partition(), mUR.id());
                        object = new int[6];
                        int n2 = 0;
                        while (n2 < objectArray3.length) {
                            objectArray = new IntHolder();
                            IntHolder intHolder = new IntHolder();
                            TreeView.this.conf.translateFromSN(objectArray3[n2].toString(), (IntHolder)objectArray, intHolder);
                            object[intHolder.value - 1] = true;
                            ++n2;
                        }
                        objectArray = new Integer[6 - objectArray3.length];
                        int n3 = 0;
                        int n4 = 1;
                        while (n4 <= 6) {
                            if (object[n4 - 1] == false) {
                                objectArray[n3++] = new Integer(n4);
                            }
                            ++n4;
                        }
                        if (objectArray3.length < 6) {
                            Integer n5 = (Integer)JOptionPane.showInputDialog((JComponent)actionEvent.getSource(), "Select an unused position", "Position selector", 2, null, objectArray, objectArray[0]);
                            n = n5;
                        } else {
                            System.out.println("No positions free");
                        }
                        System.out.println("Got position " + n);
                    }
                    catch (ConfigurationException configurationException) {
                        System.out.println("Bad configuration for getting MUR list");
                    }
                    if (objectArray2 != null && n != -1) {
                        System.out.println("Mapping module " + objectArray2 + " in MUR " + mUR.id() + " to number " + n);
                        try {
                            TreeView.this.conf.mapModuleMUR(mUR.id(), n, mUR.id(), n % 6 + 1, (String)objectArray2);
                            objectArray3 = new Object[]{"Partitions", TreeView.this.configGui.getPartition(mUR.partition()), TreeView.this.configGui.getCrate(mUR.crate(), mUR.partition()), TreeView.this.configGui.getRod(mUR.rod(), mUR.partition(), mUR.crate()), this.target};
                            int n6 = 0;
                            while (n6 < 5) {
                                System.out.println(n6 + ": " + objectArray3[n6]);
                                ++n6;
                            }
                            TreeView.this.treeModel.modified(objectArray3);
                        }
                        catch (ConfigurationException configurationException) {
                            System.out.println("Failed to map module");
                        }
                    }
                } else {
                    System.out.println("Unknown action " + string + " on MUR " + mUR);
                }
            } else if (this.target instanceof ConfigGui.Module) {
                ConfigGui.Module module = (ConfigGui.Module)this.target;
                if (string == "View module info") {
                    ModuleView moduleView = new ModuleView(TreeView.this.conf, module);
                    moduleView.addWindowListener(new WindowAdapter(this){
                        private final /* synthetic */ ActionHandler this$1;
                        {
                            this.this$1 = actionHandler;
                        }

                        public void windowClosing(WindowEvent windowEvent) {
                            windowEvent.getWindow().dispose();
                        }
                    });
                    moduleView.pack();
                    moduleView.setVisible(true);
                } else {
                    System.out.println("Unknown action " + string + " on module " + module);
                }
            } else if (this.target == "Partitions") {
                System.out.println("Permission denied!");
            } else {
                System.out.println("Can't do that yet!");
            }
        }
    }

    private class MouseClickHandler
    extends MouseAdapter {
        private MouseClickHandler() {
        }

        private JMenuItem menuWithAction(String string, Object object) {
            JMenuItem jMenuItem = new JMenuItem(string);
            jMenuItem.addActionListener(new ActionHandler(string, object));
            return jMenuItem;
        }

        private void checkPopup(MouseEvent mouseEvent) {
            block19: {
                TreePath treePath = TreeView.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath != null) {
                    TreeView.this.tree.setSelectionPath(treePath);
                    if (mouseEvent.isPopupTrigger()) {
                        Object object = treePath.getLastPathComponent();
                        System.out.println("Last in path is: " + object);
                        try {
                            while (true) {
                                TreeView.this.popup.remove(0);
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            if (object != null) {
                                if (object == "Partitions") {
                                    TreeView.this.popup.add(this.menuWithAction("Clear everything", object));
                                } else if (object instanceof ConfigGui.MyPartition) {
                                    TreeView.this.popup.add(this.menuWithAction("Clear crates", object));
                                    TreeView.this.popup.add(this.menuWithAction("Add crate to Partition", object));
                                } else if (object instanceof ConfigGui.Crate) {
                                    TreeView.this.popup.add(this.menuWithAction("Clear RODs in crate", object));
                                    TreeView.this.popup.add(this.menuWithAction("Add ROD to crate", object));
                                } else if (object instanceof ConfigGui.Rod) {
                                    TreeView.this.popup.add(this.menuWithAction("View ROD info", object));
                                } else if (object instanceof ConfigGui.MUR) {
                                    TreeView.this.popup.add(this.menuWithAction("Add Module to MUR", object));
                                } else if (object instanceof ConfigGui.Module) {
                                    TreeView.this.popup.add(this.menuWithAction("View module info", object));
                                    TreeView.this.popup.add(this.menuWithAction("Edit module mappings", object));
                                } else if (object instanceof String) {
                                    String string = (String)object;
                                }
                            }
                            if (TreeView.this.popup.getComponents().length <= 0) break block19;
                            TreeView.this.popup.show(TreeView.this.tree, mouseEvent.getX(), mouseEvent.getY());
                        }
                    }
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.checkPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.checkPopup(mouseEvent);
        }
    }
}

