/*
 * Decompiled with CFR 0.152.
 */
package SctApi.conf.gui;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.StringHolder;
import sctConf.Configuration;
import sctConf.ConfigurationException;

public class PhysicalView
extends JFrame {
    Configuration config;
    JComboBox barrel;
    JComboBox rowStart;
    JComboBox rowEnd;
    JPanel centre;

    public PhysicalView(Configuration configuration) {
        this.config = configuration;
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("Close");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PhysicalView.this.dispose();
            }
        });
        jPanel.add(jButton);
        this.getContentPane().add((Component)jPanel, "South");
        JPanel jPanel2 = new JPanel();
        Integer[] integerArray = new Integer[]{new Integer(3), new Integer(4), new Integer(5), new Integer(6)};
        this.barrel = new JComboBox<Integer>(integerArray);
        this.barrel.setSelectedItem(new Integer(3));
        this.barrel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((ComboModel)PhysicalView.this.rowStart.getModel()).fireListeners();
                ((ComboModel)PhysicalView.this.rowEnd.getModel()).fireListeners();
                PhysicalView.this.updateDisplay();
            }
        });
        jPanel2.add(this.barrel);
        this.rowStart = new JComboBox(new ComboModel(0));
        this.rowStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((ComboModel)PhysicalView.this.rowEnd.getModel()).fireListeners();
                PhysicalView.this.updateDisplay();
            }
        });
        jPanel2.add(this.rowStart);
        this.rowEnd = new JComboBox(new ComboModel(3));
        this.rowEnd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((ComboModel)PhysicalView.this.rowStart.getModel()).fireListeners();
                PhysicalView.this.updateDisplay();
            }
        });
        jPanel2.add(this.rowEnd);
        this.getContentPane().add((Component)jPanel2, "North");
        this.centre = new JPanel();
        this.updateDisplay();
        this.getContentPane().add((Component)this.centre, "Center");
    }

    public void updateDisplay() {
        this.centre.removeAll();
        this.centre.setLayout(new GridLayout(1, 4));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 12));
        int n = (Integer)this.barrel.getSelectedItem();
        int n2 = (Integer)this.rowStart.getSelectedItem();
        int n3 = (Integer)this.rowEnd.getSelectedItem();
        int n4 = n2;
        while (n4 < n3) {
            int n5 = -6;
            while (n5 <= 6) {
                if (n5 != 0) {
                    StringHolder stringHolder = new StringHolder();
                    try {
                        IntHolder intHolder = new IntHolder();
                        IntHolder intHolder2 = new IntHolder();
                        stringHolder = new StringHolder();
                        this.config.translateFromBarrel(n, n4, n5, intHolder, intHolder2);
                        this.config.translateToSN(intHolder.value, intHolder2.value, stringHolder);
                    }
                    catch (ConfigurationException configurationException) {
                        stringHolder.value = "position " + n5;
                    }
                    jPanel.add(new JLabel(stringHolder.value + " "));
                }
                ++n5;
            }
            ++n4;
        }
        this.centre.add(jPanel);
        this.centre.invalidate();
        jPanel.doLayout();
        this.centre.repaint();
    }

    public class ComboModel
    implements ComboBoxModel {
        Integer selection;
        Vector listeners;

        ComboModel(int n) {
            this.selection = new Integer(n);
            this.listeners = new Vector();
        }

        public Object getSelectedItem() {
            return this.selection;
        }

        public void setSelectedItem(Object object) {
            this.selection = (Integer)object;
        }

        public void addListDataListener(ListDataListener listDataListener) {
            this.listeners.add(listDataListener);
        }

        public Object getElementAt(int n) {
            return new Integer(n);
        }

        public int getSize() {
            int n = 0;
            switch ((Integer)PhysicalView.this.barrel.getSelectedItem()) {
                case 3: {
                    n = 32;
                    break;
                }
                case 4: {
                    n = 40;
                    break;
                }
                case 5: {
                    n = 48;
                    break;
                }
                case 6: {
                    n = 56;
                }
            }
            return n;
        }

        public void fireListeners() {
            int n = 0;
            while (n < this.listeners.size()) {
                ListDataEvent listDataEvent = new ListDataEvent(this, 0, 0, 56);
                ((ListDataListener)this.listeners.get(n)).contentsChanged(listDataEvent);
                ++n;
            }
        }

        public void removeListDataListener(ListDataListener listDataListener) {
            this.listeners.remove(listDataListener);
        }
    }
}

