/*
 * Decompiled with CFR 0.152.
 */
package SctApi.conf.gui;

import SctApi.conf.gui.ConfigGui;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.StringHolder;
import sctConf.BOCChannelConfig;
import sctConf.Configuration;
import sctConf.ConfigurationException;

public class MURPanel
extends JPanel {
    Configuration config;
    ConfigGui.Rod rod;
    int index;
    boolean editable;
    JTextField[] current;
    JTextField[] delay;
    JTextField[] markSpace;
    JTextField[] threshold0;
    JTextField[] delay0;
    JTextField[] threshold1;
    JTextField[] delay1;
    JTextField[] txFibre;
    JTextField[] rx0Fibre;
    JTextField[] rx1Fibre;
    int mur;
    static JFileChooser fileChooser;

    public MURPanel(Configuration configuration, ConfigGui.Rod rod, int n, boolean bl) {
        fileChooser = null;
        this.rod = rod;
        this.config = configuration;
        this.index = n;
        this.editable = bl;
        this.setLayout(new GridLayout(0, 1));
        IntHolder intHolder = new IntHolder();
        IntHolder intHolder2 = new IntHolder();
        try {
            this.config.translateFromROD(this.rod.partition(), this.rod.crate(), this.rod.index(), this.index * 6, intHolder, intHolder2);
        }
        catch (ConfigurationException configurationException) {
            intHolder.value = -1;
        }
        this.mur = intHolder.value;
        if (!this.editable) {
            this.setBorder(BorderFactory.createTitledBorder("MUR " + intHolder.value + " position " + (n + 1)));
        }
        this.current = new JTextField[6];
        this.delay = new JTextField[6];
        this.markSpace = new JTextField[6];
        this.threshold0 = new JTextField[6];
        this.delay0 = new JTextField[6];
        this.threshold1 = new JTextField[6];
        this.delay1 = new JTextField[6];
        this.txFibre = new JTextField[6];
        this.rx0Fibre = new JTextField[6];
        this.rx1Fibre = new JTextField[6];
        int n2 = 0;
        while (n2 < 6) {
            JComponent jComponent;
            JPanel jPanel;
            Object object;
            int n3 = this.index * 6 + n2;
            JPanel jPanel2 = new JPanel();
            if (this.editable) {
                jPanel2.setBorder(BorderFactory.createTitledBorder("Position " + (n2 + 1)));
            }
            jPanel2.setLayout(new GridLayout(0, 1));
            try {
                object = new StringHolder();
                this.config.translateFromROD(this.rod.partition(), this.rod.crate(), this.rod.index(), n3, intHolder, intHolder2);
                this.config.translateToSN(intHolder.value, intHolder2.value, object);
                jPanel2.add(new JLabel(object.value));
            }
            catch (ConfigurationException configurationException) {
                jPanel = new JPanel();
                jPanel.add(new JLabel("No Module in position " + n2));
                jComponent = new JButton("Add");
                ((AbstractButton)jComponent).addActionListener(new AddActionListener(this.mur, n2));
                jPanel.add(jComponent);
                jPanel2.add(jPanel);
            }
            object = new int[144];
            try {
                jPanel = this.config.getBOCConfig(this.rod.partition(), this.rod.crate(), this.rod.index(), n3);
                if (!this.editable) {
                    jPanel2.add(new JLabel(((BOCChannelConfig)jPanel).current + " " + ((BOCChannelConfig)jPanel).delay + " " + ((BOCChannelConfig)jPanel).markSpace + " " + (int)object[n3 * 3]));
                    jPanel2.add(new JLabel(((BOCChannelConfig)jPanel).threshold0 + " " + ((BOCChannelConfig)jPanel).delay0));
                    jPanel2.add(new JLabel(((BOCChannelConfig)jPanel).threshold1 + " " + ((BOCChannelConfig)jPanel).delay1));
                } else {
                    jComponent = new JPanel();
                    jComponent.add(new JLabel("Current: "));
                    this.current[n2] = new JTextField("" + ((BOCChannelConfig)jPanel).current, 4);
                    jComponent.add(this.current[n2]);
                    jComponent.add(new JLabel(" Delay: "));
                    this.delay[n2] = new JTextField("" + ((BOCChannelConfig)jPanel).delay, 4);
                    jComponent.add(this.delay[n2]);
                    jComponent.add(new JLabel("MarkSpace: "));
                    this.markSpace[n2] = new JTextField("" + ((BOCChannelConfig)jPanel).markSpace, 4);
                    jComponent.add(this.markSpace[n2]);
                    jComponent.add(new JLabel("TX Fibre: "));
                    this.txFibre[n2] = new JTextField("" + (int)object[n3 * 3 + 0], 4);
                    jComponent.add(this.txFibre[n2]);
                    jPanel2.add(jComponent);
                    JPanel jPanel3 = new JPanel();
                    jPanel3.add(new JLabel("Threshold: "));
                    this.threshold0[n2] = new JTextField("" + ((BOCChannelConfig)jPanel).threshold0, 4);
                    jPanel3.add(this.threshold0[n2]);
                    jPanel3.add(new JLabel(" Delay: "));
                    this.delay0[n2] = new JTextField("" + ((BOCChannelConfig)jPanel).delay0, 4);
                    jPanel3.add(this.delay0[n2]);
                    jPanel2.add(jPanel3);
                    JPanel jPanel4 = new JPanel();
                    jPanel4.add(new JLabel("Threshold: "));
                    this.threshold1[n2] = new JTextField("" + ((BOCChannelConfig)jPanel).threshold1, 4);
                    jPanel4.add(this.threshold1[n2]);
                    jPanel4.add(new JLabel(" Delay: "));
                    this.delay1[n2] = new JTextField("" + ((BOCChannelConfig)jPanel).delay1, 4);
                    jPanel4.add(this.delay1[n2]);
                    jPanel2.add(jPanel4);
                    jPanel2.addAncestorListener(new CheckDispose(this, n2));
                }
            }
            catch (ConfigurationException configurationException) {
                jPanel2.add(new JLabel("No Configuration for BOC"));
            }
            this.add(jPanel2);
            ++n2;
        }
    }

    static String getFileName() {
        if (fileChooser == null) {
            fileChooser = new JFileChooser();
        }
        if (fileChooser.showDialog(null, "Pick module configuration file") == 0) {
            File file = fileChooser.getSelectedFile();
            return file.toString();
        }
        return null;
    }

    class AddActionListener
    implements ActionListener {
        int index;

        AddActionListener(int n, int n2) {
            this.index = n2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                String string = MURPanel.getFileName();
                if (string != null) {
                    MURPanel.this.config.configureModuleFromFile(string);
                }
            }
            catch (ConfigurationException configurationException) {
                System.out.println("Module not created: configuration " + (Object)((Object)configurationException));
                System.out.println("Failed to add module from file (" + MURPanel.this.mur + ":" + this.index + ")");
            }
        }
    }

    class CheckDispose
    implements AncestorListener {
        MURPanel mur;
        int index;

        public CheckDispose(MURPanel mURPanel2, int n) {
            this.index = n;
            this.mur = mURPanel2;
        }

        public void ancestorAdded(AncestorEvent ancestorEvent) {
        }

        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }

        public void ancestorRemoved(AncestorEvent ancestorEvent) {
            block5: {
                if (this.mur.mur < 0) break block5;
                BOCChannelConfig bOCChannelConfig = new BOCChannelConfig();
                try {
                    bOCChannelConfig.current = Short.parseShort(this.mur.current[this.index].getText());
                    bOCChannelConfig.delay = Short.parseShort(this.mur.delay[this.index].getText());
                    bOCChannelConfig.markSpace = Short.parseShort(this.mur.markSpace[this.index].getText());
                    bOCChannelConfig.threshold0 = Short.parseShort(this.mur.threshold0[this.index].getText());
                    bOCChannelConfig.delay0 = Short.parseShort(this.mur.delay0[this.index].getText());
                    bOCChannelConfig.threshold1 = Short.parseShort(this.mur.threshold1[this.index].getText());
                    bOCChannelConfig.delay1 = Short.parseShort(this.mur.delay1[this.index].getText());
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                int n = this.mur.index * 6 + this.index;
                try {
                    this.mur.config.configureBOCChannel(this.mur.mur, this.mur.index, bOCChannelConfig);
                }
                catch (ConfigurationException configurationException) {
                    System.out.println("Failed to update configuration for mur " + this.mur.mur);
                }
            }
        }
    }
}

