/*
 * Decompiled with CFR 0.152.
 */
package SctApi.conf.gui;

import SctApi.conf.gui.ModuleListView;
import SctApi.conf.gui.PhysicalView;
import SctApi.conf.gui.TreeView;
import ipc.Partition;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.Object;
import sctConf.Configuration;
import sctConf.ConfigurationException;
import sctConf.ConfigurationHelper;

public class ConfigGui
extends JFrame {
    private Configuration conf;
    private final ConfigGui finalGui = this;

    public static void main(String[] stringArray) {
        System.out.println("Hello world");
        ConfigGui configGui = new ConfigGui();
        configGui.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        configGui.pack();
        configGui.setVisible(true);
    }

    public ConfigGui() {
        super("Configuration GUI");
        this.connectServer();
        if (this.conf == null) {
            System.err.println("Error (check configuration running)");
            System.exit(0);
        }
        System.out.println("Found configuration");
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("Close");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigGui.this.dispose();
            }
        });
        jPanel.add(jButton);
        JButton jButton2 = new JButton("View Physical");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PhysicalView physicalView = new PhysicalView(ConfigGui.this.conf);
                physicalView.addWindowListener(new WindowAdapter(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void windowClosing(WindowEvent windowEvent) {
                        windowEvent.getWindow().dispose();
                    }
                });
                physicalView.pack();
                physicalView.setVisible(true);
            }
        });
        jPanel.add(jButton2);
        JButton jButton3 = new JButton("Tree View");
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TreeView treeView = new TreeView(ConfigGui.this.finalGui, ConfigGui.this.conf);
                treeView.addWindowListener(new WindowAdapter(this){
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void windowClosing(WindowEvent windowEvent) {
                        windowEvent.getWindow().dispose();
                    }
                });
                treeView.pack();
                treeView.setVisible(true);
            }
        });
        jPanel.add(jButton3);
        JButton jButton4 = new JButton("Module List");
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ModuleListView moduleListView = new ModuleListView(ConfigGui.this.conf);
                moduleListView.addWindowListener(new WindowAdapter(this){
                    private final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void windowClosing(WindowEvent windowEvent) {
                        windowEvent.getWindow().dispose();
                    }
                });
                moduleListView.pack();
                moduleListView.setVisible(true);
            }
        });
        jPanel.add(jButton4);
        JButton jButton5 = new JButton("Shutdown server");
        jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    System.out.println("Dump configuration");
                    ConfigGui.this.conf.saveConfiguration("Shutdown_Dump_From_ConfigGUI.xml");
                    System.out.println("Done");
                }
                catch (ConfigurationException configurationException) {
                    System.out.println("Shutdown xml dump failed");
                }
                ConfigGui.this.conf.destroy();
                ConfigGui.this.dispose();
                System.exit(0);
            }
        });
        jPanel.add(jButton5);
        JButton jButton6 = new JButton("Save configuration");
        jButton6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ConfigGui.this.conf.saveConfiguration("Dump_From_ConfigGUI.xml");
                }
                catch (ConfigurationException configurationException) {
                    System.out.println("Save configuration failed!");
                }
            }
        });
        jPanel.add(jButton6);
        JButton jButton7 = new JButton("Reload configuration");
        jButton7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ConfigGui.this.conf.loadConfiguration("");
                }
                catch (ConfigurationException configurationException) {
                    System.out.println("Load configuration failed!");
                }
            }
        });
        jPanel.add(jButton7);
        JButton jButton8 = new JButton("Reconnect");
        jButton8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigGui.this.connectServer();
            }
        });
        jPanel.add(jButton8);
        this.getContentPane().add((Component)jPanel, "South");
        System.out.println("Set up GUI, wait for it to run");
    }

    public void connectServer() {
        Partition partition = new Partition("SCT");
        try {
            Object object = partition.lookup("SCTConfigurationServer", "Test_Server");
            if (object == null) {
                System.out.println("Object SCTConfigurationServer not found in server Test_Server");
            }
            this.conf = ConfigurationHelper.narrow((Object)object);
        }
        catch (BAD_PARAM bAD_PARAM) {
            System.err.println("Couldn't get api object: " + (java.lang.Object)((java.lang.Object)bAD_PARAM));
        }
        catch (COMM_FAILURE cOMM_FAILURE) {
            System.err.println("CORBA communications error: " + (java.lang.Object)((java.lang.Object)cOMM_FAILURE));
        }
        catch (Exception exception) {
            System.err.println("Other error" + exception);
        }
    }

    public MyPartition getPartition(int n) {
        return new MyPartition(n);
    }

    public Crate getCrate(int n, int n2) {
        return new Crate(n, n2);
    }

    public Rod getRod(int n, int n2, int n3) {
        return new Rod(n, n2, n3);
    }

    public MUR getMUR(int n, int n2, int n3, int n4, int n5) {
        return new MUR(n, n2, n3, n4, n5);
    }

    public Module getModule(String string) {
        return new Module(string);
    }

    public class Module {
        String sn;

        Module(String string) {
            this.sn = string;
        }

        public String toString() {
            return this.sn;
        }

        public String getSN() {
            return this.sn;
        }

        public String getMUR() {
            try {
                IntHolder intHolder = new IntHolder();
                IntHolder intHolder2 = new IntHolder();
                ConfigGui.this.conf.translateFromSN(this.sn, intHolder, intHolder2);
                return "MUR: " + intHolder.value + " index: " + intHolder2.value;
            }
            catch (ConfigurationException configurationException) {
                return "No mapping to MUR";
            }
        }

        public String getPower() {
            try {
                IntHolder intHolder = new IntHolder();
                IntHolder intHolder2 = new IntHolder();
                ConfigGui.this.conf.translateFromSN(this.sn, intHolder, intHolder2);
                IntHolder intHolder3 = new IntHolder();
                IntHolder intHolder4 = new IntHolder();
                IntHolder intHolder5 = new IntHolder();
                ConfigGui.this.conf.translateToPowerSupply(intHolder.value, intHolder2.value, intHolder3, intHolder4, intHolder5);
                return "Power: " + intHolder3.value + " " + intHolder4.value + " " + intHolder5.value;
            }
            catch (ConfigurationException configurationException) {
                return "Power mapping undefined";
            }
        }

        public String getROD() {
            try {
                IntHolder intHolder = new IntHolder();
                IntHolder intHolder2 = new IntHolder();
                ConfigGui.this.conf.translateFromSN(this.sn, intHolder, intHolder2);
                IntHolder intHolder3 = new IntHolder();
                IntHolder intHolder4 = new IntHolder();
                IntHolder intHolder5 = new IntHolder();
                IntHolder intHolder6 = new IntHolder();
                ConfigGui.this.conf.translateToROD(intHolder.value, intHolder2.value, intHolder3, intHolder5, intHolder4, intHolder6);
                return "Partition: " + intHolder3.value + " Crate: " + intHolder4.value + " ROD: " + intHolder5.value + " Channel: " + intHolder6.value;
            }
            catch (ConfigurationException configurationException) {
                return "No mapping for ROD";
            }
        }

        public String getBarrel() {
            try {
                IntHolder intHolder = new IntHolder();
                IntHolder intHolder2 = new IntHolder();
                ConfigGui.this.conf.translateFromSN(this.sn, intHolder, intHolder2);
                IntHolder intHolder3 = new IntHolder();
                IntHolder intHolder4 = new IntHolder();
                IntHolder intHolder5 = new IntHolder();
                ConfigGui.this.conf.translateToBarrel(intHolder.value, intHolder2.value, intHolder3, intHolder4, intHolder5);
                return "Barrel: " + intHolder3.value + " Row: " + intHolder4.value + " Number: " + intHolder5.value;
            }
            catch (ConfigurationException configurationException) {
                return "No mapping for Barrel";
            }
        }
    }

    public class MUR {
        int m_MUR;
        int m_i;
        int m_p;
        int m_c;
        int m_r;

        MUR(int n, int n2, int n3, int n4, int n5) {
            this.m_MUR = n2;
            this.m_i = n;
            this.m_c = n4;
            this.m_p = n3;
            this.m_r = n5;
        }

        public int partition() {
            return this.m_p;
        }

        public int crate() {
            return this.m_c;
        }

        public int rod() {
            return this.m_r;
        }

        public int index() {
            return this.m_i;
        }

        public int id() {
            return this.m_MUR;
        }

        public String toString() {
            return "MUR " + this.m_MUR + " at " + this.m_i + " in " + this.m_p + " " + this.m_c + " " + this.m_r;
        }
    }

    public class Rod {
        int m_i;
        int p;
        int c;

        Rod(int n, int n2, int n3) {
            this.m_i = n;
            this.c = n2;
            this.p = n3;
        }

        public int partition() {
            return this.p;
        }

        public int crate() {
            return this.c;
        }

        public int index() {
            return this.m_i;
        }

        public String toString() {
            return "Rod " + this.p + " " + this.c + " " + this.m_i;
        }
    }

    public class Crate {
        int m_i;
        int p;

        Crate(int n, int n2) {
            this.m_i = n;
            this.p = n2;
        }

        public int index() {
            return this.m_i;
        }

        public int partition() {
            return this.p;
        }

        public String toString() {
            return "Crate " + this.p + " " + this.m_i;
        }
    }

    public class MyPartition {
        private int m_i;

        MyPartition(int n) {
            this.m_i = n;
        }

        public int index() {
            return this.m_i;
        }

        public String toString() {
            return "Partition " + this.m_i;
        }
    }
}

