/*
 * Decompiled with CFR 0.152.
 */
package Sct.IS;

import Sct.AbstractObjectManager;
import Sct.IS.AnyInfoAdapter;
import Sct.IS.IStreamIS;
import Sct.IS.NameIS;
import Sct.IS.OStreamIS;
import Sct.IS.SctNames;
import Sct.Name;
import Sct.Serializable;
import is.AnyInfo;
import is.Info;
import is.Istream;
import is.Ostream;
import is.Repository;
import java.io.IOException;
import java.io.InvalidClassException;

public class ObjectManagerIS
extends AbstractObjectManager {
    private static ObjectManagerIS instance = new ObjectManagerIS();

    protected ObjectManagerIS() {
    }

    public static ObjectManagerIS getInstance() {
        return instance;
    }

    public Serializable readObject(String string, String string2) throws IOException {
        ISObject iSObject = new ISObject(string2);
        NameIS nameIS = new NameIS(string2, string);
        Repository repository = SctNames.getISRepository();
        try {
            repository.getValue(nameIS.getName(), (Info)iSObject);
        }
        catch (RuntimeException runtimeException) {
            IOException iOException = new IOException("IS Exception trying to read " + nameIS.getName());
            iOException.initCause(runtimeException);
            throw iOException;
        }
        return iSObject.s;
    }

    public Name writeObject(Serializable serializable) throws IOException {
        ISObject iSObject = new ISObject(serializable);
        Repository repository = SctNames.getISRepository();
        NameIS nameIS = new NameIS(serializable);
        try {
            repository.insert(nameIS.getName(), (Info)iSObject);
        }
        catch (RuntimeException runtimeException) {
            IOException iOException = new IOException("IS Exception trying to write " + nameIS.getName());
            iOException.initCause(runtimeException);
            throw iOException;
        }
        return nameIS;
    }

    public Serializable readObject(String string) throws IOException {
        Repository repository = SctNames.getISRepository();
        try {
            NameIS nameIS = new NameIS(string);
            ISObject iSObject = new ISObject(nameIS.getClassName());
            repository.getValue(string, (Info)iSObject);
            return iSObject.s;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            AnyInfo anyInfo = new AnyInfo();
            try {
                repository.getValue(string, (Info)anyInfo);
                return new AnyInfoAdapter(anyInfo);
            }
            catch (RuntimeException runtimeException) {
                IOException iOException = new IOException("IS Exception trying to read " + string);
                iOException.initCause(runtimeException);
                throw iOException;
            }
        }
        catch (RuntimeException runtimeException) {
            IOException iOException = new IOException("IS Exception trying to read " + string);
            iOException.initCause(runtimeException);
            throw iOException;
        }
    }

    protected class ISObject
    extends Info {
        protected boolean bInConstructor = true;
        Serializable s;

        ISObject(Serializable serializable) {
            super(serializable.getClassName());
            this.s = serializable;
            this.bInConstructor = false;
        }

        ISObject(String string) {
            super(string);
            this.bInConstructor = false;
        }

        public void publishGuts(Ostream ostream) {
            if (this.bInConstructor) {
                return;
            }
            super.publishGuts(ostream);
            try {
                OStreamIS oStreamIS = new OStreamIS(ostream);
                ObjectManagerIS.this.writeClassName(oStreamIS, this.s.getClassName());
                this.s.write(oStreamIS, ObjectManagerIS.getInstance());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return;
            }
        }

        public void refreshGuts(Istream istream) {
            super.refreshGuts(istream);
            try {
                IStreamIS iStreamIS = new IStreamIS(istream);
                this.s = (Serializable)ObjectManagerIS.getInstance().createObject(iStreamIS, ObjectManagerIS.this.readClassName(iStreamIS));
            }
            catch (InvalidClassException invalidClassException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                illegalArgumentException.initCause(invalidClassException);
                throw illegalArgumentException;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
    }
}

