/*
 * Decompiled with CFR 0.152.
 */
package SctData;

import Sct.IStream;
import Sct.OStream;
import Sct.ObjectManager;
import Sct.Serializable;
import SctData.ModuleConfiguration;
import SctData.ScanHeader;
import SctData.ScanPoints;
import java.io.IOException;
import java.io.StreamCorruptedException;

public abstract class ScanResult
implements Serializable {
    protected ScanHeader header;
    protected ModuleConfiguration moduleConfig;
    protected ScanPoints points;

    public ScanResult(ScanHeader scanHeader, ModuleConfiguration moduleConfiguration, ScanPoints scanPoints) {
        this.header = scanHeader;
        this.moduleConfig = moduleConfiguration;
        this.points = scanPoints;
    }

    public ScanResult(ScanResult scanResult) {
    }

    public ScanHeader getHeader() {
        return this.header;
    }

    public ModuleConfiguration getConfiguration() {
        return this.moduleConfig;
    }

    public ScanPoints getPoints() {
        return this.points;
    }

    protected void _read(IStream iStream, ObjectManager objectManager) throws IOException {
        short s = iStream.readShort("Version");
        if (s != 0) {
            throw new StreamCorruptedException("Incorrect version of ScanResult.  Expected version 0 got: " + s);
        }
        this.header = (ScanHeader)objectManager.readObject(iStream, "Header", "SctData.ScanHeader");
        this.points = (ScanPoints)objectManager.readObject(iStream, "ScanPoints", "SctData.ScanPoints");
        this.moduleConfig = (ModuleConfiguration)objectManager.readObject(iStream, "Configuration", "SctData.ModuleConfiguration");
    }

    public void write(OStream oStream, ObjectManager objectManager) throws IOException {
        oStream.writeShort("Version", (short)0, false);
        objectManager.writeObject(oStream, "Header", this.header, false);
        objectManager.writeObject(oStream, "ScanPoints", this.points, false);
        objectManager.writeObject(oStream, "Configuration", this.moduleConfig, false);
    }

    protected ScanResult(IStream iStream, ObjectManager objectManager) throws IOException {
        this._read(iStream, objectManager);
    }
}

