/*
 * Decompiled with CFR 0.152.
 */
package SctData;

import Sct.IStream;
import Sct.OStream;
import Sct.ObjectManager;
import Sct.Serializable;
import SctData.ConfigurationVariable;
import java.io.IOException;

public class ScanHeader
implements Serializable {
    private int scanNumber;
    private int runNumber;
    private String moduleName;
    private ConfigurationVariable variable;

    public ScanHeader(int n, int n2, String string, ConfigurationVariable configurationVariable) {
        this.scanNumber = n2;
        this.runNumber = n;
        this.moduleName = string;
        this.variable = configurationVariable;
    }

    public String getClassName() {
        return "SctData.ScanHeader";
    }

    public String getUniqueID() {
        return ScanHeader.getUniqueID(this.runNumber, this.scanNumber, this.moduleName);
    }

    public static String getUniqueID(int n, int n2, String string) {
        return n + "." + n2 + "." + string;
    }

    public long getScanNumber() {
        return this.scanNumber;
    }

    public long getRunNumber() {
        return this.runNumber;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public ConfigurationVariable getVariable() {
        return this.variable;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ScanHeader)) {
            return false;
        }
        ScanHeader scanHeader = (ScanHeader)object;
        return this.scanNumber == scanHeader.scanNumber && this.runNumber == scanHeader.runNumber && this.moduleName.equals(scanHeader.moduleName);
    }

    public static ScanHeader read(IStream iStream, ObjectManager objectManager) throws IOException {
        int n = iStream.readInt("RunNumber");
        int n2 = iStream.readInt("ScanNumber");
        String string = iStream.readString("ModuleName");
        ConfigurationVariable configurationVariable = (ConfigurationVariable)objectManager.readObject(iStream, "ScanVariable", "SctData.ConfigurationVariable");
        return new ScanHeader(n, n2, string, configurationVariable);
    }

    public void write(OStream oStream, ObjectManager objectManager) throws IOException {
        oStream.writeInt("RunNumber", this.runNumber, false);
        oStream.writeInt("ScanNumber", this.scanNumber, false);
        oStream.writeString("ModuleName", this.moduleName);
        objectManager.writeObject(oStream, "ScanVariable", this.variable, false);
    }
}

