/*
 * Decompiled with CFR 0.152.
 */
package SctData;

import Sct.IStream;
import Sct.OStream;
import Sct.ObjectManager;
import Sct.Streamable;
import SctData.ModuleElement;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.util.HashMap;

public class ModuleDefect
implements Streamable,
Cloneable {
    private static HashMap defectMap = new HashMap(20);
    public static ModuleDefect DEAD = new ModuleDefect(1, true, "DEAD", "Dead channel - output always <1%", 0.01);
    public static ModuleDefect STUCKON = new ModuleDefect(2, true, "STUCKON", "Dead channel - output always > 98% occupancy", 0.98);
    public static ModuleDefect OVER = new ModuleDefect(4, false, "OVER", "Occupancy greater than 100%", 1.0);
    public static ModuleDefect UNDER = new ModuleDefect(3, true, "UNDER", "Occupancy never reaches 100%", 1.0);
    public static ModuleDefect NOINIT = new ModuleDefect(18, true, "NOINIT", "Couldn't initialize fit", 0.0);
    public static ModuleDefect FIT_UNDER = new ModuleDefect(5, true, "FIT_UNDER", "Fitted mean out of bounds low", 0.0);
    public static ModuleDefect FIT_OVER = new ModuleDefect(6, true, "FIT_OVER", "Fitted mean out of bounds high", 0.0);
    public static ModuleDefect SIG_UNDER = new ModuleDefect(7, true, "SIG_UNDER", "Fitted sigma out of bounds low", 0.0);
    public static ModuleDefect SIG_OVER = new ModuleDefect(8, true, "SIG_OVER", "Fitted sigma out of bounds high", 0.0);
    public static ModuleDefect LO_GAIN = new ModuleDefect(9, true, "LO_GAIN", "Gain is less than 0.75*chip average", 0.75);
    public static ModuleDefect HI_GAIN = new ModuleDefect(10, true, "HI_GAIN", "Gain is higher than 1.25*chip average", 1.25);
    public static ModuleDefect LO_OFFSET = new ModuleDefect(11, true, "LO_OFFSET", "Offset is less than -100", -100.0);
    public static ModuleDefect HI_OFFSET = new ModuleDefect(12, true, "HI_OFFSET", "Offset is higher than 12-", 120.0);
    public static ModuleDefect UNBONDED = new ModuleDefect(13, true, "UNBONDED", "Noise is less than 750", 750.0);
    public static ModuleDefect PARTBONDED = new ModuleDefect(14, false, "PARTBONDED", "Noise is less than 1100", 1100.0);
    public static ModuleDefect NOISY = new ModuleDefect(15, true, "NOISY", "Noise is > 1.15*chip average", 1.15);
    public static ModuleDefect TR_RANGE = new ModuleDefect(22, false, "TR_RANGE", "Unusual chip trim step size", 0.0);
    public static ModuleDefect TR_STEP = new ModuleDefect(23, false, "TR_STEP", "Channel trim step size different from chip", 4.0);
    public static ModuleDefect TR_OFFSET = new ModuleDefect(24, false, "TR_OFFSET", "Channel trim range offset different from chip", 4.0);
    public static ModuleDefect TR_NOTRIM = new ModuleDefect(25, true, "TR_NOTRIM", "Untrimmable channel", 0.0);
    public static ModuleDefect NO_HI = new ModuleDefect(19, true, "NO_HI", "High noise occupancy", 5.0E-4);
    public static ModuleDefect MEAN_ERROR = new ModuleDefect(16, true, "MEAN_ERROR", "Error in the mean", 0.0);
    public static ModuleDefect SIG_ERROR = new ModuleDefect(17, true, "SIG_ERROR", "Error in the sigma", 0.0);
    public static ModuleDefect STUCK_CELL = new ModuleDefect(21, false, "STUCK_CELL", "Stuck cell in the pipeline", 0.0);
    public static ModuleDefect DEAD_CELL = new ModuleDefect(20, false, "DEAD_CELL", "Dead cell in the pipeline", 0.0);
    private int id;
    private boolean severe;
    private String name;
    private String description;
    private double parameter;
    private ModuleElement element;

    public ModuleDefect(ModuleDefect moduleDefect, ModuleElement moduleElement) {
        this.id = moduleDefect.id;
        this.severe = moduleDefect.severe;
        this.name = moduleDefect.name;
        this.description = moduleDefect.description;
        this.parameter = moduleDefect.parameter;
        this.element = moduleElement;
    }

    public boolean isSevere() {
        return this.severe;
    }

    public ModuleElement getModuleElement() {
        return this.element;
    }

    public boolean isPrototype() {
        return this.element == null;
    }

    public boolean isUnfittable() {
        return this.isSameTypeAs(OVER) || this.isSameTypeAs(UNDER) || this.isSameTypeAs(STUCKON);
    }

    public boolean isUnuseable() {
        return this.isSameTypeAs(DEAD) || this.isSameTypeAs(STUCKON);
    }

    public boolean isDodgy() {
        return !this.isSameTypeAs(DEAD) && !this.isSameTypeAs(STUCKON);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public double getParameter() {
        return this.parameter;
    }

    public boolean isSameTypeAs(ModuleDefect moduleDefect) {
        return this.id == moduleDefect.id;
    }

    public boolean equals(Object object) {
        if (object instanceof ModuleDefect) {
            ModuleDefect moduleDefect = (ModuleDefect)object;
            if (moduleDefect.isPrototype() || this.isPrototype()) {
                return false;
            }
            return this.id == moduleDefect.id && this.element.equals(moduleDefect.element);
        }
        return false;
    }

    public String getClassName() {
        return "SctData.ModuleDefect";
    }

    public static ModuleDefect read(IStream iStream, ObjectManager objectManager) throws IOException {
        int n = iStream.readInt("Id");
        ModuleDefect moduleDefect = (ModuleDefect)defectMap.get(new Integer(n));
        if (moduleDefect == null) {
            throw new StreamCorruptedException("Can't create a ModuleDefect for id: " + n);
        }
        ModuleElement moduleElement = (ModuleElement)objectManager.readObject(iStream, "Element", "SctData.ModuleElement");
        ModuleDefect moduleDefect2 = new ModuleDefect(moduleDefect, moduleElement);
        return moduleDefect2;
    }

    public void write(OStream oStream, ObjectManager objectManager) throws IOException {
        oStream.writeInt("Id", this.id, false);
        objectManager.writeObject(oStream, "Element", this.element, false);
    }

    private ModuleDefect(int n, boolean bl, String string, String string2, double d) {
        this.id = n;
        this.severe = bl;
        this.name = string;
        this.description = this.description;
        this.parameter = d;
        defectMap.put(new Integer(n), this);
    }
}

