/*
 * Decompiled with CFR 0.152.
 */
package SctData;

import Sct.IStream;
import Sct.OStream;
import Sct.ObjectManager;
import Sct.Streamable;
import SctData.ChipOptions;
import java.io.IOException;
import sctConf.ABCDBasic;
import sctConf.ABCDCaldata;
import sctConf.ABCDChip;

public class ChipConfiguration
implements Streamable {
    ABCDChip data;
    ChipOptions options;

    public ChipConfiguration(ABCDChip aBCDChip) {
        this.data = aBCDChip;
        this.options = new ChipOptions(aBCDChip.basic.config);
    }

    public ABCDChip getData() {
        return this.data;
    }

    public ChipOptions getOptions() {
        return this.options;
    }

    public boolean isActive() {
        return this.data.active != 0;
    }

    public void setActive(boolean bl) {
        this.data.active = bl ? (byte)1 : 0;
    }

    public byte getAddress() {
        return this.data.address;
    }

    public byte getTrimTarget() {
        return this.data.target;
    }

    public void setTrimTarget(byte by) {
        this.data.target = by;
    }

    public byte getTrim(int n) {
        return this.data.trim[n];
    }

    public void setTrim(int n, byte by) throws IllegalArgumentException {
        if (by > 15 || by < 0) {
            throw new IllegalArgumentException("Trim must be 0->15, channel: " + n + " trim: " + by);
        }
        this.data.trim[n] = by;
    }

    public byte getThreshold() {
        return this.data.basic.vthr;
    }

    public void setThreshold(byte by) {
        this.data.basic.vthr = by;
    }

    public byte getCalCharge() {
        return this.data.basic.vcal;
    }

    public void setCalCharge(byte by) {
        this.data.basic.vcal = by;
    }

    public byte getStrobeDelay() {
        return this.data.basic.delay;
    }

    public void setStrobeDelay(byte by) throws IllegalArgumentException {
        if (by > 63 || by < 0) {
            throw new IllegalArgumentException("delay must be 0->63, delay: " + by);
        }
        this.data.basic.delay = by;
    }

    public void resetMask() {
        int n = 0;
        while (n < this.data.basic.mask.length) {
            this.data.basic.mask[n] = 0;
            ++n;
        }
    }

    public void setMask(int n, boolean bl) {
        if (bl) {
            this.mask(n);
        } else {
            this.unmask(n);
        }
    }

    public void mask(int n) {
        int n2 = n / 32;
        this.data.basic.mask[n2] = this.data.basic.mask[n2] & ~(1 << n % 32);
    }

    public void unmask(int n) {
        int n2 = n / 32;
        this.data.basic.mask[n2] = this.data.basic.mask[n2] | 1 << n % 32;
    }

    public boolean isMasked(int n) {
        return (this.data.basic.mask[n / 32] & 1 << n % 32) == 0;
    }

    public byte getRcFunctionIndex() {
        return this.data.caldata.rc_function;
    }

    public void setRcFunctionIndex(byte by) throws IllegalArgumentException {
        if (by > 4 || by <= 0) {
            throw new IllegalArgumentException("rcFunction must be 1->4, rcFunction: " + by);
        }
        this.data.caldata.rc_function = by;
    }

    public double getRcParam(int n) {
        return this.data.caldata.rc_params[n];
    }

    public void setRcParam(int n, double d) {
        this.data.caldata.rc_params[n] = (float)d;
    }

    public void setCalFactor(float f) {
        this.data.caldata.c_factor = f;
    }

    public float getCalFactor() {
        return this.data.caldata.c_factor;
    }

    public String getClassName() {
        return "SctData.ChipConfiguration";
    }

    public static Streamable read(IStream iStream, ObjectManager objectManager) throws IOException {
        ABCDChip aBCDChip = new ABCDChip();
        aBCDChip.basic = new ABCDBasic();
        aBCDChip.caldata = new ABCDCaldata();
        ChipConfiguration chipConfiguration = new ChipConfiguration(aBCDChip);
        chipConfiguration.readObject(iStream, objectManager);
        return chipConfiguration;
    }

    public void readObject(IStream iStream, ObjectManager objectManager) throws IOException {
        this.data.active = iStream.readByte("Active");
        this.data.address = iStream.readByte("Address");
        this.data.target = iStream.readByte("Target");
        this.options = (ChipOptions)objectManager.readObject(iStream, "ChipOptions", "SctData.ChipOptions");
        this.data.basic.config = this.options.getData();
        this.setThreshold(iStream.readByte("Threshold"));
        this.setCalCharge(iStream.readByte("CalCharge"));
        this.setStrobeDelay(iStream.readByte("Delay"));
        this.data.basic.preamp = iStream.readByte("Preamp");
        this.data.basic.shaper = iStream.readByte("Shaper");
        this.data.basic.mask = iStream.readIntArray("Masks");
        this.data.caldata.rc_function = iStream.readByte("RcFunction");
        this.data.caldata.rc_params = iStream.readFloatArray("RcParams");
        this.data.caldata.c_factor = iStream.readFloat("CalFactor");
        this.data.trim = iStream.readByteArray("Trims");
    }

    public void write(OStream oStream, ObjectManager objectManager) throws IOException {
        oStream.writeByte("Active", this.data.active, false);
        oStream.writeByte("Address", this.data.address, false);
        oStream.writeByte("Target", this.data.target, false);
        objectManager.writeObject(oStream, "ChipOptions", this.options, false);
        oStream.writeByte("Threshold", this.getThreshold(), false);
        oStream.writeByte("CalCharge", this.getCalCharge(), false);
        oStream.writeByte("Delay", this.getStrobeDelay(), false);
        oStream.writeByte("Preamp", this.data.basic.preamp, false);
        oStream.writeByte("Shaper", this.data.basic.shaper, false);
        oStream.writeIntArray("Masks", this.data.basic.mask, false);
        oStream.writeByte("RcFunction", this.data.caldata.rc_function, false);
        oStream.writeFloatArray("RcParams", this.data.caldata.rc_params);
        oStream.writeFloat("CalFactor", this.data.caldata.c_factor);
        oStream.writeByteArray("Trims", this.data.trim, false);
    }
}

