/*
 * Decompiled with CFR 0.152.
 */
package guiUtilities;

import guiUtilities.DaveUtils;
import guiUtilities.myTableAdapter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.BevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SpreadsheetViewer
extends JFrame
implements ActionListener,
ListSelectionListener {
    int selectedRow = 0;
    JButton saveButton;
    JButton closeButton;
    JLabel title;
    JScrollPane tableAggregate;
    JTable table;
    myTableAdapter resultTable;

    public SpreadsheetViewer() {
        super("Spreadsheet");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(Box.createRigidArea(new Dimension(0, 15)));
        this.title = new JLabel("Title", 0);
        this.title.setFont(new Font("SansSerif", 1, 14));
        this.title.setForeground(Color.blue);
        this.title.setAlignmentX(0.5f);
        jPanel.add(this.title);
        this.tableAggregate = this.createTable();
        this.tableAggregate.setBorder(new BevelBorder(1));
        jPanel.add(this.tableAggregate);
        jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(Box.createHorizontalGlue());
        this.saveButton = new JButton("Save Spreadsheet");
        this.saveButton.addActionListener(this);
        jPanel2.add(this.saveButton);
        jPanel2.add(Box.createHorizontalGlue());
        this.closeButton = new JButton("Create Report");
        this.closeButton.setEnabled(false);
        this.closeButton.addActionListener(this);
        jPanel2.add(this.closeButton);
        jPanel.add(jPanel2);
        this.setContentPane(jPanel);
        this.pack();
    }

    public void updateResultTable(Vector vector, String string) {
        this.title.setText(string);
        this.resultTable.reTable(vector);
        this.setVisible(true);
    }

    public Insets getInsets() {
        return new Insets(20, 20, 20, 20);
    }

    public JScrollPane createTable() {
        JScrollPane jScrollPane = new JScrollPane();
        try {
            this.resultTable = new myTableAdapter();
            this.table = new JTable(this.resultTable);
            this.table.setPreferredScrollableViewportSize(new Dimension(800, 150));
            this.table.setSelectionMode(0);
            ListSelectionModel listSelectionModel = this.table.getSelectionModel();
            listSelectionModel.addListSelectionListener(this);
            jScrollPane = new JScrollPane(this.table);
        }
        catch (Exception exception) {
            System.out.println("Error " + exception.toString());
        }
        return jScrollPane;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        Vector vector = new Vector();
        if (object == this.saveButton) {
            if (this.resultTable.recordCount == 0) {
                return;
            }
            JFileChooser jFileChooser = new JFileChooser();
            int n = jFileChooser.showSaveDialog(this);
            if (n != 0) {
                return;
            }
            File file = jFileChooser.getSelectedFile();
            DaveUtils.writeTXT(file, this.resultTable);
            return;
        }
        if (object == this.closeButton) {
            this.setVisible(false);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        if (!listSelectionModel.isSelectionEmpty()) {
            this.selectedRow = listSelectionModel.getMinSelectionIndex();
        }
    }
}

