/*
 * Decompiled with CFR 0.152.
 */
package guiUtilities;

import Preferences.PreferencesInterface;
import ProdDatabase.ReportDownloader;
import guiUtilities.DaveUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.net.URL;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HTMLViewer
extends JFrame
implements HyperlinkListener {
    private static HTMLViewer instance = new HTMLViewer();
    JLabel title;
    JScrollPane scrollPane;
    JEditorPane editorPane;
    JLabel linkText;
    JButton refreshButton;
    JButton closeButton;
    JButton backButton;
    JButton forwardButton;
    Vector htmlFileList;
    Vector captionList;
    Vector imageFileList;
    int htmlIndex = 0;
    int htmlCount = 0;
    JMenu captionMenu;
    String captionString;
    String htmlString;
    public static final int DATASHEET = 0;
    public static final int WEBLINK = 1;
    public static final int XYMETDATA = 2;
    public static final int ZMETDATA = 3;
    public static final int SENSORTESTDATA = 4;
    public static final int SCTDAQTESTDATA = 5;
    public static final int URLTOPOSTSCRIPT = 6;
    public static final int RAWDATA = 7;
    public static final int SCTDAQTESTLIST = 8;
    public static final int MODULESUMMARY = 9;

    private HTMLViewer() {
        super("Report");
        this.initComponents();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                HTMLViewer.this.close();
            }
        });
        this.htmlFileList = new Vector();
        this.captionList = new Vector();
        this.imageFileList = new Vector();
        this.captionMenu = new JMenu();
    }

    public static HTMLViewer getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Serializable serializable;
        int n = 0;
        while (n < this.htmlFileList.size()) {
            serializable = new File((String)this.htmlFileList.elementAt(n));
            if (((File)serializable).exists()) {
                System.out.println("Deleting " + ((File)serializable).getAbsolutePath());
                ((File)serializable).delete();
            }
            ++n;
        }
        serializable = this.imageFileList;
        synchronized (serializable) {
            int n2 = 0;
            while (n2 < this.imageFileList.size()) {
                File file = new File((String)this.imageFileList.elementAt(n2));
                if (file.exists()) {
                    System.out.println("Deleting " + file.getAbsolutePath());
                    file.delete();
                }
                ++n2;
            }
        }
    }

    private void initComponents() {
        this.editorPane = new JEditorPane();
        this.editorPane.setEditable(false);
        this.editorPane.addHyperlinkListener(this);
        this.editorPane.addMouseListener(new htmlViewerMouseAdapter());
        this.scrollPane = new JScrollPane(this.editorPane);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.setHorizontalScrollBarPolicy(32);
        this.scrollPane.setPreferredSize(new Dimension(600, 400));
        this.scrollPane.setMinimumSize(new Dimension(500, 400));
        this.title = new JLabel();
        this.linkText = new JLabel();
        this.refreshButton = new JButton();
        this.refreshButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HTMLViewer.this.refreshButtonActionPerformed(actionEvent);
            }
        });
        this.closeButton = new JButton();
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HTMLViewer.this.closeButtonActionPerformed(actionEvent);
            }
        });
        this.backButton = new JButton();
        this.backButton.setEnabled(false);
        this.backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HTMLViewer.this.backButtonActionPerformed(actionEvent);
            }
        });
        this.forwardButton = new JButton();
        this.forwardButton.setEnabled(false);
        this.forwardButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HTMLViewer.this.forwardButtonActionPerformed(actionEvent);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.title.setText("Caption to this report");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weighty = 0.1;
        this.getContentPane().add((Component)this.title, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.8;
        this.getContentPane().add((Component)this.scrollPane, gridBagConstraints);
        this.linkText.setText("Link:");
        this.linkText.setFont(new Font("Arial", 1, 10));
        this.linkText.setForeground(new Color(0, 0, 153));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 0.05;
        this.getContentPane().add((Component)this.linkText, gridBagConstraints);
        this.refreshButton.setText("Refresh");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.weighty = 0.05;
        this.getContentPane().add((Component)this.refreshButton, gridBagConstraints);
        this.backButton.setText(" < ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.25;
        this.getContentPane().add((Component)this.backButton, gridBagConstraints);
        this.forwardButton.setText(" > ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.25;
        this.getContentPane().add((Component)this.forwardButton, gridBagConstraints);
        this.closeButton.setText("Close");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.25;
        this.getContentPane().add((Component)this.closeButton, gridBagConstraints);
        this.pack();
    }

    public void show(String string, String string2) {
        this.captionString = string2;
        this.htmlString = string;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                String string = null;
                try {
                    URL uRL;
                    Object object;
                    if (!HTMLViewer.this.htmlString.startsWith("http")) {
                        object = "testreport_" + Integer.toString(HTMLViewer.this.htmlCount) + ".html";
                        File file = new File(PreferencesInterface.getInstance().getPreference(3), (String)object);
                        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                        bufferedWriter.write(HTMLViewer.this.htmlString);
                        bufferedWriter.close();
                        HTMLViewer.this.htmlFileList.addElement(file.getAbsolutePath());
                        string = "file:" + file.getAbsolutePath();
                        uRL = new URL(string);
                    } else {
                        uRL = new URL(HTMLViewer.this.htmlString);
                        HTMLViewer.this.htmlFileList.addElement(HTMLViewer.this.htmlString);
                    }
                    HTMLViewer.this.captionList.addElement(HTMLViewer.this.captionString);
                    HTMLViewer.this.htmlIndex = HTMLViewer.this.htmlFileList.size() - 1;
                    object = new JMenuItem(HTMLViewer.this.captionString);
                    ((JComponent)object).setFont(new Font("Arial", 0, 10));
                    HTMLViewer.this.captionMenu.add((JMenuItem)object);
                    ((AbstractButton)object).addActionListener(new ActionListener(this){
                        private final /* synthetic */ 6 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void actionPerformed(ActionEvent actionEvent) {
                            6.access$400(this.this$1).menuItemSelected(actionEvent);
                        }
                    });
                    HTMLViewer.this.editorPane.setPage(uRL);
                    HTMLViewer.this.title.setText(HTMLViewer.this.captionString);
                    HTMLViewer.this.setButtonStates();
                    HTMLViewer.this.setVisible(true);
                    ++HTMLViewer.this.htmlCount;
                }
                catch (Exception exception) {
                    System.out.println("Cant create URL..");
                }
            }

            static /* synthetic */ HTMLViewer access$400(6 var0) {
                return var0.HTMLViewer.this;
            }
        });
    }

    public void showExistingURL() {
        String string = (String)this.htmlFileList.elementAt(this.htmlIndex);
        try {
            URL uRL;
            if (!string.startsWith("http")) {
                string = "file:" + string;
                uRL = new URL(string);
            } else {
                uRL = new URL(string);
            }
            this.editorPane.setPage(uRL);
            this.title.setText((String)this.captionList.elementAt(this.htmlIndex));
            this.setButtonStates();
            this.setVisible(true);
        }
        catch (Exception exception) {
            System.out.println("Cant create report URL..");
        }
    }

    public Insets getInsets() {
        return new Insets(20, 20, 20, 20);
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        block27: {
            String string;
            int n;
            block26: {
                Pattern pattern = Pattern.compile("Type(\\d+)&ref=(.*)");
                Pattern pattern2 = Pattern.compile("weblink=(.*)");
                String string2 = hyperlinkEvent.getDescription();
                Matcher matcher = pattern.matcher(string2);
                if (!matcher.matches()) {
                    return;
                }
                n = Integer.parseInt(string2.substring(matcher.start(1), matcher.end(1)));
                string = string2.substring(matcher.start(2), matcher.end(2));
                if (hyperlinkEvent.getEventType() != HyperlinkEvent.EventType.ACTIVATED) break block26;
                switch (n) {
                    case 4: {
                        Vector<String> vector = new Vector<String>();
                        vector.addElement(string);
                        ReportDownloader reportDownloader = new ReportDownloader(4, vector);
                        if (reportDownloader.isOkToStart()) {
                            reportDownloader.start();
                            break;
                        }
                        break block27;
                    }
                    case 8: {
                        ReportDownloader reportDownloader = new ReportDownloader(8, string, 0);
                        if (reportDownloader.isOkToStart()) {
                            reportDownloader.start();
                            break;
                        }
                        break block27;
                    }
                    case 5: {
                        String[] stringArray = string.split("__");
                        ReportDownloader reportDownloader = new ReportDownloader(5, stringArray[0], Integer.parseInt(stringArray[1]));
                        if (reportDownloader.isOkToStart()) {
                            reportDownloader.start();
                            break;
                        }
                        break block27;
                    }
                    case 6: {
                        ReportDownloader reportDownloader = new ReportDownloader(6, string, 0);
                        if (reportDownloader.isOkToStart()) {
                            reportDownloader.start();
                            break;
                        }
                        break block27;
                    }
                    case 0: 
                    case 2: 
                    case 3: 
                    case 7: {
                        ReportDownloader reportDownloader = new ReportDownloader(7, string, 0);
                        if (reportDownloader.isOkToStart()) {
                            reportDownloader.start();
                            break;
                        }
                        break block27;
                    }
                }
                break block27;
            }
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                switch (n) {
                    case 0: {
                        this.linkText.setText("Link: Data sheet for " + string);
                        break;
                    }
                    case 2: {
                        this.linkText.setText("Link: XY metrology datasheet");
                        break;
                    }
                    case 3: {
                        this.linkText.setText("Link: Z metrology datasheet");
                        break;
                    }
                    case 1: 
                    case 6: {
                        this.linkText.setText("Link: " + string);
                        break;
                    }
                    case 4: {
                        this.linkText.setText("Link: Sensor test data for " + string);
                        break;
                    }
                    case 8: {
                        this.linkText.setText("Link: Report of all SCTDAQ tests");
                        break;
                    }
                    case 5: {
                        this.linkText.setText("Link: Full SCTDAQ test report");
                        break;
                    }
                    case 7: {
                        this.linkText.setText("Link: Raw Data for SCTDB test no " + string);
                        break;
                    }
                    default: {
                        this.linkText.setText("Link: unrecognised");
                        break;
                    }
                }
            } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.EXITED) {
                this.linkText.setText("Link:");
            }
        }
    }

    private void refreshButtonActionPerformed(ActionEvent actionEvent) {
        try {
            String string = (String)this.htmlFileList.elementAt(this.htmlIndex);
            Pattern pattern = Pattern.compile("(.*testreport_)\\d+\\.html");
            Matcher matcher = pattern.matcher(string);
            if (matcher.matches()) {
                String string2 = string.substring(matcher.start(1), matcher.end(1)) + Integer.toString(this.htmlCount) + ".html";
                DaveUtils.copyFile(string, string2);
                new File(string).delete();
                this.htmlFileList.setElementAt(string2, this.htmlIndex);
                ++this.htmlCount;
            }
            this.showExistingURL();
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
        }
    }

    private void closeButtonActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    private void forwardButtonActionPerformed(ActionEvent actionEvent) {
        ++this.htmlIndex;
        this.showExistingURL();
    }

    private void backButtonActionPerformed(ActionEvent actionEvent) {
        --this.htmlIndex;
        this.showExistingURL();
    }

    private void setButtonStates() {
        this.forwardButton.setEnabled(this.htmlIndex < this.htmlFileList.size() - 1);
        this.backButton.setEnabled(this.htmlIndex > 0);
    }

    private void printState() {
        System.out.println("htmlIndex=" + this.htmlIndex + ", #=" + this.htmlFileList.size());
        int n = 0;
        while (n < this.htmlFileList.size()) {
            System.out.println("Caption: " + (String)this.captionList.elementAt(n) + " URL: " + (String)this.htmlFileList.elementAt(n));
            ++n;
        }
    }

    public void menuItemSelected(ActionEvent actionEvent) {
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        String string = jMenuItem.getText();
        int n = 0;
        while (n < this.captionList.size()) {
            if (((String)this.captionList.elementAt(n)).equals(string)) {
                this.htmlIndex = n;
                this.showExistingURL();
                break;
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImageFile(String string) {
        Vector vector = this.imageFileList;
        synchronized (vector) {
            this.imageFileList.addElement(string);
        }
    }

    class htmlViewerMouseAdapter
    extends MouseAdapter {
        htmlViewerMouseAdapter() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            switch (mouseEvent.getModifiers()) {
                case 4: 
                case 8: {
                    JPopupMenu jPopupMenu = HTMLViewer.this.captionMenu.getPopupMenu();
                    jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    jPopupMenu.setInvoker(HTMLViewer.this.captionMenu);
                    break;
                }
            }
        }
    }
}

