/*
 * Decompiled with CFR 0.152.
 */
package SummaryReader;

import SummaryReader.DAQInfo;
import SummaryReader.DataBlock;
import SummaryReader.DefectInfo;
import SummaryReader.ScanInfo;
import SummaryReader.TestInfo;
import java.util.Vector;

public class Test {
    String[] dataValues = new String[12];
    Vector comments;
    String noDefects;
    String testStatus;
    Vector dataBlockList = new Vector();
    Vector defectList = new Vector();
    TestInfo testInfo;
    DAQInfo daqInfo;
    ScanInfo scanInfo;
    String testType;
    String serialNo;

    public Test() {
        this.comments = new Vector();
    }

    public void add(DataBlock dataBlock) {
        this.dataBlockList.add(dataBlock);
    }

    public void add(DefectInfo defectInfo) {
        this.defectList.add(defectInfo);
    }

    public void add(TestInfo testInfo) {
        this.testInfo = testInfo;
    }

    public void add(ScanInfo scanInfo) {
        this.scanInfo = scanInfo;
    }

    public void add(DAQInfo dAQInfo) {
        this.daqInfo = dAQInfo;
    }

    public TestInfo getTestInfo() {
        return this.testInfo;
    }

    public DAQInfo getDAQInfo() {
        return this.daqInfo;
    }

    public ScanInfo getScanInfo() {
        return this.scanInfo;
    }

    public int noDataBlocks() {
        return this.dataBlockList.size();
    }

    public DataBlock getDataBlock(int n) {
        return (DataBlock)this.dataBlockList.elementAt(n);
    }

    public int noDefects() {
        return this.defectList.size();
    }

    public DefectInfo getDefectInfo(int n) {
        return (DefectInfo)this.defectList.elementAt(n);
    }

    public String getDefectSummaryTable() {
        StringBuffer stringBuffer = new StringBuffer("<h3>Defect Info</h3>\n");
        if (this.defectList.size() == 0) {
            stringBuffer.append("No defects");
            return stringBuffer.toString();
        }
        stringBuffer.append("<table border=1>\n");
        stringBuffer.append("<tr><td>Channel(s)</td><td>Defect</td></tr>\n");
        int n = 0;
        while (n < this.defectList.size()) {
            String string;
            DefectInfo defectInfo = (DefectInfo)this.defectList.elementAt(n);
            String string2 = defectInfo.getFirstChannel();
            String string3 = string2.equals(string = defectInfo.getLastChannel()) ? string2 : string2 + "-" + string;
            stringBuffer.append("<tr><td>" + string3 + "</td><td>" + defectInfo.getName() + "</td></tr>");
            ++n;
        }
        stringBuffer.append("</table>\n");
        return stringBuffer.toString();
    }

    public void setTestType(String string) {
        this.testType = this.testType;
    }

    public void addDefectStripCount(String string) {
        this.noDefects = string;
    }

    public void addTestStatus(String string) {
        this.testStatus = string;
    }

    public String getTestStatus() {
        if (this.testStatus == null) {
            return null;
        }
        return this.testStatus;
    }

    public String getDefectiveStripCount() {
        if (this.noDefects == null) {
            return null;
        }
        return this.noDefects;
    }

    public void setSerialNo(String string) {
        this.serialNo = string;
    }

    public String getSerialNo() {
        return this.serialNo;
    }

    public void setData(int n, String string) {
        this.dataValues[n] = string;
    }

    public String getData(int n) {
        if (--n == -1) {
            double d = 0.0;
            int n2 = 0;
            while (n2 < this.dataValues.length) {
                double d2 = Double.parseDouble(this.dataValues[n2]);
                if (d2 > d) {
                    d = d2;
                }
                ++n2;
            }
            return Double.toString(d);
        }
        return this.dataValues[n];
    }

    public void addComment(String string) {
        this.comments.addElement(string);
    }

    public String getComment(int n) {
        return (String)this.comments.elementAt(n);
    }

    public String getCommentsSummary() {
        StringBuffer stringBuffer = new StringBuffer("<h3>Comments</h3>\n");
        if (this.comments.size() == 0) {
            stringBuffer.append("None");
            return stringBuffer.toString();
        }
        int n = 0;
        while (n < this.comments.size()) {
            stringBuffer.append((String)this.comments.elementAt(n) + "\n");
            ++n;
        }
        return stringBuffer.toString();
    }
}

