/*
 * Decompiled with CFR 0.152.
 */
package ProdDatabase;

import ProdDatabase.GeneralUtilities;
import ProdDatabase.HTMLReportUtilities;
import guiUtilities.DaveUtils;
import guiUtilities.HTMLViewer;
import guiUtilities.RawDataViewer;
import java.net.URL;
import java.util.Vector;
import javax.swing.JOptionPane;

public class ReportDownloader
extends Thread {
    int reportType;
    String parameter1;
    int parameter2;
    Vector deviceList;
    boolean alreadyRunning = false;
    private final String thisThreadName = "SCTDB_DOWNLOAD";

    public ReportDownloader(int n, String string, int n2) {
        super("SCTDB_DOWNLOAD");
        this.reportType = n;
        this.parameter1 = string;
        this.parameter2 = n2;
        this.setPriority(1);
    }

    public ReportDownloader(int n, Vector vector) {
        super("SCTDB_DOWNLOAD");
        this.reportType = n;
        this.deviceList = vector;
        this.setPriority(1);
    }

    public boolean isOkToStart() {
        Thread[] threadArray = new Thread[Thread.activeCount()];
        Thread.enumerate(threadArray);
        int n = 0;
        while (n < threadArray.length) {
            if (threadArray[n] != null && threadArray[n].getName().equals("SCTDB_DOWNLOAD") && threadArray[n].isAlive()) {
                System.out.println("***A download from SCTDB is already in progress. Please wait...");
                return false;
            }
            ++n;
        }
        return true;
    }

    public void run() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.reportType) {
            case 5: {
                String string = this.parameter1;
                int n = this.parameter2;
                try {
                    String string2 = HTMLReportUtilities.getHTMLTestInfo(this.parameter1);
                    if (string2 == null) {
                        JOptionPane.showMessageDialog(null, "No SCTDB data for this test number", "No Data", 1);
                        return;
                    }
                    stringBuffer.append(DaveUtils.getHTMLHeader(string2));
                    stringBuffer.append(string2);
                    stringBuffer.append(HTMLReportUtilities.getHTMLCommentsTable(string));
                    stringBuffer.append(HTMLReportUtilities.getHTMLDAQTable(string));
                    stringBuffer.append(HTMLReportUtilities.getHTMLDCSTable(string));
                    stringBuffer.append(HTMLReportUtilities.getHTMLScanTable(string));
                    stringBuffer.append(HTMLReportUtilities.getSCTDAQHTMLTestData(string, n));
                    stringBuffer.append(HTMLReportUtilities.getHTMLDefectTable(string));
                    stringBuffer.append(HTMLReportUtilities.getHTMLPlotTable(string));
                    stringBuffer.append(DaveUtils.getHTMLFooter());
                    HTMLViewer.getInstance().show(stringBuffer.toString(), string2);
                }
                catch (Exception exception) {
                    System.out.println("Exception writing html report: " + exception.toString());
                }
                break;
            }
            case 8: {
                String[] stringArray = this.parameter1.split("__");
                String string = stringArray[3] + " SCTDAQ Tests of " + stringArray[0] + " at " + stringArray[1] + " on " + stringArray[2];
                try {
                    stringBuffer.append(DaveUtils.getHTMLHeader(string));
                    stringBuffer.append(HTMLReportUtilities.getHTMLModuleSummaryData(this.parameter1));
                    stringBuffer.append(DaveUtils.getHTMLFooter());
                    HTMLViewer.getInstance().show(stringBuffer.toString(), string);
                }
                catch (Exception exception) {
                    System.out.println("Exception writing html report: " + exception.toString());
                }
                break;
            }
            case 9: {
                String string = HTMLReportUtilities.getModuleReport(this.parameter1);
                if (string == null) {
                    return;
                }
                HTMLViewer.getInstance().show(string, "Summary Report for Module " + this.parameter1);
                break;
            }
            case 4: {
                if (this.deviceList.size() < 1) {
                    return;
                }
                StringBuffer stringBuffer2 = new StringBuffer((String)this.deviceList.elementAt(0));
                int n = 1;
                while (n < this.deviceList.size()) {
                    stringBuffer2.append("," + (String)this.deviceList.elementAt(n));
                    ++n;
                }
                try {
                    stringBuffer.append(DaveUtils.getHTMLHeader("Test Report for Sensor(s) " + stringBuffer2.toString()));
                    stringBuffer.append(HTMLReportUtilities.getSensorMfrHTMLTable(this.deviceList));
                    stringBuffer.append(HTMLReportUtilities.getSensorIVHTMLTable(this.deviceList));
                    stringBuffer.append(HTMLReportUtilities.getSensorDepletionHTMLTable(this.deviceList));
                    stringBuffer.append(HTMLReportUtilities.getSensorDefectHTMLTable(this.deviceList));
                    stringBuffer.append(HTMLReportUtilities.getSensorVisualTestHTMLTable(this.deviceList));
                    stringBuffer.append(DaveUtils.getHTMLFooter());
                    HTMLViewer.getInstance().show(stringBuffer.toString(), "Sensor Test Report for " + stringBuffer2.toString());
                }
                catch (Exception exception) {
                    System.out.println("ERROR: Exception writing sensor test report: " + exception.toString());
                }
                break;
            }
            case 6: {
                try {
                    GeneralUtilities.downloadPSFile(null, new URL(this.parameter1));
                }
                catch (Exception exception) {
                    System.out.println("ERROR: Exception downloading/displaying postscript: " + exception.toString());
                }
                break;
            }
            case 7: {
                try {
                    Vector vector = GeneralUtilities.getRawData(this.parameter1);
                    if (vector.size() <= 0) break;
                    String string = HTMLReportUtilities.getHTMLTestInfo(this.parameter1);
                    RawDataViewer.getInstance().showNewData(vector, "Raw Data for " + string);
                }
                catch (Exception exception) {
                    System.out.println("ERROR: Exception downloading raw data: " + exception.toString());
                }
                break;
            }
        }
    }
}

