/*
 * Decompiled with CFR 0.152.
 */
package ProdDatabase;

import ProdDatabase.SCTDAQCharacterisation;
import ProdDatabase.SCTDBInfo;
import ProdDatabase.SCTDBInterface;
import guiUtilities.DaveUtils;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.Vector;

public class ModuleSCTDAQInfo
implements SCTDBInfo {
    Statement statement;
    ResultSet resultSet;
    StringBuffer sqlStat;
    SCTDBInterface db;
    String moduleSerialNo;
    Vector Tests;
    DecimalFormat ivFormatter = new DecimalFormat("#.###");
    DecimalFormat temperatureFormatter = new DecimalFormat("#.#");

    public ModuleSCTDAQInfo(String string) {
        this.moduleSerialNo = string;
        this.Tests = new Vector();
        this.db = SCTDBInterface.getInstance();
        try {
            this.getCharacterisationList();
            this.getDefects();
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
        }
    }

    public int noTests() {
        return this.Tests.size();
    }

    public SCTDAQCharacterisation getCharacterisation(int n) {
        return (SCTDAQCharacterisation)this.Tests.elementAt(n);
    }

    private void getCharacterisationList() throws Exception {
        if (!this.db.isConnected()) {
            throw new Exception("No database connection");
        }
        StringBuffer stringBuffer = new StringBuffer("SELECT tests.ser_no,tests.locn_name,tests.test_date,sct_tstdcsinfo.T0,sct_tstdcsinfo.T1");
        stringBuffer.append(" FROM tests,sct_tstdcsinfo");
        stringBuffer.append(" WHERE tests.ser_no = " + this.moduleSerialNo);
        stringBuffer.append(" AND tests.test_name = 'HybRC'");
        stringBuffer.append(" AND sct_tstdcsinfo.test_no=tests.test_no");
        stringBuffer.append(" ORDER BY tests.test_date,tests.test_no");
        this.statement = this.db.connection.createStatement();
        this.resultSet = this.statement.executeQuery(stringBuffer.toString());
        boolean bl = this.resultSet.next();
        while (bl) {
            String string = this.resultSet.getString(1);
            String string2 = this.resultSet.getString(2);
            String string3 = DaveUtils.extractDate(this.resultSet.getString(3));
            double d = Double.parseDouble(this.resultSet.getString(4));
            double d2 = Double.parseDouble(this.resultSet.getString(5));
            double d3 = d2 != 128.0 ? d - d2 : 0.0;
            SCTDAQCharacterisation sCTDAQCharacterisation = new SCTDAQCharacterisation(string2, string3, d, d3);
            this.Tests.addElement(sCTDAQCharacterisation);
            bl = this.resultSet.next();
        }
        this.statement.close();
    }

    private void getDefects() throws Exception {
        int n = 0;
        while (n < this.Tests.size()) {
            boolean bl;
            SCTDAQCharacterisation sCTDAQCharacterisation = (SCTDAQCharacterisation)this.Tests.elementAt(n);
            String string = sCTDAQCharacterisation.getLocation();
            String string2 = sCTDAQCharacterisation.getDate();
            boolean bl2 = bl = sCTDAQCharacterisation.getTemperature() > 10.0;
            if (!this.db.isConnected()) {
                throw new Exception("No database connection");
            }
            StringBuffer stringBuffer = new StringBuffer("SELECT chan_1st,chan_last,defect_name");
            stringBuffer.append(" FROM tests,defects,sct_tstdcsinfo");
            stringBuffer.append(" WHERE tests.ser_no = " + this.moduleSerialNo);
            stringBuffer.append(" AND tests.test_name LIKE 'Hyb%'");
            stringBuffer.append(" AND defects.test_no=tests.test_no AND sct_tstdcsinfo.test_no=tests.test_no");
            stringBuffer.append(" AND tests.test_date='" + string2 + "'");
            if (bl) {
                stringBuffer.append(" AND sct_tstdcsinfo.T0>10");
            } else {
                stringBuffer.append(" AND sct_tstdcsinfo.T0<=10");
            }
            stringBuffer.append(" ORDER BY tests.test_date,tests.test_no");
            this.statement = this.db.connection.createStatement();
            this.resultSet = this.statement.executeQuery(stringBuffer.toString());
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            Hashtable<Integer, String> hashtable = new Hashtable<Integer, String>();
            Hashtable<Integer, String> hashtable2 = new Hashtable<Integer, String>();
            boolean bl3 = this.resultSet.next();
            while (bl3) {
                String string3 = this.resultSet.getString(1);
                String string4 = this.resultSet.getString(2);
                String string5 = this.resultSet.getString(3);
                boolean bl4 = string5.indexOf("TR_") != -1;
                int n6 = Integer.parseInt(string3);
                int n7 = Integer.parseInt(string4);
                int n8 = n7 - n6 + 1;
                if (n8 > n3) {
                    n3 = n8;
                }
                if (!bl4 && n8 > n5) {
                    n5 = n8;
                }
                int n9 = n6;
                while (n9 <= n7) {
                    Integer n10 = new Integer(n9);
                    if (!hashtable.containsKey(n10)) {
                        hashtable.put(n10, "1");
                        ++n2;
                    }
                    if (!bl4 && !hashtable2.containsKey(n10)) {
                        hashtable2.put(n10, "1");
                        ++n4;
                    }
                    ++n9;
                }
                bl3 = this.resultSet.next();
            }
            sCTDAQCharacterisation.setDefects(0, n2);
            sCTDAQCharacterisation.setDefects(1, n3);
            sCTDAQCharacterisation.setDefects(2, n4);
            sCTDAQCharacterisation.setDefects(3, n5);
            this.Tests.setElementAt(sCTDAQCharacterisation, n);
            this.statement.close();
            ++n;
        }
    }
}

