/*
 * Decompiled with CFR 0.152.
 */
package Preferences;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;

public class PreferencesInterface {
    private static PreferencesInterface instance = new PreferencesInterface();
    File preferencesFile = new File(System.getProperty("user.home"), "guiprefs.dat");
    private String[] keys = new String[]{"INSTITUTE%", "UPLOADDIR%", "PSVIEWER%", "SCRATCHDIR%"};
    private String[] titles = new String[]{"SCTDB Upload Institute", "SCTDB Upload Directory", "Postscript file Viewer", "Scratch Disk"};
    private String[] values;
    public static final int INSTITUTE = 0;
    public static final int UPLOAD_DIR = 1;
    public static final int PSVIEWER = 2;
    public static final int SCRATCH_DIR = 3;

    private PreferencesInterface() {
        this.Refresh();
    }

    public static PreferencesInterface getInstance() {
        return instance;
    }

    public void Refresh() {
        this.values = new String[this.keys.length];
        int n = 0;
        while (n < this.values.length) {
            this.values[n] = new String("Not defined");
            ++n;
        }
        this.readpreferencesFile();
        if (this.values[3].equals("Not defined")) {
            this.setPreference(3, System.getProperty("user.home"));
        }
        if (this.values[1].equals("Not defined")) {
            this.setPreference(1, System.getProperty("user.home"));
        }
    }

    public String getPreference(int n) {
        return this.values[n];
    }

    public String getDescription(int n) {
        return this.titles[n];
    }

    public void setPreference(int n, String string) {
        this.values[n] = string;
        this.writepreferencesFile();
    }

    public int getNoPreferences() {
        return this.keys.length;
    }

    public void readpreferencesFile() {
        try {
            String string;
            if (!this.preferencesFile.exists()) {
                return;
            }
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.preferencesFile));
            block2: while ((string = bufferedReader.readLine()) != null) {
                int n = 0;
                while (n < this.keys.length) {
                    if (string.indexOf(this.keys[n]) != -1) {
                        this.values[n] = string.substring(this.keys[n].length());
                        continue block2;
                    }
                    ++n;
                }
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            System.out.println("Failed to read Preferences file " + this.preferencesFile.toString() + " properly. It appears to be corrupted!.");
        }
    }

    public void writepreferencesFile() {
        block5: {
            File file = new File(System.getProperty("user.home"), "temp.dat");
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                int n = 0;
                while (n < this.keys.length) {
                    bufferedWriter.write(this.keys[n] + this.values[n]);
                    bufferedWriter.newLine();
                    ++n;
                }
                bufferedWriter.close();
                boolean bl = true;
                if (this.preferencesFile.exists()) {
                    bl = this.preferencesFile.delete();
                }
                if (!bl) break block5;
                file.renameTo(this.preferencesFile);
                if (this.preferencesFile.exists()) {
                    file.delete();
                    break block5;
                }
                System.out.println("Preferences file lost!! Backup is at " + file.toString());
            }
            catch (Exception exception) {
                System.out.println("Cant update preferences file");
            }
        }
    }
}

