/*
 * Decompiled with CFR 0.152.
 */
package DisplayGUI;

import DisplayGUI.SCTDB_Data;
import DisplayGUI.TestDataInfo;
import ProdDatabase.SCTDBInfo;
import ProdDatabase.SCTDBInterface;
import Sct.IS.SctNames;
import guiUtilities.DaveUtils;
import is.Info;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SCTDBTestDownloader
extends Thread
implements SCTDBInfo,
TestDataInfo {
    Vector listOfModules;
    int testIndex;
    String location;
    boolean isWarm;
    boolean refresh;
    boolean download;

    public SCTDBTestDownloader(Vector vector, int n, String string, boolean bl, boolean bl2) {
        super("SCTDB_DOWNLOAD");
        this.listOfModules = vector;
        this.testIndex = n;
        this.location = string;
        this.isWarm = bl;
        this.refresh = bl2;
        this.download = true;
        int n2 = vector.size() - 1;
        while (n2 >= 0) {
            String string2 = (String)vector.elementAt(n2);
            String string3 = "SCTDBData." + TestDataInfo.testNames[n] + "." + string + "." + (String)vector.elementAt(n2);
            if (SctNames.getISRepository().contains(string3) && !bl2) {
                this.download = false;
                break;
            }
            --n2;
        }
        if (n == 12) {
            this.download = false;
        }
        this.setPriority(1);
    }

    public boolean downloadsRequired() {
        return this.download;
    }

    public boolean isOkToStart() {
        Thread[] threadArray = new Thread[Thread.activeCount()];
        Thread.enumerate(threadArray);
        int n = 0;
        while (n < threadArray.length) {
            if (threadArray[n] != null && threadArray[n].getName().equals("SCTDB_DOWNLOAD") && threadArray[n].isAlive()) {
                System.out.println("***A download from SCTDB is already in progress. Please wait...");
                return false;
            }
            ++n;
        }
        return true;
    }

    public void run() {
        block43: {
            CharSequence charSequence;
            Hashtable<String, SCTDB_Data> hashtable = new Hashtable<String, SCTDB_Data>();
            Hashtable hashtable2 = new Hashtable();
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < this.listOfModules.size()) {
                if (n > 0) {
                    stringBuffer.append(",");
                }
                if (((String)(charSequence = (String)this.listOfModules.elementAt(n))).equals("SCTTestAPI_PseudoModule")) {
                    stringBuffer.append("20220330200020");
                } else {
                    stringBuffer.append((String)charSequence);
                }
                ++n;
            }
            System.out.println("SCTDB: Downloading " + this.listOfModules.size() + " module " + TestDataInfo.testNames[this.testIndex] + " tests.");
            charSequence = new StringBuffer();
            charSequence = new StringBuffer("SELECT tests.ser_no,tests.pass,tests.problem,tests.TEST_no,tests.locn_name,tests.TEST_date");
            switch (this.testIndex) {
                case 0: 
                case 1: 
                case 10: 
                case 11: {
                    break;
                }
                default: {
                    int n2 = 0;
                    while (n2 < SCTDBInfo.chipDBnames.length) {
                        int n3 = 0;
                        while (n3 < SCTDBInfo.DBChipParameterNames[this.testIndex].length) {
                            ((StringBuffer)charSequence).append("," + SCTDBInfo.chipDBnames[n2] + SCTDBInfo.DBChipParameterNames[this.testIndex][n3]);
                            ++n3;
                        }
                        ++n2;
                    }
                    break block1;
                }
            }
            ((StringBuffer)charSequence).append(" FROM " + SCTDBInfo.sctdaqDBTableNames[this.testIndex] + ",tests,sct_tstdcsinfo");
            ((StringBuffer)charSequence).append(" WHERE tests.TEST_name = '" + SCTDBInfo.sctdaqDBTestNames[this.testIndex] + "'");
            ((StringBuffer)charSequence).append(" AND tests.ser_no IN (" + stringBuffer.toString() + ")");
            if (!this.location.equals("Any")) {
                ((StringBuffer)charSequence).append(" AND tests.locn_name LIKE '" + this.location + "'");
            }
            ((StringBuffer)charSequence).append(" AND tests.TEST_no = " + SCTDBInfo.sctdaqDBTableNames[this.testIndex] + ".TEST_no");
            if (this.isWarm) {
                ((StringBuffer)charSequence).append(" AND sct_tstdcsinfo.t0>10 AND sct_tstdcsinfo.TEST_no=tests.TEST_no");
            } else {
                ((StringBuffer)charSequence).append(" AND sct_tstdcsinfo.t0<=10 AND sct_tstdcsinfo.TEST_no=tests.TEST_no");
            }
            ((StringBuffer)charSequence).append(" ORDER BY tests.TEST_date DESC,tests.TEST_no DESC");
            try {
                int n4;
                int n5;
                int n6;
                Statement statement = SCTDBInterface.getInstance().connection.createStatement();
                ResultSet resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
                boolean bl = resultSet.next();
                while (bl) {
                    String string;
                    int n7 = 1;
                    if (!hashtable.containsKey(string = resultSet.getString(n7++))) {
                        int n8;
                        int n9 = n8 = resultSet.getString(n7++).equals("YES") ? 0 : 2;
                        if (n8 == 0 && resultSet.getString(n7++).equals("YES")) {
                            n8 = 1;
                        }
                        SCTDB_Data sCTDB_Data = new SCTDB_Data();
                        sCTDB_Data.status = n8;
                        sCTDB_Data.testIndex = this.testIndex;
                        sCTDB_Data.testNumber = resultSet.getString(n7++);
                        sCTDB_Data.testLocation = resultSet.getString(n7++);
                        sCTDB_Data.testDate = DaveUtils.extractDate(resultSet.getString(n7++));
                        System.out.println("Downloading " + TestDataInfo.testNames[this.testIndex] + " for " + string + " taken by " + sCTDB_Data.testLocation + " on " + sCTDB_Data.testDate);
                        sCTDB_Data.data_m0 = new String[SCTDBInfo.DBChipParameterNames[this.testIndex].length];
                        int n10 = 0;
                        while (n10 < SCTDBInfo.DBChipParameterNames[this.testIndex].length) {
                            sCTDB_Data.data_m0[n10] = resultSet.getString(n7++);
                            ++n10;
                        }
                        sCTDB_Data.data_s1 = new String[SCTDBInfo.DBChipParameterNames[this.testIndex].length];
                        int n11 = 0;
                        while (n11 < SCTDBInfo.DBChipParameterNames[this.testIndex].length) {
                            sCTDB_Data.data_s1[n11] = resultSet.getString(n7++);
                            ++n11;
                        }
                        sCTDB_Data.data_s2 = new String[SCTDBInfo.DBChipParameterNames[this.testIndex].length];
                        int n12 = 0;
                        while (n12 < SCTDBInfo.DBChipParameterNames[this.testIndex].length) {
                            sCTDB_Data.data_s2[n12] = resultSet.getString(n7++);
                            ++n12;
                        }
                        sCTDB_Data.data_s3 = new String[SCTDBInfo.DBChipParameterNames[this.testIndex].length];
                        int n13 = 0;
                        while (n13 < SCTDBInfo.DBChipParameterNames[this.testIndex].length) {
                            sCTDB_Data.data_s3[n13] = resultSet.getString(n7++);
                            ++n13;
                        }
                        sCTDB_Data.data_s4 = new String[SCTDBInfo.DBChipParameterNames[this.testIndex].length];
                        n6 = 0;
                        while (n6 < SCTDBInfo.DBChipParameterNames[this.testIndex].length) {
                            sCTDB_Data.data_s4[n6] = resultSet.getString(n7++);
                            ++n6;
                        }
                        sCTDB_Data.data_e5 = new String[SCTDBInfo.DBChipParameterNames[this.testIndex].length];
                        n5 = 0;
                        while (n5 < SCTDBInfo.DBChipParameterNames[this.testIndex].length) {
                            sCTDB_Data.data_e5[n5] = resultSet.getString(n7++);
                            ++n5;
                        }
                        sCTDB_Data.data_m8 = new String[SCTDBInfo.DBChipParameterNames[this.testIndex].length];
                        n4 = 0;
                        while (n4 < SCTDBInfo.DBChipParameterNames[this.testIndex].length) {
                            sCTDB_Data.data_m8[n4] = resultSet.getString(n7++);
                            ++n4;
                        }
                        sCTDB_Data.data_s9 = new String[SCTDBInfo.DBChipParameterNames[this.testIndex].length];
                        int n14 = 0;
                        while (n14 < SCTDBInfo.DBChipParameterNames[this.testIndex].length) {
                            sCTDB_Data.data_s9[n14] = resultSet.getString(n7++);
                            ++n14;
                        }
                        sCTDB_Data.data_s10 = new String[SCTDBInfo.DBChipParameterNames[this.testIndex].length];
                        int n15 = 0;
                        while (n15 < SCTDBInfo.DBChipParameterNames[this.testIndex].length) {
                            sCTDB_Data.data_s10[n15] = resultSet.getString(n7++);
                            ++n15;
                        }
                        sCTDB_Data.data_s11 = new String[SCTDBInfo.DBChipParameterNames[this.testIndex].length];
                        int n16 = 0;
                        while (n16 < SCTDBInfo.DBChipParameterNames[this.testIndex].length) {
                            sCTDB_Data.data_s11[n16] = resultSet.getString(n7++);
                            ++n16;
                        }
                        sCTDB_Data.data_s12 = new String[SCTDBInfo.DBChipParameterNames[this.testIndex].length];
                        int n17 = 0;
                        while (n17 < SCTDBInfo.DBChipParameterNames[this.testIndex].length) {
                            sCTDB_Data.data_s12[n17] = resultSet.getString(n7++);
                            ++n17;
                        }
                        sCTDB_Data.data_e13 = new String[SCTDBInfo.DBChipParameterNames[this.testIndex].length];
                        int n18 = 0;
                        while (n18 < SCTDBInfo.DBChipParameterNames[this.testIndex].length) {
                            sCTDB_Data.data_e13[n18] = resultSet.getString(n7++);
                            ++n18;
                        }
                        boolean bl2 = false;
                        switch (this.testIndex) {
                            case 3: {
                                this.convertData(sCTDB_Data, 0);
                                break;
                            }
                            case 6: {
                                this.convertData(sCTDB_Data, 2);
                                break;
                            }
                        }
                        hashtable.put(string, sCTDB_Data);
                        hashtable2.put(sCTDB_Data.testNumber, new Hashtable());
                    }
                    bl = resultSet.next();
                }
                statement.close();
                if (hashtable.size() == 0) {
                    System.out.println("No Data available from SCTDB");
                    return;
                }
                StringBuffer stringBuffer2 = new StringBuffer();
                int n19 = 0;
                Enumeration enumeration = hashtable2.keys();
                while (enumeration.hasMoreElements()) {
                    if (n19 > 0) {
                        stringBuffer2.append(",");
                    }
                    ++n19;
                    stringBuffer2.append((String)enumeration.nextElement());
                }
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("SELECT defects.TEST_no,defects.chan_1st,defects.chan_last");
                ((StringBuffer)charSequence).append(" FROM defects");
                ((StringBuffer)charSequence).append(" WHERE defects.TEST_no IN (" + stringBuffer2.toString() + ")");
                statement = SCTDBInterface.getInstance().connection.createStatement();
                resultSet = statement.executeQuery(((StringBuffer)charSequence).toString());
                boolean bl3 = resultSet.next();
                while (bl3) {
                    String string = resultSet.getString(1);
                    Hashtable hashtable3 = (Hashtable)hashtable2.get(string);
                    String string2 = resultSet.getString(2);
                    String string3 = resultSet.getString(3);
                    System.out.println("defects: " + string + ":" + string2 + "-" + string3);
                    n6 = Integer.parseInt(string2);
                    n5 = Integer.parseInt(string3);
                    n4 = n6;
                    while (n4 <= n5) {
                        hashtable3.put(string, Integer.toString(n4));
                        ++n4;
                    }
                    bl3 = resultSet.next();
                }
                statement.close();
                Enumeration enumeration2 = hashtable.keys();
                while (enumeration2.hasMoreElements()) {
                    String string = (String)enumeration2.nextElement();
                    SCTDB_Data sCTDB_Data = (SCTDB_Data)((Object)hashtable.get(string));
                    sCTDB_Data.noDefectChannels = ((Hashtable)hashtable2.get(sCTDB_Data.testNumber)).size();
                    if (string.equals("20220330200020")) {
                        string = "SCTTestAPI_PseudoModule";
                    }
                    String string4 = "SCTDBData." + TestDataInfo.testNames[this.testIndex] + "." + this.location + "." + string;
                    if (SctNames.getISRepository().contains(string4)) {
                        if (!this.refresh) continue;
                        SctNames.getISRepository().remove(string4);
                    }
                    SctNames.getISRepository().insert(string4, (Info)sCTDB_Data);
                    System.out.println("SCTDB Object published as " + string4);
                }
                int n20 = this.listOfModules.size() - hashtable.size();
                if (n20 <= 0) break block43;
                int n21 = 0;
                while (n21 < this.listOfModules.size()) {
                    String string = (String)this.listOfModules.elementAt(n21);
                    if (!hashtable.containsKey(string) && !string.equals("SCTTestAPI_PseudoModule")) {
                        System.out.println("No " + TestDataInfo.testNames[this.testIndex] + " data available for " + (String)this.listOfModules.elementAt(n21));
                    }
                    ++n21;
                }
            }
            catch (Exception exception) {
                System.out.println("Failed to publish SCTDB Data: " + exception.toString());
            }
        }
    }

    private void convertData(SCTDB_Data sCTDB_Data, int n) {
        sCTDB_Data.data_m0[n] = Integer.toString(128 - Integer.parseInt(sCTDB_Data.data_m0[n]));
        sCTDB_Data.data_s1[n] = Integer.toString(128 - Integer.parseInt(sCTDB_Data.data_s1[n]));
        sCTDB_Data.data_s2[n] = Integer.toString(128 - Integer.parseInt(sCTDB_Data.data_s2[n]));
        sCTDB_Data.data_s3[n] = Integer.toString(128 - Integer.parseInt(sCTDB_Data.data_s3[n]));
        sCTDB_Data.data_s4[n] = Integer.toString(128 - Integer.parseInt(sCTDB_Data.data_s4[n]));
        sCTDB_Data.data_e5[n] = Integer.toString(128 - Integer.parseInt(sCTDB_Data.data_e5[n]));
        sCTDB_Data.data_m8[n] = Integer.toString(128 - Integer.parseInt(sCTDB_Data.data_m8[n]));
        sCTDB_Data.data_s9[n] = Integer.toString(128 - Integer.parseInt(sCTDB_Data.data_s9[n]));
        sCTDB_Data.data_s10[n] = Integer.toString(128 - Integer.parseInt(sCTDB_Data.data_s10[n]));
        sCTDB_Data.data_s11[n] = Integer.toString(128 - Integer.parseInt(sCTDB_Data.data_s11[n]));
        sCTDB_Data.data_s12[n] = Integer.toString(128 - Integer.parseInt(sCTDB_Data.data_s12[n]));
        sCTDB_Data.data_e13[n] = Integer.toString(128 - Integer.parseInt(sCTDB_Data.data_e13[n]));
    }
}

