/*
 * Decompiled with CFR 0.152.
 */
package DisplayGUI;

import DisplayGUI.ConfigurationInterface;
import DisplayGUI.SCTInfo;
import DisplayGUI.displayParams;
import DisplayGUI.gui;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class ManualConfiguration
extends JFrame
implements displayParams,
SCTInfo,
ActionListener {
    boolean menuSetup = true;
    gui guiControl;
    int snCount = 3000;
    private JButton AddModuleButton;
    private JLabel LocationLabel;
    private JLabel ModuleLabel;
    private JLabel PositionLabel;
    private JButton QuitButton;
    private JButton randomButton;
    private JLabel SCTViewLabel;
    private JTextField jTextField1;
    private JComboBox locationList;
    private JComboBox positionList;
    private JComboBox sctViewList;
    private JLabel titleLabel;
    private JLabel MURLabel;
    private JTextField MURField;

    public ManualConfiguration(gui gui2) {
        this.guiControl = gui2;
        this.initComponents();
    }

    private void initComponents() {
        this.sctViewList = new JComboBox();
        this.SCTViewLabel = new JLabel();
        this.locationList = new JComboBox();
        this.positionList = new JComboBox();
        this.ModuleLabel = new JLabel();
        this.LocationLabel = new JLabel();
        this.jTextField1 = new JTextField("SCTTestAPI_PseudoModule");
        this.PositionLabel = new JLabel();
        this.AddModuleButton = new JButton();
        this.QuitButton = new JButton();
        this.titleLabel = new JLabel();
        this.MURLabel = new JLabel();
        this.MURField = new JTextField(10);
        this.titleLabel.setFont(displayParams.displayTitleFont);
        this.titleLabel.setForeground(displayParams.darkBlueColor);
        this.ModuleLabel.setFont(displayParams.displayTextFont);
        this.PositionLabel.setFont(displayParams.displayTextFont);
        this.SCTViewLabel.setFont(displayParams.displayTextFont);
        this.LocationLabel.setFont(displayParams.displayTextFont);
        this.QuitButton.setFont(displayParams.displayTextFont);
        this.AddModuleButton.setFont(displayParams.displayTextFont);
        this.sctViewList.setFont(displayParams.displayTextFont);
        this.locationList.setFont(displayParams.displayTextFont);
        this.positionList.setFont(displayParams.displayTextFont);
        this.jTextField1.setFont(displayParams.displayTextFont);
        this.MURField.setFont(displayParams.displayTextFont);
        this.MURLabel.setFont(displayParams.displayTextFont);
        this.sctViewList.setBackground(displayParams.backgroundColor);
        this.locationList.setBackground(displayParams.backgroundColor);
        this.positionList.setBackground(displayParams.backgroundColor);
        this.sctViewList.addActionListener(this);
        this.getContentPane().setBackground(displayParams.backgroundColor);
        this.getContentPane().setLayout(new GridBagLayout());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ManualConfiguration.this.exitForm(windowEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.12;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.sctViewList, gridBagConstraints);
        this.SCTViewLabel.setText("SCT Component:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.5;
        this.getContentPane().add((Component)this.SCTViewLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 0.15;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.locationList, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 0.12;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.positionList, gridBagConstraints);
        this.ModuleLabel.setText("Module SerialNo:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.ModuleLabel, gridBagConstraints);
        this.LocationLabel.setText("Location:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.LocationLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 0.12;
        this.getContentPane().add((Component)this.jTextField1, gridBagConstraints);
        this.PositionLabel.setText("Position:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.PositionLabel, gridBagConstraints);
        this.MURLabel.setText("MUR:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.MURLabel, gridBagConstraints);
        this.MURField.setText("0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 0.12;
        this.getContentPane().add((Component)this.MURField, gridBagConstraints);
        this.AddModuleButton.setText("Add Module");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.AddModuleButton, gridBagConstraints);
        this.AddModuleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ManualConfiguration.this.AddModule(actionEvent);
            }
        });
        this.QuitButton.setText("Close");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.QuitButton, gridBagConstraints);
        this.QuitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ManualConfiguration.this.QuitForm(actionEvent);
            }
        });
        this.titleLabel.setText("Manual Configuration");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.titleLabel, gridBagConstraints);
        int n = 0;
        while (n < SCTInfo.SCTViewNames.length) {
            this.sctViewList.addItem(SCTInfo.SCTViewNames[n]);
            ++n;
        }
        this.setBarrelMenuItems(0);
        this.menuSetup = false;
        this.setLocationRelativeTo(this.guiControl);
        this.pack();
        this.showFrame();
    }

    public void showFrame() {
        int n = this.guiControl.displayPane.getSCTView();
        this.sctViewList.setSelectedIndex(n);
        this.setVisible(true);
    }

    private void exitForm(WindowEvent windowEvent) {
        this.setVisible(false);
    }

    private void QuitForm(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    private void AddModule(ActionEvent actionEvent) {
        String string = this.jTextField1.getText();
        int n = 0;
        try {
            n = Integer.parseInt(this.MURField.getText());
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Invalid MUR number", "Input error", 0);
            return;
        }
        int n2 = this.positionList.getSelectedIndex();
        if (this.sctViewList.getSelectedIndex() < 4) {
            n2 = Integer.parseInt((String)this.positionList.getSelectedItem());
        }
        if (string.equals("SCTTestAPI_PseudoModule") || string.length() == 14 && string.startsWith("2022")) {
            String string2 = ConfigurationInterface.getInstance().addModule(this.sctViewList.getSelectedIndex(), this.locationList.getSelectedIndex(), n2, n, 0, string);
            if (string2 == null) {
                this.guiControl.displayStatus.setModuleGroupSelectionMode();
                if (ConfigurationInterface.getInstance().isConfigured()) {
                    this.guiControl.menuBar.enableDisplayMenuItems(true);
                }
            } else {
                JOptionPane.showMessageDialog(null, string2, "Configuration Error", 0);
            }
        } else {
            JOptionPane.showMessageDialog(null, "Invalid serial number", "Input error", 0);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.menuSetup || actionEvent.getSource() != this.sctViewList) {
            return;
        }
        int n = this.sctViewList.getSelectedIndex();
        if (n < 4) {
            this.setBarrelMenuItems(n);
        } else {
            if ((n -= 3) >= 10) {
                n -= 9;
            }
            this.setEndCapMenuItems(n);
        }
    }

    public void setBarrelMenuItems(int n) {
        this.locationList.removeAllItems();
        int n2 = 0;
        while (n2 < SCTInfo.barrelRows[n]) {
            this.locationList.addItem("Row " + Integer.toString(n2));
            ++n2;
        }
        this.positionList.removeAllItems();
        int n3 = 1;
        while (n3 <= 6) {
            this.positionList.addItem(Integer.toString(n3));
            ++n3;
        }
        int n4 = -1;
        while (n4 >= -6) {
            this.positionList.addItem(Integer.toString(n4));
            --n4;
        }
    }

    public void setEndCapMenuItems(int n) {
        this.locationList.removeAllItems();
        this.locationList.addItem("Quadrant TR");
        this.locationList.addItem("Quadrant BR");
        this.locationList.addItem("Quadrant BL");
        this.locationList.addItem("Quadrant TL");
        this.positionList.removeAllItems();
        int n2 = 1;
        while (n2 <= 13) {
            this.positionList.addItem("O" + Integer.toString(n2));
            ++n2;
        }
        if (n != 9) {
            int n3 = 1;
            while (n3 <= 10) {
                this.positionList.addItem("M" + Integer.toString(n3));
                ++n3;
            }
        }
        switch (n) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                int n4 = 1;
                while (n4 <= 10) {
                    this.positionList.addItem("I" + Integer.toString(n4));
                    ++n4;
                }
                break;
            }
        }
    }
}

