/*
 * Decompiled with CFR 0.152.
 */
package DisplayGUI;

import DisplayGUI.ISTree;
import DisplayGUI.ManualConfiguration;
import DisplayGUI.TestDataInfo;
import DisplayGUI.displayParams;
import DisplayGUI.gui;
import GuiComponents.Console.JConsole;
import GuiComponents.System.SystemInterface;
import GuiComponents.scripting.BeanShellFactory;
import GuiComponents.scripting.DefaultInterpreter;
import GuiComponents.scripting.JavaScriptFactory;
import GuiComponents.scripting.JythonFactory;
import GuiComponents.scripting.NameCompleter;
import GuiComponents.scripting.ScriptFactory;
import GuiComponents.scripting.SearchableObjectRegistry;
import Preferences.Preference;
import Preferences.PreferencesInterface;
import ProdDatabase.GeneralUtilities;
import Sct.Version;
import Sct_CalibrationController.CalibrationControllerPackage.UpdateOption;
import guiUtilities.userPrompt;
import ipc.Info;
import ipc.InfoHolder;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.apache.bsf.BSFEngine;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.bsf.util.ObjectRegistry;

public class GuiMenuBar2
extends JMenuBar
implements displayParams,
ActionListener,
TestDataInfo {
    gui guiControl;
    ManualConfiguration manualConfiguration;
    private SystemInterface si;
    String option;
    protected BSFManager manager;
    protected JConsole console;
    protected SearchableObjectRegistry registry;
    private String[] configOptionNames = new String[]{"Configure", "Manual Configuration..."};
    private String[] displayOptionNames = new String[]{"ModuleGroup Selection", "Data Manager", "Test Results", "SCTDB Reference Data"};
    protected ISTree isTree;
    private JMenu menu;
    private JMenu displayMenu;
    private JMenu ccMenu;
    private JMenu testMenu;
    private JMenu testResultMenu;
    private JMenu sctdbDataMenu;
    private JMenu configMenu;
    private JMenu testDataOptionMenu;
    private JMenu sctdbDataOptionMenu;
    private JMenu tableDataOptionMenu;
    private JMenu ccDataOptionMenu;
    private JMenuItem menuItem;
    private JMenuItem[] configOptions = new JMenuItem[this.configOptionNames.length];
    private JMenuItem[] displayOptions = new JMenuItem[this.displayOptionNames.length];
    private JMenuItem ccPingItem;
    private JMenuItem ccRefreshItem;
    private JMenuItem ccNMaskItem;
    private JMenuItem ccStrobeDelayItem;
    private JMenuItem ccThreePointGainItem;
    private JMenuItem ccTrimItem;
    private JMenuItem ccResponseCurveItem;
    private JMenuItem ccNoiseItem;
    private JMenuItem ccFullBypassItem;
    private JMenuItem ccPipelineItem;
    private JMenuItem ccTimeWalkItem;
    private JMenuItem ccCharacterisationItem;
    private JMenuItem sctapiPing;
    private JMenuItem sctapiRefresh;
    private JMenuItem sctapiInitialise;
    private JMenuItem[] sctapiItems = new JMenuItem[TestDataInfo.testMenuNames.length];
    private JMenuItem[] sctdbItem = new JMenuItem[3];
    private JCheckBox sctdbAutoDownload = new JCheckBox("Auto-Download enabled");
    private String[] ccUpdateStrings = new String[]{"Update", "No-Update", "Wait"};
    private JCheckBox[] ccUpdateModes = new JCheckBox[this.ccUpdateStrings.length];
    private JMenuItem scriptBeanShellItem;
    private JMenuItem scriptJythonItem;
    private JMenuItem scriptJavaScriptItem;
    private JMenuItem isTreeItem;
    private JCheckBox[] testFilterButtons = new JCheckBox[TestDataInfo.testMenuNames.length + 1];
    private JMenu testFilterMenu;
    private JMenuItem[] testDataOptions = new JMenuItem[3];
    private JMenuItem[] preferenceItem = new JMenuItem[PreferencesInterface.getInstance().getNoPreferences()];
    private JMenuItem testReportItem;
    int itemIndex;

    public GuiMenuBar2(gui gui2) {
        this.guiControl = gui2;
        this.createMenuBar();
    }

    public void createMenuBar() {
        this.si = SystemInterface.getInstance();
        this.displayMenu = new JMenu("Display");
        this.displayMenu.setBackground(displayParams.backgroundColor);
        this.displayMenu.setFont(displayParams.menuFont);
        this.displayMenu.setForeground(displayParams.menuColor);
        this.configMenu = new JMenu("Configuration");
        this.configMenu.setFont(displayParams.menuFont);
        int n = 0;
        while (n < this.configOptionNames.length) {
            this.configOptions[n] = new JMenuItem(this.configOptionNames[n]);
            this.configOptions[n].setFont(displayParams.menuFont);
            this.configMenu.add(this.configOptions[n]);
            switch (n) {
                case 0: {
                    this.configOptions[n].addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            GuiMenuBar2.this.guiControl.displayStatus.setConfigurationMode();
                        }
                    });
                    break;
                }
                case 1: {
                    this.configOptions[n].addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            GuiMenuBar2.this.guiControl.displayStatus.setModuleGroupSelectionMode();
                            if (GuiMenuBar2.this.manualConfiguration == null) {
                                GuiMenuBar2.this.manualConfiguration = new ManualConfiguration(GuiMenuBar2.this.guiControl);
                            } else {
                                GuiMenuBar2.this.manualConfiguration.showFrame();
                            }
                        }
                    });
                }
            }
            ++n;
        }
        this.displayMenu.add(this.configMenu);
        int n2 = 0;
        while (n2 < this.displayOptionNames.length) {
            this.displayOptions[n2] = new JMenuItem(this.displayOptionNames[n2]);
            this.displayOptions[n2].setFont(displayParams.menuFont);
            switch (n2) {
                case 0: {
                    this.displayOptions[n2].addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            GuiMenuBar2.this.guiControl.displayStatus.setModuleGroupSelectionMode();
                        }
                    });
                    break;
                }
                case 1: {
                    this.displayOptions[n2].addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            GuiMenuBar2.this.guiControl.displayStatus.setISMode();
                        }
                    });
                    break;
                }
                case 2: {
                    this.displayOptions[n2].addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            GuiMenuBar2.this.guiControl.displayStatus.setTestDataMode(-1);
                        }
                    });
                    break;
                }
                case 3: {
                    this.displayOptions[n2].addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            GuiMenuBar2.this.guiControl.displayStatus.setSCTDBDataMode(-1);
                        }
                    });
                    break;
                }
            }
            this.displayMenu.add(this.displayOptions[n2]);
            this.displayOptions[n2].setEnabled(false);
            ++n2;
        }
        this.add(this.displayMenu);
        this.testMenu = new JMenu("Tests");
        this.testMenu.setBackground(displayParams.backgroundColor);
        this.testMenu.setFont(displayParams.menuFont);
        this.testMenu.setForeground(displayParams.menuColor);
        this.ccPingItem = new JMenuItem("Ping CalibrationController");
        this.ccPingItem.setFont(displayParams.menuFont);
        this.ccPingItem.addActionListener(this);
        this.testMenu.add(this.ccPingItem);
        this.ccRefreshItem = new JMenuItem("Refresh CalibrationController");
        this.ccRefreshItem.addActionListener(this);
        this.ccRefreshItem.setFont(displayParams.menuFont);
        this.testMenu.add(this.ccRefreshItem);
        JMenu jMenu = new JMenu("Digital Tests");
        jMenu.setFont(displayParams.menuFont);
        this.ccNMaskItem = new JMenuItem("NMask");
        this.ccNMaskItem.setFont(displayParams.menuFont);
        this.ccNMaskItem.addActionListener(this);
        this.ccNMaskItem.setEnabled(false);
        jMenu.add(this.ccNMaskItem);
        this.ccPipelineItem = new JMenuItem("Pipeline");
        this.ccPipelineItem.setFont(displayParams.menuFont);
        this.ccPipelineItem.addActionListener(this);
        this.ccPipelineItem.setEnabled(false);
        jMenu.add(this.ccPipelineItem);
        this.ccFullBypassItem = new JMenuItem("FullByPass");
        this.ccFullBypassItem.setFont(displayParams.menuFont);
        this.ccFullBypassItem.addActionListener(this);
        this.ccFullBypassItem.setEnabled(false);
        jMenu.add(this.ccFullBypassItem);
        this.testMenu.add(jMenu);
        JMenu jMenu2 = new JMenu("Analogue Tests");
        jMenu2.setFont(displayParams.menuFont);
        this.ccStrobeDelayItem = new JMenuItem("Strobe Delay");
        this.ccStrobeDelayItem.setFont(displayParams.menuFont);
        this.ccStrobeDelayItem.addActionListener(this);
        this.ccStrobeDelayItem.setEnabled(false);
        jMenu2.add(this.ccStrobeDelayItem);
        this.ccThreePointGainItem = new JMenuItem("3PtGain");
        this.ccThreePointGainItem.setFont(displayParams.menuFont);
        this.ccThreePointGainItem.addActionListener(this);
        this.ccThreePointGainItem.setEnabled(false);
        jMenu2.add(this.ccThreePointGainItem);
        this.ccTrimItem = new JMenuItem("Trim");
        this.ccTrimItem.setFont(displayParams.menuFont);
        this.ccTrimItem.addActionListener(this);
        this.ccTrimItem.setEnabled(false);
        jMenu2.add(this.ccTrimItem);
        this.ccResponseCurveItem = new JMenuItem("ResponseCurve");
        this.ccResponseCurveItem.setFont(displayParams.menuFont);
        this.ccResponseCurveItem.addActionListener(this);
        this.ccResponseCurveItem.setEnabled(false);
        jMenu2.add(this.ccResponseCurveItem);
        this.ccNoiseItem = new JMenuItem("Noise");
        this.ccNoiseItem.setFont(displayParams.menuFont);
        this.ccNoiseItem.addActionListener(this);
        this.ccNoiseItem.setEnabled(false);
        jMenu2.add(this.ccNoiseItem);
        this.ccTimeWalkItem = new JMenuItem("Time Walk");
        this.ccTimeWalkItem.setFont(displayParams.menuFont);
        this.ccTimeWalkItem.addActionListener(this);
        this.ccTimeWalkItem.setEnabled(false);
        jMenu2.add(this.ccTimeWalkItem);
        this.testMenu.add(jMenu2);
        JMenu jMenu3 = new JMenu("Sequences");
        jMenu3.setFont(displayParams.menuFont);
        this.ccCharacterisationItem = new JMenuItem("Characterisation");
        this.ccCharacterisationItem.setFont(displayParams.menuFont);
        this.ccCharacterisationItem.addActionListener(this);
        this.ccCharacterisationItem.setEnabled(false);
        jMenu3.add(this.ccCharacterisationItem);
        this.testMenu.add(jMenu3);
        JMenu jMenu4 = new JMenu("SCTDAQ Exerciser");
        jMenu4.setFont(displayParams.menuFont);
        this.sctapiPing = new JMenuItem("Ping");
        this.sctapiPing.setFont(displayParams.menuFont);
        jMenu4.add(this.sctapiPing);
        this.sctapiPing.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.out.println(GuiMenuBar2.this.si.getTestApi().ping(""));
            }
        });
        this.sctapiRefresh = new JMenuItem("Refresh");
        this.sctapiRefresh.setFont(displayParams.menuFont);
        jMenu4.add(this.sctapiRefresh);
        this.sctapiRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GuiMenuBar2.this.si.refresh();
            }
        });
        this.sctapiInitialise = new JMenuItem("Initialise");
        this.sctapiInitialise.setFont(displayParams.menuFont);
        jMenu4.add(this.sctapiInitialise);
        this.sctapiInitialise.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GuiMenuBar2.this.si.getTestApi().initialise();
            }
        });
        jMenu4.addSeparator();
        int n3 = 0;
        while (n3 < this.sctapiItems.length) {
            if (TestDataInfo.testIsDefined[n3]) {
                this.sctapiItems[n3] = new JMenuItem(TestDataInfo.testMenuNames[n3]);
                this.sctapiItems[n3].setFont(displayParams.menuFont);
                jMenu4.add(this.sctapiItems[n3]);
                switch (n3) {
                    case 2: {
                        this.sctapiItems[n3].addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                GuiMenuBar2.this.guiControl.displayStatus.setTestDataMode(-1);
                                GuiMenuBar2.this.si.getTestApi().doFullBypassScan();
                                if (GuiMenuBar2.this.sctdbAutoDownload.isSelected()) {
                                    GuiMenuBar2.this.guiControl.sctdbDataInterface.downloadTests(2);
                                }
                            }
                        });
                    }
                    case 3: {
                        this.sctapiItems[n3].addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                GuiMenuBar2.this.guiControl.displayStatus.setTestDataMode(-1);
                                GuiMenuBar2.this.si.getTestApi().doPipelineScan();
                                if (GuiMenuBar2.this.sctdbAutoDownload.isSelected()) {
                                    GuiMenuBar2.this.guiControl.sctdbDataInterface.downloadTests(3);
                                }
                            }
                        });
                        break;
                    }
                    case 4: {
                        this.sctapiItems[n3].addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                GuiMenuBar2.this.guiControl.displayStatus.setTestDataMode(-1);
                                GuiMenuBar2.this.si.getTestApi().doStrobeDelayScan();
                                if (GuiMenuBar2.this.sctdbAutoDownload.isSelected()) {
                                    GuiMenuBar2.this.guiControl.sctdbDataInterface.downloadTests(4);
                                }
                            }
                        });
                        break;
                    }
                    case 5: {
                        this.sctapiItems[n3].addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                GuiMenuBar2.this.guiControl.displayStatus.setTestDataMode(-1);
                                GuiMenuBar2.this.si.getTestApi().doThreePointGainScan();
                                if (GuiMenuBar2.this.sctdbAutoDownload.isSelected()) {
                                    GuiMenuBar2.this.guiControl.sctdbDataInterface.downloadTests(5);
                                }
                            }
                        });
                        break;
                    }
                    case 6: {
                        this.sctapiItems[n3].addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                GuiMenuBar2.this.guiControl.displayStatus.setTestDataMode(-1);
                                GuiMenuBar2.this.si.getTestApi().doTrimScan();
                                if (GuiMenuBar2.this.sctdbAutoDownload.isSelected()) {
                                    GuiMenuBar2.this.guiControl.sctdbDataInterface.downloadTests(6);
                                }
                            }
                        });
                        break;
                    }
                    case 7: {
                        this.sctapiItems[n3].addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                GuiMenuBar2.this.guiControl.displayStatus.setTestDataMode(-1);
                                GuiMenuBar2.this.si.getTestApi().doResponseCurveScan();
                                if (GuiMenuBar2.this.sctdbAutoDownload.isSelected()) {
                                    GuiMenuBar2.this.guiControl.sctdbDataInterface.downloadTests(7);
                                }
                            }
                        });
                        break;
                    }
                    case 8: {
                        this.sctapiItems[n3].addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                GuiMenuBar2.this.guiControl.displayStatus.setTestDataMode(-1);
                                GuiMenuBar2.this.si.getTestApi().doNoiseScan();
                                if (GuiMenuBar2.this.sctdbAutoDownload.isSelected()) {
                                    GuiMenuBar2.this.guiControl.sctdbDataInterface.downloadTests(8);
                                }
                            }
                        });
                        break;
                    }
                    case 9: {
                        this.sctapiItems[n3].addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                GuiMenuBar2.this.guiControl.displayStatus.setTestDataMode(-1);
                                GuiMenuBar2.this.si.getTestApi().doTimeWalkScan();
                                if (GuiMenuBar2.this.sctdbAutoDownload.isSelected()) {
                                    GuiMenuBar2.this.guiControl.sctdbDataInterface.downloadTests(9);
                                }
                            }
                        });
                        break;
                    }
                }
            }
            ++n3;
        }
        this.testMenu.add(jMenu4);
        this.add(this.testMenu);
        this.testDataOptionMenu = this.getTestDataOptionMenu();
        this.tableDataOptionMenu = this.getTableDataOptionMenu();
        this.sctdbDataOptionMenu = this.getSCTDBDataOptionMenu();
        this.ccDataOptionMenu = this.getCCDataOptionMenu();
        this.menu = new JMenu("Options");
        this.menu.setBackground(displayParams.backgroundColor);
        this.menu.setFont(displayParams.menuFont);
        this.menu.setForeground(displayParams.menuColor);
        this.menu.add(this.tableDataOptionMenu);
        this.menu.add(this.testDataOptionMenu);
        this.menu.add(this.sctdbDataOptionMenu);
        this.menu.add(this.ccDataOptionMenu);
        this.add(this.menu);
        this.menu = new JMenu("Tools");
        this.menu.setBackground(displayParams.backgroundColor);
        this.menu.setFont(displayParams.menuFont);
        this.menu.setForeground(displayParams.menuColor);
        this.isTreeItem = new JMenuItem("IS Tree...");
        this.isTreeItem.setFont(displayParams.menuFont);
        this.isTreeItem.addActionListener(this);
        this.menu.add(this.isTreeItem);
        JMenu jMenu5 = new JMenu("Scripting");
        jMenu5.setFont(displayParams.menuFont);
        this.scriptJavaScriptItem = new JMenuItem("JavaScript");
        this.scriptJavaScriptItem.setFont(displayParams.menuFont);
        this.scriptJavaScriptItem.addActionListener(this);
        jMenu5.add(this.scriptJavaScriptItem);
        this.scriptBeanShellItem = new JMenuItem("BeanShell");
        this.scriptBeanShellItem.setFont(displayParams.menuFont);
        this.scriptBeanShellItem.addActionListener(this);
        jMenu5.add(this.scriptBeanShellItem);
        this.scriptJythonItem = new JMenuItem("Jython");
        this.scriptJythonItem.setFont(displayParams.menuFont);
        this.scriptJythonItem.addActionListener(this);
        jMenu5.add(this.scriptJythonItem);
        this.menu.add(jMenu5);
        JMenuItem jMenuItem = new JMenuItem("Run GarbageCollector");
        jMenuItem.setFont(displayParams.menuFont);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Runtime runtime = Runtime.getRuntime();
                long l = runtime.freeMemory();
                long l2 = runtime.maxMemory();
                long l3 = runtime.totalMemory();
                System.out.println("Total Mem: " + (double)l3 / 1024.0 + ", Max Mem:" + (double)l2 / 1024.0 + " , Free Mem: " + (double)l / 1024.0);
                runtime.gc();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                runtime.gc();
                l = runtime.freeMemory();
                l2 = runtime.maxMemory();
                l3 = runtime.totalMemory();
                System.out.println("Total Mem: " + (double)l3 / 1024.0 + ", Max Mem:" + (double)l2 / 1024.0 + " , Free Mem: " + (double)l / 1024.0);
            }
        });
        this.menu.add(jMenuItem);
        jMenuItem = new JMenuItem("Refresh Display");
        jMenuItem.setFont(displayParams.menuFont);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GuiMenuBar2.this.guiControl.displayPane.setDisplayColors();
                GuiMenuBar2.this.guiControl.displayPane.refreshDisplay();
            }
        });
        this.menu.add(jMenuItem);
        this.add(this.menu);
        this.menu = new JMenu("Help");
        this.menu.setBackground(displayParams.backgroundColor);
        this.menu.setFont(displayParams.menuFont);
        this.menu.setForeground(displayParams.menuColor);
        JMenuItem jMenuItem2 = new JMenuItem("View User Manual");
        jMenuItem2.setFont(displayParams.menuFont);
        this.menu.add(jMenuItem2);
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GuiMenuBar2.this.guiControl.htmlViewer.show("http://www.hep.phy.cam.ac.uk/~robinson/DisplayGUI.html", "Online manual");
            }
        });
        JMenuItem jMenuItem3 = new JMenuItem("About");
        jMenuItem3.setFont(displayParams.menuFont);
        this.menu.add(jMenuItem3);
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = Version.instance.getAllInformation();
                String string2 = "SctGui is the user interface for end users.  See the manual for more information";
                string2 = string2 + "\nSctGui Author: Dave Robinson.";
                string2 = string2 + "\nSctDaqRod Authors: Alan Barr, Bruce Gallop, Matthew Palmer, Dave Robinson and Alexander Tricoli";
                string2 = string2 + "\n\n" + string;
                JOptionPane.showMessageDialog(GuiMenuBar2.this.guiControl, string2, "About SctGui", 1);
            }
        });
        this.add(this.menu);
        this.add(Box.createHorizontalGlue());
        PreferencesInterface preferencesInterface = PreferencesInterface.getInstance();
        this.menu = new JMenu("Preferences");
        this.menu.setBackground(displayParams.backgroundColor);
        this.menu.setFont(displayParams.menuFont);
        this.menu.setForeground(displayParams.menuColor);
        int n4 = 0;
        while (n4 < preferencesInterface.getNoPreferences()) {
            this.preferenceItem[n4] = new JMenuItem(preferencesInterface.getDescription(n4));
            this.preferenceItem[n4].setFont(displayParams.menuFont);
            this.menu.add(this.preferenceItem[n4]);
            switch (n4) {
                case 0: {
                    this.preferenceItem[n4].addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            Preference preference = new Preference(GuiMenuBar2.this.guiControl, 0);
                        }
                    });
                    break;
                }
                case 2: {
                    this.preferenceItem[n4].addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            Preference preference = new Preference(GuiMenuBar2.this.guiControl, 2);
                        }
                    });
                    break;
                }
                case 3: {
                    this.preferenceItem[n4].addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            Preference preference = new Preference(GuiMenuBar2.this.guiControl, 3);
                        }
                    });
                    break;
                }
                case 1: {
                    this.preferenceItem[n4].addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            Preference preference = new Preference(GuiMenuBar2.this.guiControl, 1);
                        }
                    });
                    break;
                }
            }
            ++n4;
        }
        this.add(this.menu);
        this.testFilterMenu = this.getTestFilterMenu();
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setBackground(displayParams.backgroundColor);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        if (jMenuItem == this.ccRefreshItem) {
            this.si.refresh();
            return;
        }
        if (jMenuItem == this.ccPingItem) {
            InfoHolder infoHolder = new InfoHolder();
            if (this.si.getCalibrationController() != null) {
                this.si.getCalibrationController().get_info(infoHolder);
                Info info = infoHolder.value;
                System.out.println("CalibrationController running: " + info.pid + " by " + info.owner + " on " + info.host + " since " + info.time);
            } else {
                System.out.println("CalibrationController not running");
            }
            return;
        }
        if (jMenuItem == this.ccThreePointGainItem) {
            this.guiControl.displayStatus.setTestDataMode(-1);
            this.si.getCalibrationController().doTest(this.si.getCalibrationController().getTestLibrary().threePointGain());
            return;
        }
        if (jMenuItem == this.ccNMaskItem) {
            this.guiControl.displayStatus.setTestDataMode(-1);
            this.si.getCalibrationController().doTest(this.si.getCalibrationController().getTestLibrary().nmask());
            return;
        }
        if (jMenuItem == this.ccStrobeDelayItem) {
            this.guiControl.displayStatus.setTestDataMode(-1);
            this.si.getCalibrationController().doTest(this.si.getCalibrationController().getTestLibrary().strobeDelay());
            return;
        }
        if (jMenuItem == this.ccResponseCurveItem) {
            this.guiControl.displayStatus.setTestDataMode(-1);
            this.si.getCalibrationController().doTest(this.si.getCalibrationController().getTestLibrary().responseCurve());
            return;
        }
        if (jMenuItem == this.ccPipelineItem) {
            this.guiControl.displayStatus.setTestDataMode(-1);
            this.si.getCalibrationController().doTest(this.si.getCalibrationController().getTestLibrary().pipeline());
            return;
        }
        if (jMenuItem == this.ccTimeWalkItem) {
            this.si.getCalibrationController().doTest(this.si.getCalibrationController().getTestLibrary().timeWalk());
            return;
        }
        if (jMenuItem == this.ccFullBypassItem) {
            this.guiControl.displayStatus.setTestDataMode(-1);
            this.si.getCalibrationController().doTest(this.si.getCalibrationController().getTestLibrary().fullBypass());
            return;
        }
        if (jMenuItem == this.ccTrimItem) {
            this.guiControl.displayStatus.setTestDataMode(-1);
            this.si.getCalibrationController().doTest(this.si.getCalibrationController().getTestLibrary().trimRange());
            return;
        }
        if (jMenuItem == this.ccNoiseItem) {
            this.guiControl.displayStatus.setTestDataMode(-1);
            this.si.getCalibrationController().doTest(this.si.getCalibrationController().getTestLibrary().noiseOccupancy());
            return;
        }
        if (jMenuItem == this.ccCharacterisationItem) {
            this.guiControl.displayStatus.setTestDataMode(-1);
            this.si.getCalibrationController().doSequence(this.si.getCalibrationController().getSequenceLibrary().characterizationSequence());
            return;
        }
        if (jMenuItem == this.scriptBeanShellItem) {
            this.createScriptInterface(new BeanShellFactory());
            return;
        }
        if (jMenuItem == this.scriptJavaScriptItem) {
            this.createScriptInterface(new JavaScriptFactory());
            return;
        }
        if (jMenuItem == this.scriptJythonItem) {
            this.createScriptInterface(new JythonFactory());
            return;
        }
        if (jMenuItem == this.isTreeItem) {
            if (this.isTree == null) {
                this.isTree = new ISTree(this.guiControl, this.guiControl.isInterface.getISTree());
            } else {
                this.isTree.setTree(this.guiControl.isInterface.getISTree());
            }
            return;
        }
    }

    public void enableCCMenuItems(boolean bl) {
        this.ccNMaskItem.setEnabled(bl);
        this.ccPipelineItem.setEnabled(bl);
        this.ccTimeWalkItem.setEnabled(bl);
        this.ccFullBypassItem.setEnabled(bl);
        this.ccStrobeDelayItem.setEnabled(bl);
        this.ccThreePointGainItem.setEnabled(bl);
        this.ccTrimItem.setEnabled(bl);
        this.ccResponseCurveItem.setEnabled(bl);
        this.ccNoiseItem.setEnabled(bl);
        this.ccTimeWalkItem.setEnabled(bl);
        this.ccCharacterisationItem.setEnabled(bl);
    }

    public void enableDisplayMenuItems(boolean bl) {
        int n = 0;
        while (n < this.displayOptionNames.length) {
            this.displayOptions[n].setEnabled(bl);
            ++n;
        }
    }

    private void initManager() {
        this.manager = new BSFManager();
        this.registry = new SearchableObjectRegistry();
        this.manager.setObjectRegistry((ObjectRegistry)this.registry);
        try {
            this.manager.declareBean("SystemInterface", (Object)this.si, this.si.getClass());
        }
        catch (BSFException bSFException) {
            System.err.println("Error initializing manager: " + (Object)((Object)bSFException));
        }
    }

    protected void createScriptInterface(ScriptFactory scriptFactory) {
        if (this.manager == null) {
            this.initManager();
        }
        JConsole jConsole = scriptFactory.createConsole();
        try {
            this.manager.declareBean("console", (Object)jConsole, jConsole.getClass());
        }
        catch (BSFException bSFException) {
            System.err.println("Internal error, BSFException whilst adding bean console.\n" + (Object)((Object)bSFException));
            bSFException.printStackTrace();
        }
        BSFEngine bSFEngine = scriptFactory.createEngine(this.manager);
        NameCompleter nameCompleter = scriptFactory.createNameCompleter(bSFEngine, this.registry);
        DefaultInterpreter defaultInterpreter = scriptFactory.createInterpreter(bSFEngine, jConsole, nameCompleter);
        this.addNewConsole(jConsole, defaultInterpreter.toString());
    }

    protected boolean addNewConsole(JConsole jConsole, String string) {
        if (this.console != null) {
            System.err.println("Can only have 1 scripting window open at once");
            return false;
        }
        this.console = jConsole;
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GuiMenuBar2.this.removeConsole();
            }
        });
        jFrame.getContentPane().add(jConsole);
        jFrame.setTitle("Scripting Window:" + string);
        jFrame.show();
        jFrame.setSize(400, 500);
        return true;
    }

    protected void removeConsole() {
        try {
            this.manager.undeclareBean("console");
        }
        catch (BSFException bSFException) {
            System.err.println("Internal error, BSFException whilst removing bean console.\n" + (Object)((Object)bSFException));
            bSFException.printStackTrace();
        }
        this.console = null;
    }

    public void showCCPopupMenu(MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = this.ccDataOptionMenu.getPopupMenu();
        jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        jPopupMenu.setInvoker(this.ccDataOptionMenu);
    }

    public void showTablesPopupMenu(int n, MouseEvent mouseEvent) {
        block0 : switch (n) {
            case 1: {
                switch (this.guiControl.displayStatus.getStatus()) {
                    case 2: {
                        JPopupMenu jPopupMenu = this.tableDataOptionMenu.getPopupMenu();
                        jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                        jPopupMenu.setInvoker(this.tableDataOptionMenu);
                        break block0;
                    }
                }
                break;
            }
            case 0: {
                switch (this.guiControl.displayStatus.getStatus()) {
                    case 3: {
                        JPopupMenu jPopupMenu = this.testFilterMenu.getPopupMenu();
                        jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                        jPopupMenu.setInvoker(this.testFilterMenu);
                        break block0;
                    }
                }
                break;
            }
        }
    }

    public void showPopupMenu(MouseEvent mouseEvent) {
        switch (this.guiControl.displayStatus.getStatus()) {
            case 0: {
                JPopupMenu jPopupMenu = this.configMenu.getPopupMenu();
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                jPopupMenu.setInvoker(this.configMenu);
                break;
            }
            case 1: {
                JPopupMenu jPopupMenu = this.displayMenu.getPopupMenu();
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                jPopupMenu.setInvoker(this.displayMenu);
                break;
            }
            case 2: {
                JPopupMenu jPopupMenu = this.testMenu.getPopupMenu();
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                jPopupMenu.setInvoker(this.testMenu);
                break;
            }
            case 3: {
                JPopupMenu jPopupMenu = this.testDataOptionMenu.getPopupMenu();
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                jPopupMenu.setInvoker(this.testDataOptionMenu);
                break;
            }
            case 4: {
                JPopupMenu jPopupMenu = this.sctdbDataOptionMenu.getPopupMenu();
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                jPopupMenu.setInvoker(this.sctdbDataOptionMenu);
                break;
            }
        }
    }

    private JMenu getTestDataOptionMenu() {
        JMenu jMenu = new JMenu("Test Results");
        jMenu.setFont(displayParams.menuFont);
        this.testDataOptions[0] = new JMenuItem("ROD Data");
        this.testDataOptions[0].setFont(displayParams.menuFont);
        this.testDataOptions[0].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GuiMenuBar2.this.guiControl.displayPane.setDisplayOption(0);
            }
        });
        this.testDataOptions[1] = new JMenuItem("SCTDB Reference Data");
        this.testDataOptions[1].setFont(displayParams.menuFont);
        this.testDataOptions[1].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GuiMenuBar2.this.guiControl.displayPane.setDisplayOption(1);
            }
        });
        this.testDataOptions[2] = new JMenuItem("Comparison ROD-SCTDB");
        this.testDataOptions[2].setFont(displayParams.menuFont);
        this.testDataOptions[2].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GuiMenuBar2.this.guiControl.displayPane.setDisplayOption(2);
            }
        });
        jMenu.add(this.testDataOptions[0]);
        jMenu.add(this.testDataOptions[1]);
        jMenu.add(this.testDataOptions[2]);
        return jMenu;
    }

    private JMenu getTableDataOptionMenu() {
        JMenu jMenu = new JMenu("Tables");
        jMenu.setFont(displayParams.menuFont);
        jMenu.setMnemonic(84);
        jMenu.getAccessibleContext().setAccessibleDescription("Table actions");
        JMenuItem jMenuItem = new JMenuItem("Plot Selection");
        jMenuItem.setFont(displayParams.menuFont);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                switch (GuiMenuBar2.this.guiControl.displayStatus.getStatus()) {
                    case 2: {
                        String string = GuiMenuBar2.this.guiControl.tablesDisplayPane.getSelectedObject();
                        if (string == null) break;
                        GuiMenuBar2.this.guiControl.isInterface.launchExternalViewer(string);
                        break;
                    }
                }
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Delete Selected Test(s)");
        jMenuItem.setFont(displayParams.menuFont);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                switch (GuiMenuBar2.this.guiControl.displayStatus.getStatus()) {
                    case 2: {
                        int n = GuiMenuBar2.this.guiControl.tablesDisplayPane.getSelectedTest();
                        if (n == -1) {
                            return;
                        }
                        GuiMenuBar2.this.guiControl.isInterface.removeTests(n, n);
                        GuiMenuBar2.this.guiControl.tablesDisplayPane.updateTables();
                        break;
                    }
                }
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("View IS Data");
        jMenuItem.setFont(displayParams.menuFont);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                switch (GuiMenuBar2.this.guiControl.displayStatus.getStatus()) {
                    case 2: {
                        String string = GuiMenuBar2.this.guiControl.tablesDisplayPane.getSelectedObject();
                        if (string == null) break;
                        GuiMenuBar2.this.guiControl.isInterface.viewISData(string);
                        break;
                    }
                }
            }
        });
        jMenu.add(jMenuItem);
        return jMenu;
    }

    private JMenu getSCTDBDataOptionMenu() {
        JMenu jMenu = new JMenu("SCTDB");
        jMenu.setFont(displayParams.menuFont);
        this.sctdbItem[0] = new JMenuItem("Refresh SCTDB Data");
        this.sctdbItem[0].setFont(displayParams.menuFont);
        jMenu.add(this.sctdbItem[0]);
        this.sctdbItem[0].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GuiMenuBar2.this.guiControl.sctdbDataInterface.downloadTests(-1);
            }
        });
        this.sctdbAutoDownload.setFont(displayParams.menuFont);
        jMenu.add(this.sctdbAutoDownload);
        this.sctdbItem[1] = new JMenuItem("SCTDB Test Location");
        this.sctdbItem[1].setFont(displayParams.menuFont);
        jMenu.add(this.sctdbItem[1]);
        this.sctdbItem[1].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Vector vector = new Vector();
                try {
                    vector = GeneralUtilities.getLocationList();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                vector.insertElementAt("Any", 0);
                userPrompt userPrompt2 = new userPrompt((Frame)GuiMenuBar2.this.guiControl, "Any", "Institute", vector);
                userPrompt2.pack();
                userPrompt2.setLocationRelativeTo(GuiMenuBar2.this.guiControl);
                userPrompt2.setVisible(true);
                String string = userPrompt2.getValidatedText();
                if (!string.equals("None")) {
                    GuiMenuBar2.this.guiControl.sctdbDataInterface.setLocation(string);
                    GuiMenuBar2.this.guiControl.sctdbDataInterface.setTestFilter(GuiMenuBar2.this.guiControl.tablesDisplayPane.getSelectedTest());
                    GuiMenuBar2.this.guiControl.selectorPane.initParamList();
                    GuiMenuBar2.this.guiControl.colorScalePane.setColorScale();
                    GuiMenuBar2.this.guiControl.displayPane.setDisplayColors();
                    GuiMenuBar2.this.guiControl.displayPane.refreshDisplay();
                    GuiMenuBar2.this.guiControl.tablesDisplayPane.listTestResults();
                }
            }
        });
        return jMenu;
    }

    private JMenu getCCDataOptionMenu() {
        JMenu jMenu = new JMenu("CalibrationController");
        jMenu.setFont(displayParams.menuFont);
        ButtonGroup buttonGroup = new ButtonGroup();
        int n = 0;
        while (n < this.ccUpdateModes.length) {
            this.ccUpdateModes[n] = new JCheckBox(this.ccUpdateStrings[n]);
            buttonGroup.add(this.ccUpdateModes[n]);
            this.ccUpdateModes[n].setFont(displayParams.menuFont);
            jMenu.add(this.ccUpdateModes[n]);
            ++n;
        }
        JMenuItem jMenuItem = new JMenuItem("Abort");
        jMenuItem.setFont(displayParams.menuFont);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    GuiMenuBar2.this.si.getCalibrationController().abort();
                }
                catch (Exception exception) {
                    System.err.println("Error aborting calibrationController: " + exception.toString());
                }
            }
        });
        jMenu.addSeparator();
        jMenu.add(jMenuItem);
        this.ccUpdateModes[0].setSelected(true);
        int n2 = 0;
        while (n2 < this.ccUpdateModes.length) {
            switch (n2) {
                case 0: {
                    this.ccUpdateModes[n2].addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            try {
                                GuiMenuBar2.this.si.getCalibrationController().setUpdateOption(UpdateOption.update);
                                GuiMenuBar2.this.checkCCUpdateMode();
                            }
                            catch (Exception exception) {
                                System.err.println("Error : " + exception.toString());
                            }
                        }
                    });
                    break;
                }
                case 1: {
                    this.ccUpdateModes[n2].addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            try {
                                GuiMenuBar2.this.si.getCalibrationController().setUpdateOption(UpdateOption.noupdate);
                                GuiMenuBar2.this.checkCCUpdateMode();
                            }
                            catch (Exception exception) {
                                System.err.println("Error : " + exception.toString());
                            }
                        }
                    });
                    break;
                }
                case 2: {
                    this.ccUpdateModes[n2].addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            try {
                                GuiMenuBar2.this.si.getCalibrationController().setUpdateOption(UpdateOption._wait);
                                GuiMenuBar2.this.checkCCUpdateMode();
                            }
                            catch (Exception exception) {
                                System.err.println("Error : " + exception.toString());
                            }
                        }
                    });
                    break;
                }
            }
            ++n2;
        }
        return jMenu;
    }

    public void checkCCUpdateMode() {
        if (this.guiControl.calibrationControllerPanel == null || this.guiControl.calibrationControllerPanel.status == null) {
            System.out.println("CalibrationControllerPanel.status object not yet available... update mode not yet known");
            return;
        }
        String string = this.guiControl.calibrationControllerPanel.status.updateOption;
        if (string.equals("NOUPDATE")) {
            this.ccUpdateModes[1].setSelected(true);
        } else if (string.equals("WAIT")) {
            this.ccUpdateModes[2].setSelected(true);
        } else {
            this.ccUpdateModes[0].setSelected(true);
        }
    }

    private JMenu getTestFilterMenu() {
        JMenu jMenu = new JMenu("Test Filter");
        jMenu.setFont(displayParams.menuFont);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.testFilterButtons[0] = new JCheckBox("All tests");
        buttonGroup.add(this.testFilterButtons[0]);
        this.testFilterButtons[0].setFont(displayParams.menuFont);
        this.testFilterButtons[0].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                switch (GuiMenuBar2.this.guiControl.displayStatus.getStatus()) {
                    case 3: {
                        GuiMenuBar2.this.guiControl.displayStatus.setTestDataMode(-1);
                        break;
                    }
                    case 4: {
                        GuiMenuBar2.this.guiControl.displayStatus.setSCTDBDataMode(-1);
                        break;
                    }
                }
            }
        });
        jMenu.add(this.testFilterButtons[0]);
        int n = 1;
        while (n < this.testFilterButtons.length) {
            if (TestDataInfo.testIsDefined[n - 1]) {
                this.testFilterButtons[n] = new JCheckBox(TestDataInfo.testNames[n - 1]);
                buttonGroup.add(this.testFilterButtons[n]);
                this.testFilterButtons[n].setFont(displayParams.menuFont);
                jMenu.add(this.testFilterButtons[n]);
            }
            ++n;
        }
        this.testFilterButtons[0].setSelected(true);
        int n2 = 1;
        while (n2 < this.testFilterButtons.length) {
            if (TestDataInfo.testIsDefined[n2 - 1]) {
                switch (n2 - 1) {
                    case 2: {
                        this.testFilterButtons[n2].addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                switch (GuiMenuBar2.this.guiControl.displayStatus.getStatus()) {
                                    case 3: {
                                        GuiMenuBar2.this.guiControl.displayStatus.setTestDataMode(2);
                                        break;
                                    }
                                    case 4: {
                                        GuiMenuBar2.this.guiControl.displayStatus.setSCTDBDataMode(2);
                                        break;
                                    }
                                }
                            }
                        });
                        break;
                    }
                    case 3: {
                        this.testFilterButtons[n2].addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                switch (GuiMenuBar2.this.guiControl.displayStatus.getStatus()) {
                                    case 3: {
                                        GuiMenuBar2.this.guiControl.displayStatus.setTestDataMode(3);
                                        break;
                                    }
                                    case 4: {
                                        GuiMenuBar2.this.guiControl.displayStatus.setSCTDBDataMode(3);
                                        break;
                                    }
                                }
                            }
                        });
                        break;
                    }
                    case 4: {
                        this.testFilterButtons[n2].addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                switch (GuiMenuBar2.this.guiControl.displayStatus.getStatus()) {
                                    case 3: {
                                        GuiMenuBar2.this.guiControl.displayStatus.setTestDataMode(4);
                                        break;
                                    }
                                    case 4: {
                                        GuiMenuBar2.this.guiControl.displayStatus.setSCTDBDataMode(4);
                                        break;
                                    }
                                }
                            }
                        });
                        break;
                    }
                    case 5: {
                        this.testFilterButtons[n2].addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                switch (GuiMenuBar2.this.guiControl.displayStatus.getStatus()) {
                                    case 3: {
                                        GuiMenuBar2.this.guiControl.displayStatus.setTestDataMode(5);
                                        break;
                                    }
                                    case 4: {
                                        GuiMenuBar2.this.guiControl.displayStatus.setSCTDBDataMode(5);
                                        break;
                                    }
                                }
                            }
                        });
                        break;
                    }
                    case 6: {
                        this.testFilterButtons[n2].addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                switch (GuiMenuBar2.this.guiControl.displayStatus.getStatus()) {
                                    case 3: {
                                        GuiMenuBar2.this.guiControl.displayStatus.setTestDataMode(6);
                                        break;
                                    }
                                    case 4: {
                                        GuiMenuBar2.this.guiControl.displayStatus.setSCTDBDataMode(6);
                                        break;
                                    }
                                }
                            }
                        });
                        break;
                    }
                    case 7: {
                        this.testFilterButtons[n2].addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                switch (GuiMenuBar2.this.guiControl.displayStatus.getStatus()) {
                                    case 3: {
                                        GuiMenuBar2.this.guiControl.displayStatus.setTestDataMode(7);
                                        break;
                                    }
                                    case 4: {
                                        GuiMenuBar2.this.guiControl.displayStatus.setSCTDBDataMode(7);
                                        break;
                                    }
                                }
                            }
                        });
                        break;
                    }
                    case 8: {
                        this.testFilterButtons[n2].addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                switch (GuiMenuBar2.this.guiControl.displayStatus.getStatus()) {
                                    case 3: {
                                        GuiMenuBar2.this.guiControl.displayStatus.setTestDataMode(8);
                                        break;
                                    }
                                    case 4: {
                                        GuiMenuBar2.this.guiControl.displayStatus.setSCTDBDataMode(8);
                                        break;
                                    }
                                }
                            }
                        });
                        break;
                    }
                    case 9: {
                        this.testFilterButtons[n2].addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                switch (GuiMenuBar2.this.guiControl.displayStatus.getStatus()) {
                                    case 3: {
                                        GuiMenuBar2.this.guiControl.displayStatus.setTestDataMode(9);
                                        break;
                                    }
                                    case 4: {
                                        GuiMenuBar2.this.guiControl.displayStatus.setSCTDBDataMode(9);
                                        break;
                                    }
                                }
                            }
                        });
                        break;
                    }
                    case 12: {
                        this.testFilterButtons[n2].addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                switch (GuiMenuBar2.this.guiControl.displayStatus.getStatus()) {
                                    case 3: {
                                        GuiMenuBar2.this.guiControl.displayStatus.setTestDataMode(12);
                                        break;
                                    }
                                    case 4: {
                                        GuiMenuBar2.this.guiControl.displayStatus.setSCTDBDataMode(12);
                                        break;
                                    }
                                }
                            }
                        });
                        break;
                    }
                }
            }
            ++n2;
        }
        return jMenu;
    }

    public void resetTestListFilter() {
        this.testFilterButtons[0].setSelected(true);
    }
}

