/*
 * Decompiled with CFR 0.152.
 */
package DisplayGUI;

import DisplayGUI.ConfigurationInterface;
import DisplayGUI.gui;

public class DisplayStatus {
    public static final int UNDEFINED = 0;
    public static final int CONFIGURED = 1;
    public static final int MODULE_GROUP_SELECTION = 1;
    public static final int IS_MONITOR = 2;
    public static final int TEST_DATA = 3;
    public static final int SCTDB_DATA = 4;
    public static final String[] statusNames = new String[]{"UNCONFIGURED", "ModuleGroup Selection", "Data Manager", "Test Result", "SCTDB Result"};
    public int status;
    public int configuredStatus;
    gui guiControl;

    public DisplayStatus(gui gui2) {
        this.guiControl = gui2;
        this.status = 0;
        this.configuredStatus = 0;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public int getStatus() {
        return this.status;
    }

    public void setConfigurationMode() {
        ConfigurationInterface configurationInterface = ConfigurationInterface.getInstance();
        configurationInterface.getConfiguration(0);
        if (configurationInterface.isConfigured()) {
            this.guiControl.displayPane.refreshDisplay();
            this.configuredStatus = 1;
            this.setModuleGroupSelectionMode();
            this.guiControl.menuBar.enableDisplayMenuItems(true);
        }
    }

    public void setModuleGroupSelectionMode() {
        this.unsubscribeAll();
        this.status = 1;
        boolean bl = true;
        this.guiControl.displayPane.setWriteAccess(bl);
        this.showParameterSelector();
        this.guiControl.colorScalePane.setColorScale();
        this.guiControl.tablesDisplayPane.updateTables();
        this.guiControl.displayPane.setDisplayColors();
        this.guiControl.displayPane.refreshDisplay();
    }

    public void setISMode() {
        this.unsubscribeAll();
        this.status = 2;
        this.showParameterSelector();
        this.guiControl.colorScalePane.setColorScale();
        this.guiControl.isInterface.setServerName(0);
        this.guiControl.isInterface.subscribe();
        this.guiControl.tablesDisplayPane.updateTables();
    }

    public void setTestDataMode(int n) {
        if (this.status == 3) {
            return;
        }
        this.unsubscribeAll();
        int n2 = this.status;
        this.status = 3;
        this.showParameterSelector();
        this.guiControl.displayPane.resetDisplayOption();
        this.guiControl.colorScalePane.setColorScale();
        this.guiControl.testDataInterface.subscribe(n);
        this.guiControl.tablesDisplayPane.updateTables(n2 == 4 || n2 == 3);
        this.guiControl.menuBar.resetTestListFilter();
    }

    public void setSCTDBDataMode(int n) {
        this.unsubscribeAll();
        int n2 = this.status;
        this.status = 4;
        this.showParameterSelector();
        this.guiControl.colorScalePane.setColorScale();
        this.guiControl.sctdbDataInterface.subscribe(n);
        this.guiControl.tablesDisplayPane.updateTables(n2 == 4 || n2 == 3);
    }

    public void unsubscribeAll() {
        if (this.status == 2) {
            this.guiControl.isInterface.unsubscribe();
        }
        if (this.status == 3) {
            this.guiControl.testDataInterface.unsubscribe();
        }
        if (this.status == 4) {
            this.guiControl.sctdbDataInterface.unsubscribe();
        }
    }

    private void showParameterSelector() {
        this.guiControl.selectorPane.initParamList();
    }
}

