/*
 * Decompiled with CFR 0.152.
 */
package DisplayGUI;

import DisplayGUI.displayParams;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;

public class ColorScale
implements displayParams {
    Vector values = new Vector();
    Vector colors = new Vector();
    Vector labels = new Vector();
    double firstDataPoint;
    double lastDataPoint;
    boolean isGradientPaint;
    boolean logScale;

    public ColorScale(double d, Color color, String string, double d2, Color color2, String string2) {
        this.values.addElement(new Double(d));
        this.values.addElement(new Double(d2));
        this.firstDataPoint = d;
        this.lastDataPoint = d2;
        this.colors.addElement(color);
        this.colors.addElement(color2);
        this.labels.addElement(string);
        this.labels.addElement(string2);
        this.isGradientPaint = true;
        this.logScale = false;
    }

    public ColorScale(double d, Color color, String string) {
        this.values.addElement(new Double(d));
        this.firstDataPoint = d;
        this.lastDataPoint = d;
        this.colors.addElement(color);
        this.labels.addElement(string);
        this.isGradientPaint = false;
        this.logScale = false;
    }

    public void setLogScale() {
        this.logScale = true;
    }

    public void add(double d, Color color, String string) {
        boolean bl = false;
        int n = 0;
        while (n < this.values.size()) {
            double d2 = (Double)this.values.elementAt(n);
            if (d == d2) {
                return;
            }
            if (d < d2) {
                this.values.insertElementAt(new Double(d), n);
                this.colors.insertElementAt(color, n);
                this.labels.insertElementAt(string, n);
                if (d < this.firstDataPoint) {
                    this.firstDataPoint = d;
                }
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            this.values.addElement(new Double(d));
            this.colors.addElement(color);
            this.labels.addElement(string);
            if (d > this.lastDataPoint) {
                this.lastDataPoint = d;
            }
        }
    }

    public void drawColorScale(Graphics2D graphics2D, int n, int n2) {
        Rectangle2D.Double double_;
        if (!this.isGradientPaint) {
            this.drawSolidColorScale(graphics2D, n, n2);
            return;
        }
        if (this.logScale) {
            this.lastDataPoint = Math.log(this.lastDataPoint) / Math.log(10.0);
            this.firstDataPoint = Math.log(this.firstDataPoint) / Math.log(10.0);
        }
        double d = (Double)this.values.elementAt(0);
        if (this.logScale) {
            d = Math.log(d) / Math.log(10.0);
        }
        Color color = (Color)this.colors.elementAt(0);
        String string = (String)this.labels.elementAt(0);
        this.drawAxisLabel(graphics2D, n, n2, string);
        int n3 = n;
        int n4 = 1;
        while (n4 < this.values.size()) {
            double d2 = (Double)this.values.elementAt(n4);
            if (this.logScale) {
                d2 = Math.log(d2) / Math.log(10.0);
            }
            Color color2 = (Color)this.colors.elementAt(n4);
            string = (String)this.labels.elementAt(n4);
            double d3 = (d2 - d) / (this.lastDataPoint - this.firstDataPoint);
            int n5 = (int)(d3 * 250.0);
            this.drawAxisLabel(graphics2D, n3 + n5, n2, string);
            Color color3 = color;
            if (!color2.equals(color)) {
                GradientPaint gradientPaint = new GradientPaint(n3, n2, color, n5 + n3, n2, color2);
                graphics2D.setPaint(gradientPaint);
            } else {
                graphics2D.setPaint(color);
            }
            int n6 = n4 == this.values.size() - 1 ? n + 250 - n3 : n5;
            double_ = new Rectangle2D.Double(n3, n2, n6, 10.0);
            graphics2D.fill(double_);
            color = color2;
            d = d2;
            n3 += n5;
            ++n4;
        }
        double_ = new Rectangle2D.Double(n, n2, 250.0, 10.0);
        graphics2D.setPaint(Color.black);
        graphics2D.draw(double_);
    }

    public void drawSolidColorScale(Graphics2D graphics2D, int n, int n2) {
        Rectangle2D.Double double_;
        int n3 = this.values.size();
        int n4 = (int)(250.0 / (double)n3);
        int n5 = 0;
        int n6 = 0;
        while (n6 < this.values.size()) {
            double d = (Double)this.values.elementAt(n6);
            Color color = (Color)this.colors.elementAt(n6);
            String string = (String)this.labels.elementAt(n6);
            this.drawAxisLabel(graphics2D, n + n5 + n4 / 2, n2, string);
            graphics2D.setPaint(color);
            double_ = new Rectangle2D.Double(n + n5, n2, n4, 10.0);
            graphics2D.fill(double_);
            n5 += n4;
            ++n6;
        }
        double_ = new Rectangle2D.Double(n, n2, n3 * n4, 10.0);
        graphics2D.setPaint(Color.black);
        graphics2D.draw(double_);
    }

    public void drawAxisLabel(Graphics2D graphics2D, int n, int n2, String string) {
        graphics2D.setPaint(Color.black);
        graphics2D.draw(new Line2D.Double(n, n2, n, n2 - 5));
        graphics2D.setFont(displayParams.displayScaleFont);
        graphics2D.setPaint(displayParams.darkBlueColor);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n3 = fontMetrics.stringWidth(string);
        int n4 = fontMetrics.getHeight();
        graphics2D.drawString(string, n - n3 / 2, n2 - 5 - 2);
    }

    public Color getColor(double d) {
        double d2;
        if (!this.isGradientPaint) {
            int n = 0;
            while (n < this.values.size()) {
                double d3 = (Double)this.values.elementAt(n);
                if (d <= d3) {
                    return (Color)this.colors.elementAt(n);
                }
                ++n;
            }
            return (Color)this.colors.lastElement();
        }
        if (this.logScale) {
            d = Math.log(d) / Math.log(10.0);
        }
        Color color = (Color)this.colors.elementAt(0);
        double d4 = d2 = this.logScale ? Math.log((Double)this.values.elementAt(0)) / Math.log(10.0) : (Double)this.values.elementAt(0);
        if (d <= d2) {
            return color;
        }
        int n = 1;
        while (n < this.values.size()) {
            double d5 = this.logScale ? Math.log((Double)this.values.elementAt(n)) / Math.log(10.0) : (Double)this.values.elementAt(n);
            Color color2 = (Color)this.colors.elementAt(n);
            if (d <= d5) {
                int n2 = color.getRed();
                int n3 = color2.getRed();
                int n4 = color.getBlue();
                int n5 = color2.getBlue();
                int n6 = color.getGreen();
                int n7 = color2.getGreen();
                double d6 = (d - d2) / (d5 - d2);
                if (d6 < 0.0) {
                    d6 = 0.0;
                }
                if (d6 > 1.0) {
                    d6 = 1.0;
                }
                double d7 = (double)(n3 - n2) * d6;
                double d8 = (double)(n5 - n4) * d6;
                double d9 = (double)(n7 - n6) * d6;
                return new Color(n2 + (int)d7, n6 + (int)d9, n4 + (int)d8);
            }
            color = color2;
            d2 = d5;
            ++n;
        }
        return color;
    }

    public String getLabel(String string) {
        try {
            int n = 0;
            while (n < this.values.size()) {
                String string2;
                double d = (Double)this.values.elementAt(n);
                if (Double.parseDouble(string) == d && (string2 = (String)this.labels.elementAt(n)).indexOf("<") == -1 && string2.indexOf(">") == -1) {
                    return string2;
                }
                ++n;
            }
        }
        catch (Exception exception) {}
        return string;
    }
}

