/*
 * Decompiled with CFR 0.152.
 */
package DisplayGUI;

import DisplayGUI.displayParams;
import DisplayGUI.gui;
import GuiComponents.System.ISInterface;
import Sct.IS.SctNames;
import Sct_CalibrationController.CalibrationControllerStatus;
import is.AnyInfo;
import is.Info;
import is.InfoEvent;
import is.InfoListener;
import is.InfoNotCompatibleException;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class CalibrationControllerPanel2
extends JPanel
implements InfoListener,
displayParams {
    gui guiControl;
    CalibrationControllerStatus status;
    int currentBin = -1;
    int maxBin = -1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JTextField scanIndexField;
    private JTextField sequenceField;
    private JTextField statusField;
    private JTextField testField;
    private JProgressBar progressBar;
    private ISInterface is;

    public CalibrationControllerPanel2(gui gui2) {
        this.guiControl = gui2;
        this.setBackground(new Color(255, 255, 255));
        this.is = ISInterface.getInstance();
        this.initComponents();
        this.myInitComponents();
        this.addMouseListener(new ccMouseAdapter());
    }

    private void myInitComponents() {
        try {
            this.status = new CalibrationControllerStatus();
            this.is.getRepository().getValue(SctNames.getControlISServer() + ".Status", (Info)this.status);
            this.updateStatus();
        }
        catch (RuntimeException runtimeException) {
            this.status = null;
            System.err.println("Couldn't get CalibrationController Status: " + runtimeException.getMessage());
            this.updateStatus();
        }
        try {
            this.is.subscribe(SctNames.getControlISServer(), "Status", false, this);
        }
        catch (RuntimeException runtimeException) {
            System.err.println("Couldn't subscribe to ControlData IS Server: " + runtimeException.getMessage());
        }
        try {
            this.is.subscribe("SCTAPIServer", "currentBin", false, this);
            this.is.subscribe("SCTAPIServer", "maxBin", false, this);
        }
        catch (RuntimeException runtimeException) {
            System.err.println("Couldn't subscribe to SCTAPIServer: " + runtimeException.getMessage());
        }
    }

    void close() {
        try {
            this.is.unsubscribe(SctNames.getControlISServer(), "Status");
        }
        catch (RuntimeException runtimeException) {
            System.err.println("Couldn't unsubscribe from ControlData IS Server: " + runtimeException.getMessage());
        }
        try {
            this.is.unsubscribe("SCTAPIServer", "currentBin");
            this.is.unsubscribe("SCTAPIServer", "maxBin");
        }
        catch (RuntimeException runtimeException) {
            System.err.println("Couldn't unsubscribe from SCTAPIServer: " + runtimeException.getMessage());
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.statusField = new JTextField();
        this.jLabel2 = new JLabel();
        this.testField = new JTextField();
        this.jLabel3 = new JLabel();
        this.sequenceField = new JTextField();
        this.jLabel4 = new JLabel();
        this.scanIndexField = new JTextField();
        this.jLabel5 = new JLabel();
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
        this.progressBar.setString("");
        this.progressBar.setMaximum(100);
        this.progressBar.setValue(0);
        this.progressBar.setForeground(displayParams.darkBlueColor);
        this.setLayout(new GridLayout(5, 2));
        this.setBackground(displayParams.backgroundColor);
        this.jLabel1.setFont(displayParams.displayCCBoldFont);
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText("CalibrationController Status : ");
        this.add(this.jLabel1);
        this.statusField.setBackground(displayParams.backgroundColor);
        this.statusField.setColumns(15);
        this.statusField.setEditable(false);
        this.statusField.setFont(displayParams.displayCCFont);
        this.statusField.addMouseListener(new ccMouseAdapter());
        this.statusField.setBorder(new EmptyBorder(new Insets(1, 1, 1, 1)));
        this.statusField.setDisabledTextColor(new Color(255, 255, 255));
        this.add(this.statusField);
        this.jLabel2.setFont(displayParams.displayCCBoldFont);
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText("Current Test : ");
        this.add(this.jLabel2);
        this.testField.setBackground(displayParams.backgroundColor);
        this.testField.setColumns(15);
        this.testField.setEditable(false);
        this.testField.setFont(displayParams.displayCCFont);
        this.testField.setBorder(new EmptyBorder(new Insets(1, 1, 1, 1)));
        this.testField.setDisabledTextColor(new Color(255, 255, 255));
        this.testField.addMouseListener(new ccMouseAdapter());
        this.add(this.testField);
        this.jLabel3.setFont(displayParams.displayCCBoldFont);
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText("Current Sequence : ");
        this.add(this.jLabel3);
        this.sequenceField.setBackground(displayParams.backgroundColor);
        this.sequenceField.setColumns(15);
        this.sequenceField.setEditable(false);
        this.sequenceField.setFont(displayParams.displayCCFont);
        this.sequenceField.setBorder(new EmptyBorder(new Insets(1, 1, 1, 1)));
        this.sequenceField.setDisabledTextColor(new Color(255, 255, 255));
        this.sequenceField.addMouseListener(new ccMouseAdapter());
        this.add(this.sequenceField);
        this.jLabel4.setFont(displayParams.displayCCBoldFont);
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText("Current Scan Index : ");
        this.add(this.jLabel4);
        this.scanIndexField.setBackground(displayParams.backgroundColor);
        this.scanIndexField.setColumns(15);
        this.scanIndexField.setEditable(false);
        this.scanIndexField.setFont(displayParams.displayCCFont);
        this.scanIndexField.setBorder(new EmptyBorder(new Insets(1, 1, 1, 1)));
        this.scanIndexField.setDisabledTextColor(new Color(255, 255, 255));
        this.scanIndexField.addMouseListener(new ccMouseAdapter());
        this.add(this.scanIndexField);
        this.jLabel5.setFont(displayParams.displayCCBoldFont);
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText("Scan Progress : ");
        this.add(this.jLabel5);
        this.progressBar.setBackground(displayParams.backgroundColor);
        this.progressBar.setFont(displayParams.displayCCFont);
        this.progressBar.setBorderPainted(false);
        this.progressBar.setBorder(new EmptyBorder(new Insets(1, 1, 1, 1)));
        this.progressBar.addMouseListener(new ccMouseAdapter());
        this.add(this.progressBar);
        this.setBorder(new TitledBorder(null, "Scan Status", 0, 0, new Font("Arial", 0, 11), new Color(0, 0, 153)));
    }

    void updateStatus() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (CalibrationControllerPanel2.this.status == null) {
                    CalibrationControllerPanel2.this.statusField.setText("UNAVAILABLE");
                    CalibrationControllerPanel2.this.statusField.setForeground(Color.red);
                    CalibrationControllerPanel2.this.guiControl.menuBar.enableCCMenuItems(false);
                } else {
                    switch (CalibrationControllerPanel2.this.status.status) {
                        case 0: {
                            CalibrationControllerPanel2.this.statusField.setText("LOADED");
                            CalibrationControllerPanel2.this.statusField.setForeground(displayParams.darkGreenColor);
                            CalibrationControllerPanel2.this.guiControl.menuBar.enableCCMenuItems(false);
                            break;
                        }
                        case 1: {
                            CalibrationControllerPanel2.this.statusField.setText("INCONTROL");
                            CalibrationControllerPanel2.this.statusField.setForeground(displayParams.darkGreenColor);
                            CalibrationControllerPanel2.this.guiControl.menuBar.enableCCMenuItems(true);
                            break;
                        }
                        case 2: {
                            CalibrationControllerPanel2.this.statusField.setText("BUSY");
                            CalibrationControllerPanel2.this.statusField.setForeground(Color.orange);
                            CalibrationControllerPanel2.this.guiControl.menuBar.enableCCMenuItems(false);
                            break;
                        }
                        case 3: {
                            CalibrationControllerPanel2.this.statusField.setText("ERROR");
                            CalibrationControllerPanel2.this.statusField.setForeground(Color.orange);
                            CalibrationControllerPanel2.this.guiControl.menuBar.enableCCMenuItems(false);
                            break;
                        }
                        default: {
                            CalibrationControllerPanel2.this.statusField.setText("UNKNOWN");
                            CalibrationControllerPanel2.this.statusField.setForeground(Color.red);
                            CalibrationControllerPanel2.this.guiControl.menuBar.enableCCMenuItems(false);
                        }
                    }
                    CalibrationControllerPanel2.this.sequenceField.setText(CalibrationControllerPanel2.this.status.currentSequence);
                    CalibrationControllerPanel2.this.testField.setText(CalibrationControllerPanel2.this.status.currentTest);
                    CalibrationControllerPanel2.this.scanIndexField.setText(Integer.toString(CalibrationControllerPanel2.this.status.currentScanIndex));
                    CalibrationControllerPanel2.this.guiControl.menuBar.checkCCUpdateMode();
                }
            }
        });
    }

    void updateProgressBar() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (CalibrationControllerPanel2.this.maxBin == -1) {
                    CalibrationControllerPanel2.this.progressBar.setMaximum(1000);
                } else {
                    CalibrationControllerPanel2.this.progressBar.setMaximum(CalibrationControllerPanel2.this.maxBin);
                }
                if (CalibrationControllerPanel2.this.currentBin == -1) {
                    CalibrationControllerPanel2.this.progressBar.setValue(0);
                    CalibrationControllerPanel2.this.progressBar.setString("");
                } else {
                    CalibrationControllerPanel2.this.progressBar.setValue(CalibrationControllerPanel2.this.currentBin);
                    if (CalibrationControllerPanel2.this.maxBin == -1) {
                        CalibrationControllerPanel2.this.progressBar.setString(Integer.toString(CalibrationControllerPanel2.this.currentBin));
                    } else {
                        CalibrationControllerPanel2.this.progressBar.setString(Integer.toString(CalibrationControllerPanel2.this.currentBin) + " out of " + Integer.toString(CalibrationControllerPanel2.this.maxBin) + " bins");
                        if (CalibrationControllerPanel2.this.maxBin == CalibrationControllerPanel2.this.currentBin) {
                            CalibrationControllerPanel2.this.progressBar.setForeground(displayParams.darkGreenColor);
                        } else {
                            CalibrationControllerPanel2.this.progressBar.setForeground(displayParams.darkBlueColor);
                        }
                    }
                }
            }
        });
    }

    public void infoCreated(InfoEvent infoEvent) {
        String string = infoEvent.getName();
        if (string.equals(SctNames.getControlISServer() + ".Status")) {
            try {
                this.status = new CalibrationControllerStatus();
                infoEvent.getValue((Info)this.status);
                this.updateStatus();
            }
            catch (InfoNotCompatibleException infoNotCompatibleException) {
                System.err.println("Unable to read IS object - not a CalibrationControllerStatus: " + infoNotCompatibleException.getMessage());
            }
        } else {
            try {
                AnyInfo anyInfo = new AnyInfo();
                infoEvent.getValue((Info)anyInfo);
                if (string.equals("SCTAPIServer.currentBin")) {
                    this.currentBin = (Integer)anyInfo.getAttribute(0);
                } else if (string.equals("SCTAPIServer.maxBin")) {
                    this.maxBin = (Integer)anyInfo.getAttribute(0);
                }
                this.updateProgressBar();
            }
            catch (Exception exception) {
                System.err.println("Unable to update progressBar - " + exception.toString());
            }
        }
    }

    public void infoDeleted(InfoEvent infoEvent) {
        if (infoEvent.getName().equals(SctNames.getControlISServer() + ".Status")) {
            this.status = null;
            this.updateStatus();
        } else {
            this.currentBin = -1;
            this.maxBin = -1;
            this.updateProgressBar();
        }
    }

    public void infoUpdated(InfoEvent infoEvent) {
        this.infoCreated(infoEvent);
    }

    class ccMouseAdapter
    extends MouseAdapter {
        ccMouseAdapter() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            switch (mouseEvent.getModifiers()) {
                case 4: 
                case 8: {
                    CalibrationControllerPanel2.this.guiControl.menuBar.showCCPopupMenu(mouseEvent);
                    break;
                }
            }
        }
    }
}

