/*
 * Decompiled with CFR 0.152.
 */
package oh.aida;

import hep.aida.IAnnotation;
import hep.aida.IAxis;
import hep.aida.IHistogram;
import oh.ISAxis;
import oh.ISHistogram;

public abstract class ISHistogramAdapter
implements IHistogram {
    protected ISHistogram data;

    public ISHistogramAdapter(ISHistogram iSHistogram) {
        this.data = iSHistogram;
    }

    protected void unimplementedFunction() {
        System.err.println("Error - unimplemented function called in :" + this);
        Thread.currentThread();
        Thread.dumpStack();
    }

    public int dimension() {
        return this.data.is_axis.length;
    }

    public IAnnotation annotation() {
        return new AnnotationAdapter();
    }

    public int entries() {
        return 0;
    }

    public void reset() throws RuntimeException {
        this.unimplementedFunction();
    }

    public void setTitle(String string) throws IllegalArgumentException {
        this.unimplementedFunction();
    }

    public String title() {
        return this.data.is_title;
    }

    public int allEntries() {
        return 0;
    }

    public double equivalentBinEntries() {
        return 0.0;
    }

    public int extraEntries() {
        return 0;
    }

    public double maxBinHeight() {
        this.unimplementedFunction();
        return 0.0;
    }

    public double minBinHeight() {
        this.unimplementedFunction();
        return 0.0;
    }

    public void scale(double d) throws IllegalArgumentException {
        this.unimplementedFunction();
    }

    public double sumAllBinHeights() {
        this.unimplementedFunction();
        return 0.0;
    }

    public double sumBinHeights() {
        this.unimplementedFunction();
        return 0.0;
    }

    public double sumExtraBinHeights() {
        this.unimplementedFunction();
        return 0.0;
    }

    protected double _binError(int n) throws IllegalArgumentException {
        if (n >= this.data.is_errors.length) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            throw illegalArgumentException;
        }
        if (this.data.is_errors.length != 0) {
            return this.data.is_errors[n];
        }
        if (this.data.is_minuserrors.length != 0 && this.data.is_pluserrors.length != 0) {
            return this.data.is_pluserrors[n] + this.data.is_minuserrors[n];
        }
        return 0.0;
    }

    protected double _binHeight(int n) throws IllegalArgumentException {
        if (n < this.data.is_bins.length) {
            return this.data.is_bins[n];
        }
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
        throw illegalArgumentException;
    }

    class AxisAdapter
    implements IAxis {
        protected ISAxis axis;

        AxisAdapter(int n) {
            this.axis = ISHistogramAdapter.this.data.is_axis[n];
        }

        public double binLowerEdge(int n) {
            if (this.axis.is_type == 0) {
                return this.axis.is_axis[0] + this.axis.is_axis[1] * (double)(n - 1);
            }
            ISHistogramAdapter.this.unimplementedFunction();
            return 0.0;
        }

        public double binUpperEdge(int n) {
            if (this.axis.is_type == 0) {
                return this.axis.is_axis[0] + this.axis.is_axis[1] * (double)n;
            }
            ISHistogramAdapter.this.unimplementedFunction();
            return 0.0;
        }

        public double binWidth(int n) {
            if (this.axis.is_type == 0) {
                return this.axis.is_axis[1];
            }
            ISHistogramAdapter.this.unimplementedFunction();
            return 0.0;
        }

        public int bins() {
            if (this.axis.is_type == 0) {
                return (int)this.axis.is_axis[2];
            }
            ISHistogramAdapter.this.unimplementedFunction();
            return 0;
        }

        public int coordToIndex(double d) {
            ISHistogramAdapter.this.unimplementedFunction();
            return 0;
        }

        public boolean isFixedBinning() {
            return this.axis.is_type == 0;
        }

        public double lowerEdge() {
            if (this.axis.is_type == 0) {
                return this.axis.is_axis[0];
            }
            ISHistogramAdapter.this.unimplementedFunction();
            return 0.0;
        }

        public double upperEdge() {
            if (this.axis.is_type == 0) {
                return this.axis.is_axis[1] * this.axis.is_axis[2];
            }
            ISHistogramAdapter.this.unimplementedFunction();
            return 0.0;
        }
    }

    class AnnotationAdapter
    implements IAnnotation {
        AnnotationAdapter() {
        }

        public void addItem(String string, String string2) throws IllegalArgumentException {
            ISHistogramAdapter.this.unimplementedFunction();
        }

        public void addItem(String string, String string2, boolean bl) throws IllegalArgumentException {
            ISHistogramAdapter.this.unimplementedFunction();
        }

        public String key(int n) {
            return ISHistogramAdapter.this.data.is_annotations[n * 2];
        }

        public void removeItem(String string) throws IllegalArgumentException {
            ISHistogramAdapter.this.unimplementedFunction();
        }

        public void reset() {
            ISHistogramAdapter.this.unimplementedFunction();
        }

        public void setSticky(String string, boolean bl) {
            ISHistogramAdapter.this.unimplementedFunction();
        }

        public void setValue(String string, String string2) {
            ISHistogramAdapter.this.unimplementedFunction();
        }

        public int size() {
            return ISHistogramAdapter.this.data.is_annotations.length / 2;
        }

        public String value(String string) {
            int n = 0;
            while (n < ISHistogramAdapter.this.data.is_annotations.length) {
                if (ISHistogramAdapter.this.data.is_annotations[n].equals(string)) {
                    return ISHistogramAdapter.this.data.is_annotations[n + 1];
                }
                n += 2;
            }
            return null;
        }

        public String value(int n) {
            return ISHistogramAdapter.this.data.is_annotations[n * 2 + 1];
        }
    }
}

