/*
 * Decompiled with CFR 0.152.
 */
package hep.physics.yappi.util;

import hep.physics.ParticlePropertyProvider;
import hep.physics.yappi.PDGID;
import hep.physics.yappi.ParticleType;
import hep.physics.yappi.XMLYappi;
import hep.physics.yappi.Yappi;

public class JasYappiAdapter
implements ParticlePropertyProvider {
    ParticleType tp;
    Yappi yappi;

    public JasYappiAdapter(String filename) {
        try {
            this.yappi = new XMLYappi(filename);
        }
        catch (Exception e) {
            System.err.println("JasYappiAdapter: cannot open file: " + filename);
        }
    }

    public hep.physics.ParticleType get(int PDGID2) {
        try {
            this.tp = this.yappi.getParticle(new PDGID(PDGID2));
            return new JasParticleType();
        }
        catch (Exception e) {
            return null;
        }
    }

    private class JasParticleType
    implements hep.physics.ParticleType {
        private JasParticleType() {
        }

        public String getName() {
            return JasYappiAdapter.this.tp.getName();
        }

        public int getPDGID() {
            try {
                return JasYappiAdapter.this.tp.getPDGID().getID();
            }
            catch (Exception e) {
                return 0;
            }
        }

        public int get2xSpin() {
            try {
                Integer spin = new Integer(JasYappiAdapter.this.tp.getData("Spin").getValueAsString());
                return spin;
            }
            catch (Exception e) {
                return 0;
            }
        }

        public double getCharge() {
            try {
                return JasYappiAdapter.this.tp.getData("Charge").getValue();
            }
            catch (Exception e) {
                return 0.0;
            }
        }

        public double getMass() {
            try {
                return JasYappiAdapter.this.tp.getData("Mass").getValue();
            }
            catch (Exception e) {
                return 0.0;
            }
        }

        public double getWidth() {
            try {
                return JasYappiAdapter.this.tp.getData("Width").getValue();
            }
            catch (Exception e) {
                return 0.0;
            }
        }

        public String toString() {
            return JasYappiAdapter.this.tp.getName() + " (PDGid=" + JasYappiAdapter.this.tp.getPDGID() + ")";
        }
    }
}

