/*
 * Decompiled with CFR 0.152.
 */
package hep.physics.yappi.io;

import hep.physics.yappi.Data;
import hep.physics.yappi.DecayChannel;
import hep.physics.yappi.DecayGroup;
import hep.physics.yappi.Family;
import hep.physics.yappi.ParticleType;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import org.freehep.xml.util.XHTMLWriter;

public class HTMLYappiWriter
extends XHTMLWriter {
    private static final String minus = "&#150;";
    private static final String plus = "+";
    private static final String plusorminus = "&plusmn;";
    private int bgRow = 0;
    private static HashMap greekTable = new HashMap();

    public HTMLYappiWriter(Writer out) {
        super(out);
    }

    public void close() throws IOException {
        super.close();
    }

    public void write(Object object) {
        if (object instanceof ParticleType) {
            this.write((ParticleType)object);
        } else if (object instanceof Family) {
            this.write((Family)object);
        } else {
            System.err.println("HTMLYappiWriter: do not know how to write object of type: " + object.getClass());
        }
    }

    public void writeHead(String title) {
        this.printComment(" WARNING: This file was generated by a program, do NOT edit ");
        this.openTag("head");
        this.setAttribute("name", "keywords");
        this.setAttribute("content", "hep, particle property, pdg, yappi");
        this.printTag("meta");
        this.setAttribute("name", "Author");
        this.setAttribute("content", "Auto-Generated by YaPPI: see http://yappi.freehep.org/");
        this.printTag("meta");
        this.openTag("title");
        this.println("Particle: " + title);
        this.closeTag();
        this.setAttribute("rel", "stylesheet");
        this.setAttribute("type", "text/css");
        this.setAttribute("href", "hep/physics/yappi/io/yappi.css");
        this.printTag("link");
        this.closeTag();
    }

    public void write(Family family) {
        if (family != null) {
            this.setAttribute("class", "family");
            this.openTag("div");
            this.encode(family.getName(), "family");
            this.closeTag();
            this.printTag("hr");
        }
    }

    public void write(ParticleType particle) {
        this.setAttribute("class", "particle");
        this.openTag("div");
        this.setAttribute("border", 0);
        this.setAttribute("width", "100%");
        this.setAttribute("summary", "Particle name and definition");
        this.openTag("table");
        this.openTag("tr");
        this.setAttribute("nowrap", true);
        this.setAttribute("width", "20%");
        this.setAttribute("class", "particle-name");
        this.openTag("td");
        this.encode(particle.getName(), "particlename");
        this.closeTag();
        this.setAttribute("nowrap", true);
        this.setAttribute("width", "20%");
        this.setAttribute("class", "particle-asciiname");
        this.openTag("td");
        this.println(particle.getName());
        this.closeTag();
        this.setAttribute("nowrap", true);
        this.openTag("td");
        this.closeTag();
        this.setAttribute("nowrap", true);
        this.setAttribute("width", "30%");
        this.setAttribute("class", "particle-info");
        this.openTag("td");
        this.printPlain("I<sup class=\"particle\">G</sup>");
        this.printPlain("(J<sup class=\"particle\">PC</sup>) = ");
        this.printPlain("0<sup class=\"particle\">+</sup>");
        this.printPlain("(0<sup class=\"particle\">&#150;+</sup>)");
        this.closeTag();
        this.closeTag();
        this.closeTag();
        this.closeTag();
        this.openTag("p");
        this.print(" ");
        this.closeTag();
        this.setAttribute("class", "property");
        this.openTag("div");
        this.setAttribute("border", 0);
        this.setAttribute("summary", "Particle data");
        this.setAttribute("class", "property");
        this.openTag("table");
        Iterator iterator = particle.getData();
        while (iterator.hasNext()) {
            Data data = (Data)iterator.next();
            this.write(data);
        }
        this.closeTag();
        this.closeTag();
        this.openTag("p");
        this.print(" ");
        this.closeTag();
        this.setAttribute("class", "decay");
        this.openTag("div");
        this.writeDecayModes(particle);
        this.closeTag();
        this.printTag("hr");
        this.setAttribute("class", "footer");
        this.openTag("address");
        this.println("Generated by ");
        this.setAttribute("href", "http://yappi.freehep.org");
        this.setAttribute("class", "footer");
        this.openTag("a");
        this.print("YaPPI, Yet another Particle Property Interface");
        this.closeTag();
        this.println(", ");
        this.setAttribute("href", "http://www.cern.ch");
        this.setAttribute("class", "footer");
        this.openTag("a");
        this.print("CERN");
        this.closeTag();
        this.println(", Copyright 2000, 2001.");
        this.closeTag();
        this.setAttribute("class", "footer");
        this.openTag("address");
        this.println("Data provided by the ");
        this.setAttribute("href", "http://pdg.lbl.gov");
        this.setAttribute("class", "footer");
        this.openTag("a");
        this.print("PDG, Particle Data Group");
        this.closeTag();
        this.println(", Copyright 2000.");
        this.closeTag();
    }

    private void write(Data data) {
        String posError = data.getPosErrorAsString();
        String negError = data.getNegErrorAsString();
        int rowspan = posError == null || posError.equals(negError) ? 1 : 2;
        this.setAttribute("class", "property");
        this.openTag("tr");
        this.setAttribute("rowspan", rowspan);
        this.setAttribute("nowrap", true);
        this.setAttribute("class", "property");
        this.openTag("td");
        this.println(data.getName());
        this.closeTag();
        this.setAttribute("align", "right");
        this.setAttribute("rowspan", rowspan);
        this.setAttribute("nowrap", true);
        this.setAttribute("class", "property");
        this.openTag("td");
        int mantissa = this.writeValue(data.getValueAsString());
        this.closeTag();
        this.printPlain("<td nowrap=\"nowrap\"");
        if (posError != null) {
            if (rowspan == 1) {
                this.printPlain(" class=\"property\">");
                this.printPlain("&plusmn; ");
                this.writeValue(posError);
            } else {
                this.printPlain(" class=\"property-poserror\">");
                this.printPlain("+ ");
                this.writeValue(posError);
            }
        } else {
            this.printPlain(" class=\"property\">");
        }
        this.printPlain("</td>");
        this.setAttribute("rowspan", rowspan);
        this.setAttribute("nowrap", true);
        this.setAttribute("class", "property");
        this.openTag("td");
        if (mantissa != 0) {
            this.writeMantissa(mantissa);
        } else {
            this.print(" ");
        }
        this.closeTag();
        this.setAttribute("rowspan", rowspan);
        this.setAttribute("nowrap", true);
        this.setAttribute("class", "property");
        this.openTag("td");
        this.println(data.getUnit());
        this.closeTag();
        this.setAttribute("rowspan", rowspan);
        this.setAttribute("nowrap", true);
        this.setAttribute("class", "property");
        this.openTag("td");
        double scaleFactor = data.getScaleFactor();
        if (scaleFactor > 0.0) {
            this.println("(S = " + scaleFactor + ")");
        }
        this.closeTag();
        this.closeTag();
        if (rowspan == 2) {
            this.openTag("tr");
            this.printPlain("<td valign=\"bottom\" nowrap=\"nowrap\" class=\"property-negerror\">");
            this.printPlain("&#150; ");
            this.writeValue(negError);
            this.printPlain("</td>");
            this.closeTag();
        }
    }

    private void writeDecayModes(ParticleType particle) {
        this.setAttribute("width", "100%");
        this.setAttribute("border", 0);
        this.setAttribute("cellpadding", 2);
        this.setAttribute("cellspacing", 0);
        this.setAttribute("summary", "Particle Decay Modes");
        this.setAttribute("class", "decay");
        this.openTag("table");
        this.setAttribute("class", "decay-header");
        this.openTag("tr");
        this.setAttribute("nowrap", true);
        this.setAttribute("colspan", 2);
        this.setAttribute("align", "left");
        this.setAttribute("class", "decay-header");
        this.openTag("th");
        this.encode(particle.getName(), "decayheader");
        this.println(" Decay Modes");
        this.closeTag();
        this.setAttribute("nowrap", true);
        this.setAttribute("colspan", 4);
        this.setAttribute("align", "left");
        this.setAttribute("class", "decay-header");
        this.openTag("th");
        this.print("Fraction (");
        this.setAttribute("class", "symbol");
        this.openTag("span");
        this.print("G");
        this.closeTag();
        this.setAttribute("class", "decay-header");
        this.openTag("sub");
        this.print("i");
        this.closeTag();
        this.print("/");
        this.setAttribute("class", "symbol");
        this.openTag("span");
        this.print("G");
        this.closeTag();
        this.println(")");
        this.closeTag();
        this.setAttribute("nowrap", true);
        this.setAttribute("class", "decay-header");
        this.openTag("th");
        this.print("Confidence");
        this.printTag("br");
        this.println("Level");
        this.closeTag();
        this.setAttribute("nowrap", true);
        this.setAttribute("align", "right");
        this.setAttribute("class", "decay-header");
        this.openTag("th");
        this.setAttribute("border", 0);
        this.setAttribute("cellspacing", 0);
        this.setAttribute("cellpadding", 0);
        this.setAttribute("class", "decay");
        this.openTag("table");
        this.setAttribute("nowrap", true);
        this.setAttribute("class", "decay-header");
        this.openTag("th");
        this.print("p");
        this.printTag("br");
        this.println("(MeV/c)");
        this.closeTag();
        this.closeTag();
        this.closeTag();
        this.closeTag();
        Iterator decayIterator = particle.getDecayChannels();
        while (decayIterator.hasNext()) {
            DecayChannel decay = (DecayChannel)decayIterator.next();
            if (decay.getDecayGroup() != null) continue;
            this.write(decay);
        }
        Iterator groupIterator = particle.getDecayGroups();
        while (groupIterator.hasNext()) {
            DecayGroup group = (DecayGroup)groupIterator.next();
            this.write(group);
            Iterator iterator = particle.getDecayChannels();
            while (iterator.hasNext()) {
                DecayChannel decay = (DecayChannel)iterator.next();
                if (decay.getDecayGroup() != group) continue;
                this.write(decay);
            }
        }
        this.closeTag();
    }

    private void write(DecayGroup group) {
        this.setAttribute("class", "decay-group");
        this.openTag("tr");
        this.setAttribute("nowrap", true);
        this.setAttribute("colspan", 20);
        this.setAttribute("class", "decay-group");
        this.openTag("th");
        this.encode(group.getName(), "decay-group");
        this.closeTag();
        this.closeTag();
    }

    private void write(DecayChannel decay) {
        String posError = decay.getPosErrorAsString();
        String negError = decay.getNegErrorAsString();
        int rowspan = posError == null || posError.equals(negError) ? 1 : 2;
        this.setAttribute("class", "decay-" + (this.bgRow % 2 == 0 ? "even" : "odd"));
        this.openTag("tr");
        this.setAttribute("nowrap", true);
        this.setAttribute("rowspan", rowspan);
        this.setAttribute("class", "decay");
        this.openTag("td");
        this.encode(decay.getName(), "decay");
        this.closeTag();
        this.setAttribute("nowrap", true);
        this.setAttribute("rowspan", rowspan);
        this.setAttribute("class", "decay");
        this.openTag("td");
        this.print("&nbsp;");
        this.closeTag();
        this.setAttribute("nowrap", true);
        this.setAttribute("rowspan", rowspan);
        this.setAttribute("char", ".");
        this.setAttribute("align", "char");
        this.setAttribute("class", "decay");
        this.openTag("td");
        int mantissa = this.writeValue(decay.getFractionAsString());
        this.closeTag();
        this.printPlain("<td nowrap=\"nowrap\" char=\".\" align=\"char\"");
        if (posError != null) {
            if (rowspan == 1) {
                this.printPlain(" class=\"decay\">");
                this.printPlain("&plusmn; ");
                this.writeValue(posError);
            } else {
                this.printPlain(" class=\"decay-poserror\">");
                this.printPlain("+ ");
                this.writeValue(posError);
            }
        } else {
            this.printPlain(" class=\"decay\">&nbsp;");
        }
        this.printPlain("</td>");
        this.setAttribute("nowrap", true);
        this.setAttribute("rowspan", rowspan);
        this.setAttribute("align", "right");
        this.setAttribute("class", "decay");
        this.openTag("td");
        this.print("&nbsp;");
        this.closeTag();
        this.setAttribute("nowrap", true);
        this.setAttribute("rowspan", rowspan);
        this.setAttribute("class", "decay");
        this.openTag("td");
        if (mantissa != 0) {
            this.writeMantissa(mantissa);
        } else {
            this.print("%");
        }
        this.closeTag();
        this.setAttribute("nowrap", true);
        this.setAttribute("rowspan", rowspan);
        this.setAttribute("align", "right");
        this.setAttribute("class", "decay");
        this.openTag("td");
        this.print("&nbsp;");
        this.closeTag();
        this.setAttribute("nowrap", true);
        this.setAttribute("rowspan", rowspan);
        this.setAttribute("align", "right");
        this.setAttribute("class", "decay");
        this.openTag("td");
        String p = decay.getP();
        if (p != null) {
            this.print("" + decay.getP());
        } else {
            this.print("&#150; ");
        }
        this.closeTag();
        this.closeTag();
        if (rowspan == 2) {
            this.setAttribute("class", "decay-" + (this.bgRow % 2 == 0 ? "even" : "odd"));
            this.openTag("tr");
            this.printPlain("<td valign=\"bottom\" nowrap=\"nowrap\" char=\".\" align=\"char\" class=\"decay-negerror\">");
            this.printPlain("&#150; ");
            this.writeValue(negError);
            this.printPlain("</td>");
            this.closeTag();
        }
        ++this.bgRow;
    }

    private int writeValue(String value) {
        String v = value;
        int m = 0;
        if (!value.equals("seen")) {
            int e;
            int n = e = value.indexOf("E") >= 0 ? value.indexOf("E") : value.indexOf("e");
            if (e > 0) {
                v = value.substring(0, e);
                try {
                    m = Integer.parseInt(value.substring(e + 1));
                }
                catch (NumberFormatException nfe) {
                    System.err.println("Problem getting mantissa from string: " + value);
                }
            } else {
                v = value;
            }
        }
        this.printPlain(HTMLYappiWriter.normalize((String)v));
        return m;
    }

    private void writeMantissa(int m) {
        this.print("x 10");
        this.setAttribute("class", "decay");
        this.openTag("sup");
        this.print("" + m);
        this.closeTag();
    }

    private void encode(String s, String cls) {
        while (!s.equals("")) {
            String particleName = "";
            Iterator iterator = greekTable.keySet().iterator();
            boolean found = false;
            while (!found && iterator.hasNext()) {
                String greek = (String)iterator.next();
                if (!s.startsWith(greek)) continue;
                found = true;
                particleName = "<span class=\"symbol\">" + greekTable.get(greek) + "</span>";
                s = s.substring(greek.length());
            }
            if (!found && !Character.isDigit(s.charAt(0))) {
                particleName = s.substring(0, 1);
                s = s.substring(1);
            }
            if (s.startsWith("bar")) {
                this.printPlain("<span class=\"overline\">");
                this.printPlain(particleName);
                this.printPlain("</span>");
                s = s.substring(3);
            } else {
                this.printPlain(particleName);
            }
            if (!found) {
                int pos;
                int len = s.length();
                for (pos = 0; pos < len && Character.isDigit(s.charAt(pos)); ++pos) {
                }
                this.printPlain(s.substring(0, pos));
                s = s.substring(pos);
            }
            if (s.length() >= 3 && s.charAt(0) == '(' && s.charAt(2) == ')') {
                this.printPlain("<sub class=\"" + cls + "\">");
                this.printPlain(HTMLYappiWriter.normalize((String)s.substring(1, 2)));
                this.printPlain("</sub>");
                s = s.substring(3);
            }
            if (s.length() > 0) {
                if (s.startsWith("0")) {
                    this.printPlain("<sup class=\"" + cls + "\">");
                    this.printPlain("0");
                    this.printPlain("</sup>");
                    s = s.substring(1);
                } else if (s.startsWith(plus)) {
                    this.printPlain("<sup class=\"" + cls + "\">");
                    this.printPlain(plus);
                    this.printPlain("</sup>");
                    s = s.substring(1);
                } else if (s.startsWith("-")) {
                    this.printPlain("<sup class=\"" + cls + "\">");
                    this.printPlain(minus);
                    this.printPlain("</sup>");
                    s = s.substring(1);
                } else if (s.startsWith("*")) {
                    this.printPlain("<sup class=\"" + cls + "\">");
                    this.printPlain("*");
                    this.printPlain("</sup>");
                    s = s.substring(1);
                } else if (s.startsWith("'")) {
                    this.printPlain("<sup class=\"" + cls + "\">");
                    this.printPlain("'");
                    this.printPlain("</sup>");
                    s = s.substring(1);
                } else if (s.startsWith("pm")) {
                    this.printPlain("<sup class=\"" + cls + "\">");
                    this.printPlain(plusorminus);
                    this.printPlain("</sup>");
                    s = s.substring(2);
                } else if (s.startsWith("mp")) {
                    this.printPlain("<sup class=\"" + cls + "\">");
                    this.printPlain("&#150;/+");
                    this.printPlain("</sup>");
                    s = s.substring(2);
                }
            }
            if (s.length() >= 3 && s.charAt(0) == '(') {
                char c;
                int pos = s.indexOf(41);
                if (pos < 0) {
                    System.err.println("Error: non matching braces in: " + s);
                    s = s.substring(1);
                } else {
                    this.printPlain("(");
                    this.encode(HTMLYappiWriter.normalize((String)s.substring(1, pos)), cls);
                    this.printPlain(")");
                    s = s.substring(pos + 1);
                }
                if (s.length() > 0 && ((c = s.charAt(0)) == '0' || c == '+' || c == '-' || c == '\'' || c == '*')) {
                    this.printPlain("<sup class=\"" + cls + "\">");
                    if (c == '-') {
                        this.printPlain(minus);
                    } else {
                        this.printPlain(s.substring(0, 1));
                    }
                    this.printPlain("</sup>");
                    s = s.substring(1);
                }
            }
            while (s.length() > 0 && Character.isWhitespace(s.charAt(0))) {
                this.printPlain(" ");
                s = s.substring(1);
            }
        }
    }

    static {
        greekTable.put("Delta", "D");
        greekTable.put("Gamma", "G");
        greekTable.put("Lambda", "L");
        greekTable.put("Omega", "W");
        greekTable.put("Sigma", "S");
        greekTable.put("Upsilon", "U");
        greekTable.put("Xi", "X");
        greekTable.put("alpha", "a");
        greekTable.put("beta", "b");
        greekTable.put("chi", "c");
        greekTable.put("delta", "d");
        greekTable.put("eta", "h");
        greekTable.put("gamma", "g");
        greekTable.put("mu", "m");
        greekTable.put("nu", "n");
        greekTable.put("omega", "w");
        greekTable.put("phi", "f");
        greekTable.put("pi", "p");
        greekTable.put("psi", "y");
        greekTable.put("rho", "r");
        greekTable.put("sigma", "s");
        greekTable.put("tau", "t");
        greekTable.put("upsilon", "u");
        greekTable.put("xi", "x");
        greekTable.put("arrowright", "->");
    }
}

