/*
 * Decompiled with CFR 0.152.
 */
package hep.physics.yappi;

import hep.physics.yappi.Data;
import hep.physics.yappi.DecayChannel;
import hep.physics.yappi.DecayGroup;
import hep.physics.yappi.Family;
import hep.physics.yappi.ParticleType;
import hep.physics.yappi.Yappi;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import org.freehep.xml.util.XMLWriter;

public class XMLYappiWriter
extends XMLWriter {
    private static String nameSpace = "ppml";
    private DecayGroup currentGroup = null;

    public XMLYappiWriter(String filename) throws IOException {
        this(new BufferedWriter(new FileWriter(filename)));
    }

    public XMLYappiWriter(Writer writer) {
        super(writer);
        this.openDoc();
    }

    public void close() throws IOException {
        this.closeDoc();
        super.close();
    }

    public void write(Yappi yappi) {
        Map.Entry entry;
        this.setAttribute("xmlns", nameSpace, "http://www.freehep.org/Yappi");
        this.setAttribute("xmlns", "xsi", "http://www.w3.org/1999/XMLSchema-instance");
        this.setAttribute("xsi", "schemaLocation", "PPML.xsd");
        this.openTag(nameSpace, "yappi");
        Iterator i = yappi.getFamilies();
        while (i.hasNext()) {
            entry = (Map.Entry)i.next();
            this.write((Family)entry.getValue());
        }
        i = yappi.getParticles();
        while (i.hasNext()) {
            entry = (Map.Entry)i.next();
            this.write((ParticleType)entry.getValue());
        }
        this.closeTag();
    }

    public void write(Family family) {
        this.setAttribute("name", family.getName());
        this.setAttribute("texName", family.getTexName());
        this.openTag(nameSpace, "Family");
        Iterator i = family.getFamilies();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            this.write((Family)entry.getValue());
        }
        this.closeTag();
    }

    public void write(ParticleType particle) {
        this.currentGroup = null;
        this.setAttribute("name", particle.getName());
        this.setAttribute("texName", particle.getTexName());
        this.setAttribute("antiName", particle.getAntiName());
        this.setAttribute("antiTexName", particle.getAntiTexName());
        this.setAttribute("PDGID", particle.getPDGID().getID());
        this.openTag(nameSpace, "ParticleType");
        Iterator i = particle.getData();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            this.write((Data)entry.getValue());
        }
        i = particle.getDecayChannels();
        while (i.hasNext()) {
            this.write((DecayChannel)i.next());
        }
        this.closeTag();
    }

    public void write(Data data) {
        this.setAttribute("name", data.getName());
        this.setAttribute("texName", data.getTexName());
        this.setAttribute("value", data.getValueAsString());
        this.setAttribute("posError", data.getPosErrorAsString());
        this.setAttribute("negError", data.getNegErrorAsString());
        this.setAttribute("confidenceLevel", data.getConfidenceLevel());
        this.setAttribute("scaleFactor", data.getScaleFactor());
        this.printTag(nameSpace, "Data");
    }

    public void write(DecayChannel decay) {
        DecayGroup group = decay.getDecayGroup();
        if (this.currentGroup != group) {
            if (this.currentGroup != null) {
                this.closeTag();
            }
            if (group != null) {
                this.setAttribute("name", group.getName());
                this.openTag(nameSpace, "DecayGroup");
            }
            this.currentGroup = group;
        }
        this.setAttribute("name", decay.getName());
        this.setAttribute("texName", decay.getTexName());
        this.setAttribute("fraction", decay.getFractionAsString());
        this.setAttribute("posError", decay.getPosErrorAsString());
        this.setAttribute("negError", decay.getNegErrorAsString());
        this.setAttribute("confidenceLevel", decay.getConfidenceLevel());
        this.setAttribute("scaleFactor", decay.getScaleFactor());
        this.setAttribute("P", decay.getP());
        this.setAttribute("PUnit", decay.getPUnit());
        this.openTag(nameSpace, "Decay");
        this.closeTag();
    }
}

