/*
 * Decompiled with CFR 0.152.
 */
package hep.physics.yappi;

import hep.physics.yappi.Data;
import hep.physics.yappi.DecayChannel;
import hep.physics.yappi.DecayGroup;
import hep.physics.yappi.Family;
import hep.physics.yappi.PDGID;
import hep.physics.yappi.ParticleType;
import hep.physics.yappi.Yappi;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XMLYappiReader
extends DefaultHandler {
    boolean debug = false;
    private static boolean setValidation = false;
    private static boolean setNameSpaces = true;
    private static boolean setSchemaSupport = true;
    private XMLReader xmlReader = null;
    private Yappi yappi = null;
    private Family family = null;
    private ParticleType particle = null;
    private DecayGroup group = null;

    public XMLYappiReader(Yappi yappi) {
        this.yappi = yappi;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            this.xmlReader = factory.newSAXParser().getXMLReader();
            this.xmlReader.setContentHandler(this);
            this.xmlReader.setFeature("http://xml.org/sax/features/validation", setValidation);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.xmlReader.setFeature("http://xml.org/sax/features/namespaces", setNameSpaces);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.xmlReader.setFeature("http://apache.org/xml/features/validation/schema", setSchemaSupport);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void read(String filename) throws SAXException, FileNotFoundException, IOException {
        this.read(new FileReader(filename));
    }

    public void read(Reader reader) throws SAXException, FileNotFoundException, IOException {
        this.family = null;
        this.particle = null;
        this.group = null;
        this.xmlReader.parse(new InputSource(reader));
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startElement(String namespaceURI, String tag, String qName, Attributes attr) throws SAXException {
        if (tag.equals("ParticleType")) {
            String name = attr.getValue("name");
            this.particle = this.yappi.getParticle(name);
            if (this.particle == null) {
                this.particle = new ParticleType(name);
            }
            if (attr.getValue("texName") != null) {
                this.particle.texName = attr.getValue("texName");
            }
            if (attr.getValue("antiName") != null) {
                this.particle.antiName = attr.getValue("antiName");
            }
            if (attr.getValue("antiTexName") != null) {
                this.particle.antiTexName = attr.getValue("antiTexName");
            }
            try {
                PDGID pdgid = new PDGID(Integer.parseInt(attr.getValue("PDGID")));
                if (pdgid != null) {
                    this.particle.pdgid = pdgid;
                }
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            this.yappi.addParticle(this.particle);
            if (this.family != null) {
                this.family.addParticle(this.particle);
            }
        } else if (tag.equals("Data")) {
            String name = attr.getValue("name");
            Data data = this.particle.getData(name);
            if (data == null) {
                data = new Data(name);
                this.particle.addData(data);
            }
            if (attr.getValue("texName") != null) {
                data.texName = attr.getValue("texName");
            }
            if (attr.getValue("value") != null) {
                data.value = attr.getValue("value");
            }
            if (attr.getValue("unit") != null) {
                data.unit = attr.getValue("unit");
            }
            if (attr.getValue("posError") != null) {
                data.posError = attr.getValue("posError");
            }
            if (attr.getValue("negError") != null) {
                data.negError = attr.getValue("negError");
            }
            if (attr.getValue("confidenceLevel") != null) {
                data.confidenceLevel = Double.parseDouble(attr.getValue("confidenceLevel"));
            }
            if (attr.getValue("scaleFactor") != null) {
                data.scaleFactor = Double.parseDouble(attr.getValue("scaleFactor"));
            }
        } else if (!tag.equals("PPML")) {
            if (tag.equals("Decay")) {
                String name = attr.getValue("name");
                String fraction = attr.getValue("fraction");
                DecayChannel decay = this.particle.getDecayChannel(name);
                if (decay == null) {
                    decay = new DecayChannel(name, fraction);
                    this.particle.addDecayChannel(decay);
                } else {
                    decay.fraction = fraction;
                    this.particle.addDecayChannel(decay);
                }
                if (this.group != null) {
                    decay.group = this.group;
                }
                if (attr.getValue("texName") != null) {
                    decay.texName = attr.getValue("texName");
                }
                if (attr.getValue("posError") != null) {
                    decay.posError = attr.getValue("posError");
                }
                if (attr.getValue("negError") != null) {
                    decay.negError = attr.getValue("negError");
                }
                if (attr.getValue("confidenceLevel") != null) {
                    decay.confidenceLevel = Double.parseDouble(attr.getValue("confidenceLevel"));
                }
                if (attr.getValue("scaleFactor") != null) {
                    decay.scaleFactor = Double.parseDouble(attr.getValue("scaleFactor"));
                }
                if (attr.getValue("P") != null) {
                    decay.P = attr.getValue("P");
                }
                if (attr.getValue("PUnit") != null) {
                    decay.PUnit = attr.getValue("PUnit");
                }
            } else if (tag.equals("DecayGroup")) {
                String groupName = attr.getValue("name");
                this.group = this.particle.getDecayGroup(groupName);
                if (this.group == null) {
                    this.group = new DecayGroup(groupName);
                    this.particle.addDecayGroup(this.group);
                }
            } else if (!(tag.equals("ParticleRef") || tag.equals("Source") || tag.equals("Author") || tag.equals("Name") || tag.equals("Link") || tag.equals("Date") || tag.equals("Type") || tag.equals("Reliability"))) {
                if (tag.equals("Family")) {
                    String name = attr.getValue("name");
                    this.family = this.yappi.getFamily(name);
                    if (this.family == null) {
                        this.family = new Family(name);
                        this.yappi.addFamily(this.family);
                    }
                    if (attr.getValue("texName") != null) {
                        this.family.texName = attr.getValue("texName");
                    }
                } else {
                    System.err.println("Unknown tag: " + tag);
                }
            }
        }
    }

    public void endElement(String namespaceURI, String tag, String qName) throws SAXException {
        if (tag.equals("ParticleType")) {
            this.particle = null;
        } else if (!(tag.equals("Data") || tag.equals("PPML") || tag.equals("AdditionalData"))) {
            if (tag.equals("DecayGroup")) {
                this.group = null;
            } else if (!(tag.equals("Decay") || tag.equals("ParticleRef") || tag.equals("Source") || tag.equals("Author") || tag.equals("Name") || tag.equals("Link") || tag.equals("Date") || tag.equals("Type") || tag.equals("Reliability"))) {
                if (tag.equals("Family")) {
                    this.family = null;
                } else {
                    System.err.println("Unknown end tag: " + tag);
                }
            }
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    private void println(String text) {
        if (this.debug) {
            System.out.println(text);
        }
    }

    private void print(String text) {
        if (this.debug) {
            System.out.print(text);
        }
    }
}

