/*
 * Decompiled with CFR 0.152.
 */
package hep.physics.yappi;

public class PDGID {
    private int id;
    protected boolean particle = true;
    protected String family = "undefined";
    protected boolean likely = false;
    protected boolean excited = false;
    protected boolean technicolor = false;
    protected boolean susy = false;
    protected int susyState = 0;
    protected double I = Double.NaN;
    protected double J = Double.NaN;
    protected int P = 0;
    protected int C = 0;
    protected int G = 0;
    protected int n = 0;
    protected int nr = 0;
    protected int nL = 0;
    protected int nq1 = 0;
    protected int nq2 = 0;
    protected int nq3 = 0;
    protected int nJ = 0;

    public PDGID(int id) {
        this.id = id;
        this.decode(id);
    }

    public int getID() {
        return this.id;
    }

    public boolean isParticle() {
        return this.particle;
    }

    public boolean isExcited() {
        return this.excited;
    }

    public boolean isTechnicolor() {
        return this.technicolor;
    }

    public boolean isSusy() {
        return this.susy;
    }

    public int getSusyState() {
        return this.susyState;
    }

    public String getFamily() {
        return this.family;
    }

    public boolean isLikely() {
        return this.likely;
    }

    public int getN() {
        return this.n;
    }

    public int getNr() {
        return this.nr;
    }

    public int getNL() {
        return this.nL;
    }

    public int getNq1() {
        return this.nq1;
    }

    public int getNq2() {
        return this.nq2;
    }

    public int getNq3() {
        return this.nq3;
    }

    public int getNJ() {
        return this.nJ;
    }

    public double getI() {
        return this.I;
    }

    public double getJ() {
        return this.J;
    }

    public int getP() {
        return this.P;
    }

    public int getC() {
        return this.C;
    }

    protected void decode(int id) {
        this.particle = id > 0;
        id = Math.abs(id);
        this.n = id / 1000000;
        int r = id % 1000000;
        switch (this.n) {
            case 0: {
                break;
            }
            case 1: 
            case 2: {
                this.susy = true;
                this.susyState = this.n;
                break;
            }
            case 3: {
                this.technicolor = true;
                break;
            }
            case 4: {
                this.excited = true;
                break;
            }
            case 9: {
                this.likely = true;
                break;
            }
        }
        if (this.likely && id / 100000 % 10 == 9) {
            this.decodeUser(id);
        } else {
            this.decodeBase(r);
        }
    }

    protected void decodeUser(int r) {
    }

    protected void decodeBase(int id) {
        block33: {
            block37: {
                block36: {
                    block35: {
                        block34: {
                            block32: {
                                if (id >= 11) break block32;
                                this.family = "quarks";
                                switch (id) {
                                    case 1: {
                                        this.I = 0.5;
                                        this.J = 0.5;
                                        this.P = 1;
                                        break block33;
                                    }
                                    case 2: {
                                        this.I = 0.5;
                                        this.J = 0.5;
                                        this.P = 1;
                                        break block33;
                                    }
                                    case 3: {
                                        this.I = 0.0;
                                        this.J = 0.5;
                                        this.P = 1;
                                        break block33;
                                    }
                                    case 4: {
                                        this.I = 0.0;
                                        this.J = 0.5;
                                        this.P = 1;
                                        break block33;
                                    }
                                    case 5: {
                                        this.I = 0.0;
                                        this.J = 0.5;
                                        this.P = 1;
                                        break block33;
                                    }
                                    case 6: {
                                        this.I = 0.0;
                                        this.J = 0.5;
                                        this.P = 1;
                                        break block33;
                                    }
                                    case 7: 
                                    case 8: {
                                        break block33;
                                    }
                                    case 9: {
                                        this.I = 0.0;
                                        this.J = 1.0;
                                        this.P = -1;
                                        break block33;
                                    }
                                    default: {
                                        throw new IllegalArgumentException("Not a valid PDGID: " + id);
                                    }
                                }
                            }
                            if (id >= 21) break block34;
                            this.family = "leptons";
                            switch (id) {
                                case 11: 
                                case 12: 
                                case 13: 
                                case 14: 
                                case 15: 
                                case 16: {
                                    this.J = 0.5;
                                    break block33;
                                }
                                case 17: 
                                case 18: {
                                    break block33;
                                }
                                default: {
                                    throw new IllegalArgumentException("Not a valid PDGID: " + id);
                                }
                            }
                        }
                        if (id >= 31) break block35;
                        this.family = "bosons";
                        switch (id) {
                            case 21: {
                                this.I = 0.0;
                                this.J = 1.0;
                                this.P = -1;
                                break block33;
                            }
                            case 22: {
                                this.I = 0.0;
                                this.J = 1.0;
                                this.P = -1;
                                this.C = -1;
                                break block33;
                            }
                            case 23: {
                                this.J = 1.0;
                                break block33;
                            }
                            case 24: {
                                this.J = 1.0;
                                break block33;
                            }
                            case 25: {
                                break block33;
                            }
                            default: {
                                throw new IllegalArgumentException("Not a valid PDGID: " + id);
                            }
                        }
                    }
                    if (id >= 39) break block36;
                    this.family = "bosons";
                    switch (id) {
                        case 32: 
                        case 33: 
                        case 34: 
                        case 35: 
                        case 36: 
                        case 37: {
                            break block33;
                        }
                        default: {
                            throw new IllegalArgumentException("Not a valid PDGID: " + id);
                        }
                    }
                }
                if (id >= 81) break block37;
                this.family = "exotic";
                switch (id) {
                    case 39: 
                    case 41: 
                    case 42: {
                        break block33;
                    }
                    default: {
                        throw new IllegalArgumentException("Not a valid PDGID: " + id);
                    }
                }
            }
            if (id < 101) {
                this.family = "reserved";
            } else {
                switch (id) {
                    case 110: 
                    case 990: 
                    case 9990: {
                        this.family = "special";
                        this.decodeFlavors(id);
                        break;
                    }
                    default: {
                        this.family = "composites";
                        this.decodeComposites(id);
                    }
                }
            }
        }
    }

    protected void decodeFlavors(int id) {
        this.nq3 = id / 10 % 10;
        this.nq2 = id / 100 % 10;
        this.nq1 = id / 1000 % 10;
    }

    protected void decodeComposites(int id) {
        if (id == 130) {
            this.family = "mesons";
            this.I = 0.5;
            this.J = 0.0;
            this.P = -1;
            this.nq1 = 0;
            this.nq2 = 3;
            this.nq3 = 1;
            this.nJ = 1;
            return;
        }
        if (id == 310) {
            this.family = "mesons";
            this.I = 0.5;
            this.J = 0.0;
            this.P = -1;
            this.nq1 = 0;
            this.nq2 = 3;
            this.nq3 = 1;
            this.nJ = 1;
            return;
        }
        this.nJ = id % 10;
        this.J = (double)this.nJ - 0.5;
        this.decodeFlavors(id);
        if (this.nq3 == 0) {
            this.family = "diquarks";
        } else if (this.nq1 == 0) {
            this.family = "mesons";
            this.decodeMesons(id);
        } else {
            this.family = "baryons";
            this.decodeBaryons(id);
        }
        this.nr = id / 100000 % 10;
    }

    /*
     * WARNING - void declaration
     */
    protected void decodeMesons(int id) {
        void var3_3;
        void var2_2;
        block11: {
            boolean S;
            int L;
            block10: {
                this.nL = id / 1000 % 10;
                if (!(this.J > 0.0)) break block10;
                switch (this.nL) {
                    case 0: {
                        L = (int)this.J - 1;
                        S = true;
                        break block11;
                    }
                    case 1: {
                        L = (int)this.J;
                        S = false;
                        break block11;
                    }
                    case 2: {
                        L = (int)this.J;
                        S = true;
                        break block11;
                    }
                    case 3: {
                        L = (int)this.J + 1;
                        S = true;
                        break block11;
                    }
                    default: {
                        throw new RuntimeException("nL contains a wrong number: " + this.nL);
                    }
                }
            }
            switch (this.nL) {
                case 0: {
                    L = 0;
                    S = false;
                    break;
                }
                case 1: {
                    L = 1;
                    S = true;
                    break;
                }
                default: {
                    throw new RuntimeException("nL contains a wrong number: " + this.nL);
                }
            }
        }
        this.P = (var2_2 + true) % 2 == false ? 1 : -1;
        this.C = (var2_2 + var3_3) % 2 == false ? 1 : -1;
    }

    protected void decodeBaryons(int id) {
    }

    public String toString() {
        return "[PDGID:" + this.id + "] Family=" + this.family + "; " + (this.particle ? "particle" : "anti-particle") + "; \n" + "   I=" + this.I + "; J=" + this.J + "; P=" + (this.P == 1 ? "+" : "-") + "; C=" + (this.C == 1 ? "+" : "-") + "; \n" + "   q1=" + this.nq1 + "; q2=" + this.nq2 + "; q3=" + this.nq3 + "; \n" + "   n=" + this.n + "; nr=" + this.nr + "; nL=" + this.nL + "; nJ=" + this.nJ + "; \n" + "   " + (this.excited ? "excited, " : "") + (this.technicolor ? "techicolor, " : "") + (this.likely ? "likely, " : "") + (this.susy ? "susy(" + this.susyState + "), " : "") + "; \n" + "   \n";
    }

    public static void main(String[] args) {
        System.out.println(new PDGID(4));
        System.out.println(new PDGID(14));
        System.out.println(new PDGID(4000002));
        System.out.println(new PDGID(35));
        System.out.println(new PDGID(4301));
        System.out.println(new PDGID(3000113));
        System.out.println(new PDGID(1000015));
        System.out.println(new PDGID(2000011));
        System.out.println(new PDGID(41));
        System.out.println(new PDGID(110));
        System.out.println(new PDGID(-990));
        System.out.println(new PDGID(9990));
        System.out.println(new PDGID(211));
        System.out.println(new PDGID(100213));
        System.out.println(new PDGID(-9020215));
        System.out.println(new PDGID(130));
        System.out.println(new PDGID(310));
        System.out.println(new PDGID(9010325));
        System.out.println(new PDGID(412));
        System.out.println(new PDGID(20423));
        System.out.println(new PDGID(-20533));
        System.out.println(new PDGID(9000445));
        System.out.println(new PDGID(110553));
        System.out.println(new PDGID(2212));
        System.out.println(new PDGID(1114));
        System.out.println(new PDGID(3324));
        System.out.println(new PDGID(4322));
        System.out.println(new PDGID(5414));
    }
}

