/*
 * Decompiled with CFR 0.152.
 */
package hep.physics.yappi;

import hep.physics.yappi.DecayGroup;
import hep.physics.yappi.DecayProduct;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DecayChannel
implements Comparable {
    private String name;
    DecayGroup group;
    String texName;
    String fraction;
    String posError;
    String negError;
    double confidenceLevel;
    double scaleFactor;
    String P;
    String PUnit;
    private List decayParticles;

    public DecayChannel(String name, String fraction) {
        this.name = name;
        this.fraction = fraction;
        this.decayParticles = new ArrayList();
    }

    public String getName() {
        return this.name;
    }

    public String getTexName() {
        return this.texName;
    }

    public DecayGroup getDecayGroup() {
        return this.group;
    }

    public double getFraction() {
        try {
            return Double.parseDouble(this.fraction);
        }
        catch (Exception nfe) {
            return Double.NaN;
        }
    }

    public String getFractionAsString() {
        return this.fraction;
    }

    public double getPosError() {
        try {
            return Double.parseDouble(this.posError);
        }
        catch (Exception nfe) {
            return Double.NaN;
        }
    }

    public String getPosErrorAsString() {
        return this.posError;
    }

    public double getNegError() {
        try {
            return Double.parseDouble(this.negError);
        }
        catch (Exception nfe) {
            return Double.NaN;
        }
    }

    public String getNegErrorAsString() {
        return this.negError;
    }

    public double getConfidenceLevel() {
        return this.confidenceLevel;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public String getP() {
        return this.P;
    }

    public String getPUnit() {
        return this.PUnit;
    }

    public void addDecayParticle(DecayProduct decayProduct) {
        this.decayParticles.add(decayProduct);
    }

    public Iterator getDecayParticles() {
        return this.decayParticles.iterator();
    }

    public int compareTo(Object obj) {
        DecayChannel channel = (DecayChannel)obj;
        double f1 = this.getFraction();
        double f2 = channel.getFraction();
        if (Double.isNaN(f1)) {
            if (Double.isNaN(f2)) {
                String s1 = this.getFractionAsString();
                String s2 = channel.getFractionAsString();
                if (s1 == null && s2 == null) {
                    return 0;
                }
                if (s1 == null) {
                    return -1;
                }
                if (s2 == null) {
                    return 1;
                }
                if (s1.startsWith("<")) {
                    if (s2.startsWith("<")) {
                        Double d = new Double(s1.substring(1));
                        return -d.compareTo(new Double(s2.substring(1)));
                    }
                    return 1;
                }
                if (s2.startsWith("<")) {
                    return -1;
                }
                return -s1.compareTo(s2);
            }
            return 1;
        }
        if (Double.isNaN(f2)) {
            return -1;
        }
        return f1 < f2 ? 1 : (f1 == f2 ? 0 : -1);
    }
}

