/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.reps;

import hep.io.root.core.AbstractRootObject;
import hep.io.root.core.RootInput;
import hep.io.root.core.RootRandomAccessFile;
import hep.io.root.interfaces.TDatime;
import hep.io.root.interfaces.TDirectory;
import hep.io.root.interfaces.TKey;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public abstract class TDirectoryRep
extends AbstractRootObject
implements TDirectory {
    private Date fDatimeC;
    private Date fDatimeM;
    private Map hash;
    private Map hashT;
    private RootRandomAccessFile raf;
    private String fName;
    private String fTitle;
    private TKey fHeader;
    private TKey[] keys;
    private int fNbytes;
    private int fNbytesKeys;
    private int fNbytesName;
    private int fNkeys;
    private int fSeekDir;
    private int fSeekKeys;
    private int fSeekParent;

    public int getBits() {
        return 0;
    }

    public Date getDatimeC() {
        return this.fDatimeC;
    }

    public Date getDatimeM() {
        return this.fDatimeM;
    }

    public TKey getKey(int index) {
        return this.keys[index];
    }

    public TKey getKey(String name) {
        TKey key = (TKey)this.hash.get(name);
        if (key != null) {
            return key;
        }
        throw new RuntimeException("Key " + name + " not found in " + this.fHeader.getName());
    }

    public TKey getKey(String name, int cycle) {
        TKey key = (TKey)this.hash.get(name + ";" + cycle);
        if (key != null) {
            return key;
        }
        throw new RuntimeException("Key " + name + ";" + cycle + " not found in " + this.fHeader.getName());
    }

    public TKey getKeyForTitle(String title) {
        TKey key = (TKey)this.hashT.get(title);
        if (key != null) {
            return key;
        }
        throw new RuntimeException("Key titled " + title + " not found in " + this.fHeader.getTitle());
    }

    public String getName() {
        return this.fName;
    }

    public int getNbytesKeys() {
        return this.fNbytesKeys;
    }

    public int getNbytesName() {
        return this.fNbytesName;
    }

    public int getSeekDir() {
        return this.fSeekDir;
    }

    public int getSeekKeys() {
        return this.fSeekKeys;
    }

    public int getSeekParent() {
        return this.fSeekParent;
    }

    public String getTitle() {
        return this.fTitle;
    }

    public int getUniqueID() {
        return 0;
    }

    public int nKeys() {
        return this.keys.length;
    }

    public void readMembers(RootInput in) throws IOException {
        int v = in.readVersion();
        this.fDatimeC = ((TDatime)in.readObject("TDatime")).getDate();
        this.fDatimeM = ((TDatime)in.readObject("TDatime")).getDate();
        this.fNbytesKeys = in.readInt();
        this.fNbytesName = in.readInt();
        this.fSeekDir = in.readInt();
        this.fSeekParent = in.readInt();
        this.fSeekKeys = in.readInt();
        in.clearMap();
        in.setPosition(this.fSeekKeys);
        this.hash = new HashMap();
        this.hashT = new HashMap();
        this.fHeader = (TKey)in.readObject("TKey");
        this.fNkeys = in.readInt();
        this.keys = new TKey[this.fNkeys];
        for (int i = 0; i < this.fNkeys; ++i) {
            this.keys[i] = (TKey)in.readObject("TKey");
            this.hash.put(this.keys[i].getName() + ";" + this.keys[i].getCycle(), this.keys[i]);
            TKey prevKey = (TKey)this.hash.get(this.keys[i].getName());
            if (prevKey != null && prevKey.getCycle() >= this.keys[i].getCycle()) continue;
            this.hash.put(this.keys[i].getName(), this.keys[i]);
            this.hashT.put(this.keys[i].getTitle(), this.keys[i]);
        }
    }
}

