/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.core;

import hep.io.root.RootClass;
import hep.io.root.RootClassNotFound;
import hep.io.root.RootFileReader;
import hep.io.root.core.BasicRootClass;
import hep.io.root.core.GenericRootClass;
import hep.io.root.core.RootClassFactory;
import hep.io.root.core.RootClassLoader;
import hep.io.root.core.StreamerInfo;
import hep.io.root.core.StreamerInfoString;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class DefaultClassFactory
implements RootClassFactory {
    private static final Class[] argc = new Class[]{String.class, StreamerInfo.class};
    private Hashtable classMap = new Hashtable();
    private RootClassLoader loader;
    private RootFileReader rfr;
    private String[] packageList;
    static /* synthetic */ Class class$hep$io$root$core$IntrinsicRootClass;

    public DefaultClassFactory(RootFileReader rfr) {
        this.loader = new RootClassLoader(rfr);
        try {
            Properties typedef = new Properties();
            InputStream in = this.getClass().getResourceAsStream("Typedef.properties");
            typedef.load(in);
            in.close();
            Properties streamerInfo = new Properties();
            in = this.getClass().getResourceAsStream("StreamerInfo.properties");
            streamerInfo.load(in);
            in.close();
            this.init(typedef, streamerInfo);
        }
        catch (IOException x) {
            throw new RuntimeException("Unable to load default properties");
        }
    }

    public RootClassLoader getLoader() {
        return this.loader;
    }

    public BasicRootClass create(String name) throws RootClassNotFound {
        BasicRootClass result = (BasicRootClass)this.classMap.get(name);
        if (result != null) {
            return result;
        }
        throw new RootClassNotFound(name);
    }

    static RootClass findClass(String name, StreamerInfo info) {
        try {
            Class<?> c = Class.forName("hep.io.root.classes." + name);
            Constructor<?> cc = c.getConstructor(argc);
            Object[] args = new Object[]{name, info};
            return (RootClass)cc.newInstance(args);
        }
        catch (Throwable x) {
            return new GenericRootClass(name, info);
        }
    }

    private void init(Properties typedef, Properties streamerInfo) {
        Object value;
        Object key;
        Enumeration<Object> e;
        try {
            e = typedef.keys();
            while (e.hasMoreElements()) {
                Class<?> intrinsic;
                key = e.nextElement();
                value = typedef.get(key);
                if (!(class$hep$io$root$core$IntrinsicRootClass == null ? DefaultClassFactory.class$("hep.io.root.core.IntrinsicRootClass") : class$hep$io$root$core$IntrinsicRootClass).isAssignableFrom(intrinsic = Class.forName("hep.io.root.core." + value))) {
                    throw new RuntimeException("Typedef class is not an intrinsic: " + value);
                }
                this.classMap.put(key, intrinsic.newInstance());
            }
        }
        catch (Exception x) {
            throw new RuntimeException("Error interpreting typedef table");
        }
        try {
            e = streamerInfo.keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                value = streamerInfo.get(key);
                StreamerInfoString info = new StreamerInfoString((String)value);
                this.classMap.put(key, DefaultClassFactory.findClass((String)key, info));
            }
        }
        catch (Exception x) {
            throw new RuntimeException("Error interpreting typedef table");
        }
        try {
            e = this.classMap.elements();
            while (e.hasMoreElements()) {
                BasicRootClass info = (BasicRootClass)e.nextElement();
                info.resolve(this);
            }
        }
        catch (RootClassNotFound x) {
            throw new RuntimeException("Could not resolve class " + x.getClassName());
        }
    }
}

