/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root;

import hep.io.root.RootClass;
import hep.io.root.RootClassNotFound;
import hep.io.root.core.DefaultClassFactory;
import hep.io.root.core.FastInputStream;
import hep.io.root.core.FileClassFactory;
import hep.io.root.core.RootClassFactory;
import hep.io.root.core.RootInput;
import hep.io.root.core.RootRandomAccessFile;
import hep.io.root.interfaces.TDatime;
import hep.io.root.interfaces.TDirectory;
import hep.io.root.interfaces.TFile;
import hep.io.root.interfaces.TKey;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;

public class RootFileReader
implements TFile {
    private static boolean welcome = false;
    private static boolean debug = System.getProperty("debugRoot") != null;
    private ClassLoader classLoader;
    private Date fDatimeC;
    private Date fDatimeM;
    private RootClass fileClass;
    private RootClassFactory factory;
    private RootInput in;
    private RootRandomAccessFile raf;
    private String name;
    private String title;
    private TDirectory dir;
    private TKey streamerInfo;
    private int fNbytesKeys;
    private int fNbytesName;
    private int fSeekDir;
    private int fSeekKeys;
    private int fSeekParent;
    private int fVersion;

    public RootFileReader(String file) throws IOException {
        this(new File(file));
    }

    public RootFileReader(File file) throws IOException {
        try {
            if (!welcome) {
                RootFileReader.welcome();
            }
            this.factory = new DefaultClassFactory(this);
            this.raf = new RootRandomAccessFile(file, this);
            this.in = System.getProperty("useNIO") != null ? new FastInputStream(this, this.raf) : this.raf;
            this.fileClass = this.factory.create("TFile");
            this.fVersion = this.in.readInt();
            if (this.fVersion < 30006) {
                throw new IOException("hep.io.root package cannot read files created by Root before release 3.00/6 (" + this.fVersion + ")");
            }
            if (debug) {
                System.out.println("version=" + this.fVersion);
            }
            int fBEGIN = this.in.readInt();
            int fEND = this.in.readInt();
            int fSeekFree = this.in.readInt();
            int fNbytesFree = this.in.readInt();
            int nfree = this.in.readInt();
            this.fNbytesName = this.in.readInt();
            byte fUnits = this.in.readByte();
            int fCompress = this.in.readInt();
            int fSeekInfo = this.in.readInt();
            int fNBytesInfo = this.in.readInt();
            this.in.setPosition(fBEGIN);
            int Nbytes = this.in.readInt();
            short Version = this.in.readShort();
            int ObjLen = this.in.readInt();
            this.fDatimeC = this.fDatimeM = ((TDatime)this.in.readObject("TDatime")).getDate();
            short KeyLen = this.in.readShort();
            short Cycle = this.in.readShort();
            int SeekKey = this.in.readInt();
            int SeekPdir = this.in.readInt();
            String className = this.in.readObject("TString").toString();
            this.name = this.in.readObject("TString").toString();
            this.title = this.in.readObject("TString").toString();
            this.in.setPosition(fBEGIN + this.fNbytesName);
            this.dir = (TDirectory)this.in.readObject("TDirectory");
            if (fSeekInfo != 0) {
                this.in.setPosition(fSeekInfo);
                this.streamerInfo = (TKey)this.in.readObject("TKey");
                this.factory = new FileClassFactory(this.streamerInfo, this.factory, this);
            }
        }
        catch (RootClassNotFound x) {
            x.printStackTrace();
            throw new IOException("Root Class Not Found: " + x.getClassName());
        }
    }

    public int getBits() {
        return 0;
    }

    public RootClassFactory getClassFactory() {
        return this.factory;
    }

    public void setClassLoader(ClassLoader loader) {
        this.classLoader = loader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Date getDatimeC() {
        return this.fDatimeC;
    }

    public Date getDatimeM() {
        return this.fDatimeM;
    }

    public RootClassFactory getFactory() {
        return this.factory;
    }

    public TKey getKey(int index) {
        return this.dir.getKey(index);
    }

    public TKey getKey(String name) {
        return this.dir.getKey(name);
    }

    public TKey getKey(String name, int cycle) {
        return this.dir.getKey(name, cycle);
    }

    public TKey getKeyForTitle(String name) {
        return this.dir.getKeyForTitle(name);
    }

    public String getName() {
        return this.name;
    }

    public int getNbytesKeys() {
        return this.fNbytesKeys;
    }

    public int getNbytesName() {
        return this.fNbytesName;
    }

    public RootClass getRootClass() {
        return this.fileClass;
    }

    public int getSeekDir() {
        return this.fSeekDir;
    }

    public int getSeekKeys() {
        return this.fSeekKeys;
    }

    public int getSeekParent() {
        return this.fSeekParent;
    }

    public String getTitle() {
        return this.title;
    }

    public int getUniqueID() {
        return 0;
    }

    public int getVersion() {
        return this.fVersion;
    }

    public void close() throws IOException {
        if (this.in instanceof FastInputStream) {
            ((FastInputStream)this.in).dump();
        }
        this.raf.close();
    }

    public Object get(String name) throws IOException, RootClassNotFound {
        TKey key = this.getKey(name);
        return key.getObject();
    }

    public int nKeys() {
        return this.dir.nKeys();
    }

    public List streamerInfo() throws IOException {
        try {
            return (List)((Object)this.streamerInfo.getObject());
        }
        catch (RootClassNotFound x) {
            throw new IOException("Root Class Not Found during IO: " + x);
        }
    }

    public TKey streamerInfoKey() {
        return this.streamerInfo;
    }

    private static void welcome() {
        System.out.println("Root IO for Java, part of the FreeHEP library: http://java.freehep.org");
        System.out.println("Please report all bugs/problems to tonyj@slac.stanford.edu");
        System.out.println("Version $Id: RootFileReader.java,v 1.16 2003/05/23 20:59:14 duns Exp $");
        welcome = true;
    }
}

