/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote;

import hep.aida.IManagedObject;
import hep.aida.dev.IDevMutableStore;
import hep.aida.dev.IDevTree;
import hep.aida.ref.remote.RemoteManagedObject;
import hep.aida.ref.remote.RemoteUpdateEvent;
import hep.aida.ref.remote.interfaces.AidaTreeClient;
import hep.aida.ref.remote.interfaces.AidaUpdatable;
import hep.aida.ref.remote.interfaces.AidaUpdateEvent;
import java.io.IOException;
import java.util.Map;

public abstract class RemoteMutableStore
implements AidaUpdatable,
IDevMutableStore {
    protected IDevTree tree;
    protected AidaTreeClient client;
    protected boolean recursive;
    protected RemoteUpdateEvent event;
    protected boolean hurry;

    public RemoteMutableStore() {
        this(null, null);
    }

    public RemoteMutableStore(IDevTree tree) {
        this(tree, null);
    }

    private RemoteMutableStore(IDevTree tree, AidaTreeClient client) {
        this.tree = tree;
        this.client = client;
        this.hurry = false;
        this.event = new RemoteUpdateEvent();
        this.recursive = false;
    }

    protected abstract AidaTreeClient createClient(Map var1);

    public abstract void updateData(String var1, String var2) throws IllegalArgumentException;

    public abstract IManagedObject createObject(String var1, String var2) throws IllegalArgumentException;

    public void close() throws IOException {
        this.client.disconnect();
        this.client = null;
        this.tree = null;
        this.event = null;
    }

    public void commit(IDevTree tree, Map options) throws IOException {
        throw new UnsupportedOperationException("Can not commit changes to the Read-Only Store");
    }

    public boolean isReadOnly() {
        return true;
    }

    public void read(IDevTree tree, String path) throws IllegalArgumentException, IOException {
        if (!this.client.isConnected()) {
            throw new IOException("Can not read from the Store: client is not connected!");
        }
        String[] names = this.client.listObjectNames(path);
        String[] types = this.client.listObjectTypes(path);
        if (names != null && types != null) {
            for (int i = 0; i < names.length; ++i) {
                this.event.init();
                this.event.setId(1);
                this.event.setNodeType(types[i]);
                this.event.setPath(names[i]);
                this.stateChanged(this.event);
            }
            tree.hasBeenFilled(path);
        }
    }

    public void read(IDevTree tree, Map options, boolean readOnly, boolean createNew) throws IOException {
        if (this.tree == null) {
            this.tree = tree;
        }
        if (this.client == null) {
            this.client = this.createClient(options);
        }
        if (!this.client.isConnected()) {
            this.client.connect();
        }
        this.recursive = options.containsKey("recursive");
        String path = "/";
        String[] names = this.client.listObjectNames(path);
        String[] types = this.client.listObjectTypes(path);
        if (names != null && types != null) {
            for (int i = 0; i < names.length; ++i) {
                this.event.init();
                this.event.setId(1);
                this.event.setNodeType(types[i]);
                this.event.setPath(names[i]);
                this.stateChanged(this.event);
            }
            tree.hasBeenFilled(path);
        }
    }

    public void stateChanged(AidaUpdateEvent event) {
        int id = event.id();
        String path = event.path();
        String type = event.nodeType();
        if (id == 1) {
            if (type.equalsIgnoreCase("dir")) {
                this.tree.mkdirs(path);
            } else {
                int index = path.lastIndexOf("/");
                String name = path.substring(index + 1);
                String objDir = path.substring(0, index + 1);
                IManagedObject h = null;
                this.tree.mkdirs(objDir);
                h = this.createObject(name, type);
                this.tree.add(objDir, h);
                if (h instanceof RemoteManagedObject) {
                    ((RemoteManagedObject)h).setTreeFolder(objDir);
                    ((RemoteManagedObject)h).setDataValid(false);
                } else {
                    this.updateData(path, type);
                }
            }
        } else if (id == 2) {
            if (type.equalsIgnoreCase("dir")) {
                try {
                    String[] list = this.tree.listObjectNames(path);
                    this.tree.rmdir(path);
                }
                catch (IllegalArgumentException ex) {}
            } else {
                try {
                    IManagedObject obj = this.tree.find(path);
                    this.tree.rm(path);
                }
                catch (IllegalArgumentException ex) {}
            }
        } else if (id == 0) {
            IManagedObject h = this.tree.find(path);
            if (h instanceof RemoteManagedObject) {
                ((RemoteManagedObject)h).setDataValid(false);
            } else {
                this.updateData(path, type);
            }
        } else {
            System.out.println("RemoteMutableStore.stateChanged Wrong ID=" + event.id() + ", path=" + path + ",  type=" + type);
        }
    }

    public static void main(String[] args) {
    }
}

