/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter.adapter;

import hep.aida.IProfile2D;
import jas.hist.ExtendedStatistics;

class AIDAProfileStatistics2D
implements ExtendedStatistics {
    private IProfile2D profile;
    private String[] statNames = new String[]{"Entries", "OutOfRange", "XMean", "XRms", "YMean", "YRms"};
    private String[] gristoNames = new String[]{"XMean", "XRms", "YMean", "YRms"};

    AIDAProfileStatistics2D(IProfile2D profile) {
        this.profile = profile;
    }

    public String[] getStatisticNames() {
        return this.statNames;
    }

    public double getStatistic(String name) {
        if (name.equals("XMean")) {
            return this.profile.meanX();
        }
        if (name.equals("XRms")) {
            return this.profile.rmsX();
        }
        if (name.equals("YMean")) {
            return this.profile.meanY();
        }
        if (name.equals("YRms")) {
            return this.profile.rmsY();
        }
        return 0.0;
    }

    public Object getExtendedStatistic(String name) {
        if (name.equals("Entries")) {
            return new Integer(this.profile.entries());
        }
        if (name.equals("OutOfRange")) {
            return new Integer(this.profile.extraEntries());
        }
        return null;
    }
}

