/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter.adapter;

import hep.aida.IFunction;
import hep.aida.IManagedObject;
import jas.hist.Basic1DFunction;
import jas.hist.DataSource;
import jas.hist.ExtendedStatistics;
import jas.hist.FunctionValueUndefined;
import jas.hist.InvalidFunctionParameter;
import jas.util.DoubleWithError;

class AIDAFunctionAdapter
extends Basic1DFunction
implements ExtendedStatistics {
    private IFunction function;
    private double[] d = new double[1];
    private static final String chi2 = "\u03c7\u00b2";

    static DataSource create(IFunction function) {
        if (function.dimension() == 1) {
            return new AIDAFunctionAdapter(function);
        }
        throw new IllegalArgumentException("Only 1-D functions supported");
    }

    private AIDAFunctionAdapter(IFunction function) {
        this.function = function;
    }

    public void setParameter(int index, double value) throws InvalidFunctionParameter {
        this.function.setParameter(this.function.parameterNames()[index], value);
    }

    public String[] getParameterNames() {
        return this.function.parameterNames();
    }

    public double[] getParameterValues() {
        return this.function.parameters();
    }

    public double valueAt(double x) throws FunctionValueUndefined {
        this.d[0] = x;
        double result = this.function.value(this.d);
        if (Double.isNaN(result)) {
            throw new FunctionValueUndefined();
        }
        return result;
    }

    public String getTitle() {
        if (this.function instanceof IManagedObject) {
            return ((IManagedObject)this.function).name();
        }
        return "function";
    }

    private boolean hasFit() {
        return false;
    }

    public String[] getStatisticNames() {
        String[] statnames = super.getStatisticNames();
        if (this.hasFit()) {
            String[] newStatNames = new String[statnames.length + 1];
            System.arraycopy(statnames, 0, newStatNames, 0, statnames.length);
            newStatNames[statnames.length] = chi2;
            statnames = newStatNames;
        }
        return statnames;
    }

    public double getStatistic(String name) {
        if (name.equals(chi2)) {
            return 0.0;
        }
        return super.getStatistic(name);
    }

    public Object getExtendedStatistic(String name) {
        if (this.hasFit()) {
            for (int i = 0; i < this.getParameterNames().length; ++i) {
                if (!name.equals(this.getParameterNames()[i])) continue;
                return new DoubleWithError(this.function.parameters()[i], 0.0);
            }
        }
        return null;
    }
}

