/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter;

import hep.aida.ITextStyle;
import hep.aida.ref.plotter.BrushStyle;

public class TextStyle
extends BrushStyle
implements ITextStyle {
    private static String textFontPar = "font";
    private static String textFontSizePar = "fontSize";
    private static String textBoldPar = "bold";
    private static String textItalicPar = "italic";
    private static String textUnderlinedPar = "underlined";

    protected void initializeBrushStyle() {
        this.addParameter(textFontPar, "SansSerif");
        this.addParameter(textFontSizePar, "12");
        this.addParameter(textBoldPar, "false");
        this.addParameter(textItalicPar, "false");
        this.addParameter(textUnderlinedPar, "false");
    }

    public String[] availableFonts() {
        return this.availableParameterOptions(textFontPar);
    }

    public String font() {
        return this.parameterValue(textFontPar);
    }

    public double fontSize() {
        String fontSizeStr = this.parameterValue(textFontSizePar);
        if (fontSizeStr == null) {
            return -1.0;
        }
        return Double.parseDouble(fontSizeStr);
    }

    public boolean isBold() {
        String isBoldStr = this.parameterValue(textBoldPar);
        if (isBoldStr == null) {
            isBoldStr = this.parameterDefaultValue(textBoldPar);
        }
        return Boolean.valueOf(isBoldStr);
    }

    public boolean isItalic() {
        String isItalicStr = this.parameterValue(textItalicPar);
        if (isItalicStr == null) {
            isItalicStr = this.parameterDefaultValue(textItalicPar);
        }
        return Boolean.valueOf(isItalicStr);
    }

    public boolean isUnderlined() {
        String isUnderlinedStr = this.parameterValue(textUnderlinedPar);
        if (isUnderlinedStr == null) {
            isUnderlinedStr = this.parameterDefaultValue(textUnderlinedPar);
        }
        return Boolean.valueOf(isUnderlinedStr);
    }

    public boolean setBold() {
        return this.setParameter(textBoldPar);
    }

    public boolean setBold(boolean isBold) {
        return this.setParameter(textBoldPar, String.valueOf(isBold));
    }

    public boolean setFont(String font) {
        return this.setParameter(textFontPar, font);
    }

    public boolean setFontSize(double fontSize) {
        return this.setParameter(textFontSizePar, String.valueOf(fontSize));
    }

    public boolean setItalic() {
        return this.setParameter(textItalicPar);
    }

    public boolean setItalic(boolean isItalic) {
        return this.setParameter(textItalicPar, String.valueOf(isItalic));
    }

    public boolean setUnderlined() {
        return this.setParameter(textUnderlinedPar);
    }

    public boolean setUnderlined(boolean isUnderlined) {
        return this.setParameter(textUnderlinedPar, String.valueOf(isUnderlined));
    }
}

