/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter;

import hep.aida.IAxisStyle;
import hep.aida.IBaseHistogram;
import hep.aida.ICloud;
import hep.aida.IDataPointSet;
import hep.aida.IDataStyle;
import hep.aida.IFillStyle;
import hep.aida.IFunction;
import hep.aida.IHistogram;
import hep.aida.IInfo;
import hep.aida.ILineStyle;
import hep.aida.IMarkerStyle;
import hep.aida.IPlotterLayout;
import hep.aida.IPlotterRegion;
import hep.aida.IPlotterStyle;
import hep.aida.IProfile;
import hep.aida.ref.plotter.BaseStyle;
import hep.aida.ref.plotter.Info;
import hep.aida.ref.plotter.PlotterFontUtil;
import hep.aida.ref.plotter.PlotterLayout;
import hep.aida.ref.plotter.PlotterStyle;
import hep.aida.ref.plotter.adapter.AIDAAdapter;
import jas.hist.DataSource;
import jas.hist.JASHist;
import jas.hist.JASHist1DHistogramStyle;
import jas.hist.JASHistAxis;
import jas.hist.JASHistData;
import jas.hist.JASHistStyle;
import jas.hist.StatisticsBlock;
import jas.plot.EditableLabel;
import jas.plot.Legend;
import jas.plot.Title;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.freehep.swing.ColorConverter;

public class PlotterRegion
implements IPlotterRegion {
    private static final String[] emptyArray = new String[0];
    private JASHist plot;
    private JPanel panel;
    private Map map = new HashMap();
    private IPlotterStyle plotterStyle = new PlotterStyle();
    private IPlotterLayout plotterLayout = new PlotterLayout();
    private IInfo info = new Info();

    public PlotterRegion(JPanel panel) {
        this.panel = panel;
        panel.setLayout(new BorderLayout());
        panel.setOpaque(false);
    }

    public PlotterRegion() {
        this(new JPanel());
    }

    JPanel getPanel() {
        return this.panel;
    }

    public String[] availableParameterOptions(String str) {
        return emptyArray;
    }

    public String[] availableParameters() {
        return emptyArray;
    }

    public void setParameter(String str) {
    }

    public void setParameter(String str, String str1) {
    }

    public String parameterValue(String str) {
        return null;
    }

    public IPlotterStyle style() {
        return this.plotterStyle;
    }

    public void setStyle(IPlotterStyle style) {
        ((BaseStyle)style).setParent(((BaseStyle)this.plotterStyle).parent());
        this.plotterStyle = style;
    }

    public void applyStyle(IPlotterStyle style) {
        throw new UnsupportedOperationException("This  operation is not supported yet. Please report this problem");
    }

    public void setTitle(String title) {
    }

    public void setXLimits(double param) {
    }

    public void setZLimits(double param) {
    }

    public void setYLimits(double param) {
    }

    public void setZLimits(double param, double param1) {
    }

    public void setZLimits() {
    }

    public void setYLimits(double param, double param1) {
    }

    public void setYLimits() {
    }

    public void setXLimits(double param, double param1) throws IllegalArgumentException {
    }

    public void setXLimits() throws IllegalArgumentException {
    }

    public IInfo info() {
        return this.info;
    }

    public void setInfo(IInfo info) {
        this.info = info;
    }

    public void clear() {
        PlotterRegion.invokeOnSwingThread(new ClearRegion());
    }

    public void plot(IBaseHistogram iBaseHistogram) {
        PlotterRegion.invokeOnSwingThread(new AddRemove(true, this, iBaseHistogram));
    }

    public void plot(IBaseHistogram iBaseHistogram, IPlotterStyle style) {
        PlotterRegion.invokeOnSwingThread(new AddRemove(true, this, iBaseHistogram, style));
    }

    public void plot(IBaseHistogram iBaseHistogram, String options) {
        PlotterRegion.invokeOnSwingThread(new AddRemove(true, this, iBaseHistogram));
    }

    public void plot(IBaseHistogram iBaseHistogram, IPlotterStyle style, String options) {
        PlotterRegion.invokeOnSwingThread(new AddRemove(true, this, iBaseHistogram, style));
    }

    public void plot(IDataPointSet iDataPointSet) {
        PlotterRegion.invokeOnSwingThread(new AddRemove(true, this, iDataPointSet));
    }

    public void plot(IDataPointSet iDataPointSet, IPlotterStyle style) {
        PlotterRegion.invokeOnSwingThread(new AddRemove(true, this, iDataPointSet, style));
    }

    public void plot(IDataPointSet iDataPointSet, String options) {
        PlotterRegion.invokeOnSwingThread(new AddRemove(true, this, iDataPointSet));
    }

    public void plot(IDataPointSet iDataPointSet, IPlotterStyle style, String options) {
        PlotterRegion.invokeOnSwingThread(new AddRemove(true, this, iDataPointSet, style));
    }

    public void plot(IFunction iFunction) {
        PlotterRegion.invokeOnSwingThread(new AddRemove(true, this, iFunction));
    }

    public void plot(IFunction iFunction, IPlotterStyle style) {
        PlotterRegion.invokeOnSwingThread(new AddRemove(true, this, iFunction, style));
    }

    public void plot(IFunction iFunction, String options) {
        PlotterRegion.invokeOnSwingThread(new AddRemove(true, this, iFunction));
    }

    public void plot(IFunction iFunction, IPlotterStyle style, String options) {
        PlotterRegion.invokeOnSwingThread(new AddRemove(true, this, iFunction, style));
    }

    public void remove(IDataPointSet iDataPointSet) {
        PlotterRegion.invokeOnSwingThread(new AddRemove(false, this, iDataPointSet));
    }

    public void remove(IFunction iFunction) {
        PlotterRegion.invokeOnSwingThread(new AddRemove(false, this, iFunction));
    }

    public void remove(IBaseHistogram iBaseHistogram) {
        PlotterRegion.invokeOnSwingThread(new AddRemove(false, this, iBaseHistogram));
    }

    private void add(Object thing, IPlotterStyle style) {
        if (this.plot == null) {
            this.createPlot();
        }
        if (style == null) {
            style = this.plotterStyle;
        } else {
            ((BaseStyle)style).setParent((BaseStyle)this.plotterStyle);
        }
        DataSource ds = null;
        Object title = null;
        if (thing instanceof IHistogram) {
            ds = AIDAAdapter.create((IHistogram)thing);
        } else if (thing instanceof ICloud) {
            ds = AIDAAdapter.create((ICloud)thing);
        } else if (thing instanceof IFunction) {
            ds = AIDAAdapter.create((IFunction)thing);
        } else if (thing instanceof IProfile) {
            ds = AIDAAdapter.create((IProfile)thing);
        } else if (thing instanceof IDataPointSet) {
            ds = AIDAAdapter.create((IDataPointSet)thing);
        }
        if (ds != null) {
            JASHistStyle histStyle;
            String yAxisLineColor;
            String yAxisType;
            String yAxisTickLabelColor;
            String yAxisLabel;
            String xAxisLineColor;
            String xAxisTickLabelColor;
            String xAxisLabel;
            StatisticsBlock stat;
            Legend legend;
            Title titleObj;
            String showStatisticsBoxStr;
            this.map.put(thing, ds);
            String xAxisType = style.xAxisStyle().parameterValue("type");
            if (xAxisType != null && xAxisType.equals("date")) {
                this.plot.getXAxis().setAxisType(3);
            }
            JASHistData jasHistData = this.plot.addData(ds);
            String showLegendStr = style.parameterValue("showLegend");
            if (showLegendStr != null) {
                boolean showLegend = Boolean.valueOf(showLegendStr);
                if (showLegend) {
                    this.plot.setShowLegend(1);
                } else {
                    this.plot.setShowLegend(0);
                }
            }
            if ((showStatisticsBoxStr = style.parameterValue("showStatisticsBox")) != null) {
                this.plot.setShowStatistics(Boolean.valueOf(showStatisticsBoxStr).booleanValue());
            }
            if ((titleObj = this.plot.getTitleObject()) != null) {
                titleObj.setFont(PlotterFontUtil.getFont(style.titleStyle().textStyle()));
                String colorStr = style.titleStyle().textStyle().color();
                if (colorStr != null) {
                    try {
                        Color color = ColorConverter.get((String)colorStr);
                        titleObj.setForeground(color);
                    }
                    catch (Exception cce) {
                        // empty catch block
                    }
                }
            }
            if ((legend = this.plot.getLegend()) != null) {
                legend.setFont(PlotterFontUtil.getFont(style.parameterValue("legendFont"), style.parameterValue("legendFontStyle"), style.parameterValue("legendFontSize")));
            }
            if ((stat = this.plot.getStats()) != null) {
                stat.setFont(PlotterFontUtil.getFont(style.parameterValue("statisticsBoxFont"), style.parameterValue("statisticsBoxFontStyle"), style.parameterValue("statisticsBoxFontSize")));
            }
            JASHistAxis xAxis = this.plot.getXAxis();
            IAxisStyle xAxisStyle = style.xAxisStyle();
            EditableLabel xlabel = xAxis.getLabelObject();
            if (xlabel != null) {
                xlabel.setFont(PlotterFontUtil.getFont(xAxisStyle.labelStyle()));
                String xAxisLabelColor = xAxisStyle.labelStyle().parameterValue("color");
                if (xAxisLabelColor != null) {
                    try {
                        Color color = ColorConverter.get((String)xAxisLabelColor);
                        xlabel.setForeground(color);
                    }
                    catch (Exception cce) {
                        // empty catch block
                    }
                }
            }
            xAxis.setFont(PlotterFontUtil.getFont(xAxisStyle.tickLabelStyle()));
            String xAxisScale = xAxisStyle.parameterValue("scale");
            if (xAxisScale != null) {
                xAxis.setLogarithmic(xAxisScale.startsWith("log"));
            }
            if ((xAxisLabel = xAxisStyle.parameterValue("label")) != null) {
                xAxis.setLabel(xAxisLabel);
            }
            if ((xAxisTickLabelColor = xAxisStyle.tickLabelStyle().color()) != null) {
                try {
                    Color color = ColorConverter.get((String)xAxisTickLabelColor);
                    xAxis.setAxisColor(color);
                }
                catch (Exception cce) {
                    // empty catch block
                }
            }
            if ((xAxisLineColor = xAxisStyle.lineStyle().parameterValue("color")) != null) {
                try {
                    Color color = ColorConverter.get((String)xAxisLineColor);
                    xAxis.setAxisColor(color);
                }
                catch (Exception cce) {
                    // empty catch block
                }
            }
            JASHistAxis yAxis = this.plot.getYAxis();
            IAxisStyle yAxisStyle = style.yAxisStyle();
            EditableLabel ylabel = yAxis.getLabelObject();
            if (ylabel != null) {
                ylabel.setFont(PlotterFontUtil.getFont(yAxisStyle.labelStyle()));
                String yAxisLabelColor = yAxisStyle.labelStyle().parameterValue("color");
                if (yAxisLabelColor != null) {
                    try {
                        Color color = ColorConverter.get((String)yAxisLabelColor);
                        ylabel.setForeground(color);
                    }
                    catch (Exception cce) {
                        // empty catch block
                    }
                }
            }
            yAxis.setFont(PlotterFontUtil.getFont(yAxisStyle.tickLabelStyle()));
            String yAxisScale = yAxisStyle.parameterValue("scale");
            if (yAxisScale != null) {
                yAxis.setLogarithmic(yAxisScale.startsWith("log"));
            }
            if ((yAxisLabel = yAxisStyle.parameterValue("label")) != null) {
                yAxis.setLabel(yAxisLabel);
            }
            if ((yAxisTickLabelColor = yAxisStyle.tickLabelStyle().color()) != null) {
                try {
                    Color color = ColorConverter.get((String)yAxisTickLabelColor);
                    yAxis.setAxisColor(color);
                }
                catch (Exception cce) {
                    // empty catch block
                }
            }
            if ((yAxisType = yAxisStyle.parameterValue("type")) != null && yAxisType.equals("date")) {
                yAxis.setAxisType(3);
            }
            if ((yAxisLineColor = yAxisStyle.lineStyle().parameterValue("color")) != null) {
                try {
                    Color color = ColorConverter.get((String)yAxisLineColor);
                    yAxis.setAxisColor(color);
                }
                catch (Exception cce) {
                    // empty catch block
                }
            }
            if ((histStyle = jasHistData.getStyle()) instanceof JASHist1DHistogramStyle) {
                String errorBarsColor;
                String dataMarkerColor;
                String dataMarkerShape;
                String dataLineColor;
                String connectDataPoints;
                String showDataPoints;
                String showErrorBars;
                String fillHistBars;
                JASHist1DHistogramStyle hs = (JASHist1DHistogramStyle)histStyle;
                IDataStyle dataStyle = style.dataStyle();
                String showHistBars = dataStyle.parameterValue("showHistogramBars");
                if (showHistBars != null) {
                    hs.setShowHistogramBars(Boolean.valueOf(showHistBars).booleanValue());
                }
                if ((fillHistBars = dataStyle.parameterValue("fillHistogramBars")) != null) {
                    hs.setHistogramFill(Boolean.valueOf(fillHistBars).booleanValue());
                }
                if ((showErrorBars = dataStyle.parameterValue("showErrorBars")) != null) {
                    hs.setShowErrorBars(Boolean.valueOf(showErrorBars).booleanValue());
                }
                if ((showDataPoints = dataStyle.parameterValue("showDataPoints")) != null) {
                    hs.setShowDataPoints(Boolean.valueOf(showDataPoints).booleanValue());
                }
                if ((connectDataPoints = dataStyle.parameterValue("connectDataPoints")) != null) {
                    hs.setShowLinesBetweenPoints(Boolean.valueOf(connectDataPoints).booleanValue());
                }
                IFillStyle dataFillStyle = dataStyle.fillStyle();
                ILineStyle dataLineStyle = dataStyle.lineStyle();
                IMarkerStyle dataMarkerStyle = dataStyle.markerStyle();
                String dataFillColor = dataFillStyle.parameterValue("color");
                if (dataFillColor != null) {
                    try {
                        Color color = ColorConverter.get((String)dataFillColor);
                        hs.setDataPointColor(color);
                    }
                    catch (Exception cce) {
                        // empty catch block
                    }
                }
                if ((dataLineColor = dataLineStyle.parameterValue("color")) != null) {
                    try {
                        Color color = ColorConverter.get((String)dataLineColor);
                        hs.setHistogramBarColor(color);
                    }
                    catch (Exception cce) {
                        // empty catch block
                    }
                }
                if ((dataMarkerShape = dataMarkerStyle.parameterValue("shape")) != null) {
                    hs.setDataPointStyle(Integer.valueOf(dataMarkerShape).intValue());
                }
                String dataMarkerSize = dataMarkerStyle.parameterValue("size");
                if (dataMarkerShape != null) {
                    hs.setDataPointSize(Integer.valueOf(dataMarkerSize).intValue());
                }
                if ((dataMarkerColor = dataMarkerStyle.parameterValue("color")) != null) {
                    try {
                        Color color = ColorConverter.get((String)dataMarkerColor);
                        hs.setDataPointColor(color);
                        hs.setErrorBarColor(color);
                        hs.setLineColor(color);
                    }
                    catch (Exception cce) {
                        // empty catch block
                    }
                }
                if ((errorBarsColor = dataStyle.parameterValue("errorBarsColor")) != null) {
                    try {
                        Color color = ColorConverter.get((String)errorBarsColor);
                        hs.setErrorBarColor(color);
                    }
                    catch (Exception cce) {
                        // empty catch block
                    }
                }
            }
            this.plot.setTitle(ds.getTitle());
            jasHistData.show(true);
        }
    }

    private void remove(Object thing) {
        if (this.map.remove(thing) != null) {
            this.rebuild();
        }
    }

    private void rebuild() {
        if (this.map.isEmpty()) {
            this.destroyPlot();
        } else {
            this.plot.removeAll();
            Iterator i = this.map.values().iterator();
            while (i.hasNext()) {
                this.plot.addData((DataSource)i.next()).show(true);
            }
        }
    }

    private void destroyPlot() {
        if (this.plot != null) {
            this.panel.remove((Component)this.plot);
            this.plot.destroy();
            this.plot = null;
        }
    }

    private void createPlot() {
        this.plot = new JASHist();
        this.plot.setShowStatistics(true);
        this.panel.add((Component)this.plot, "Center");
        this.panel.revalidate();
    }

    private static void invokeOnSwingThread(Runnable run) {
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(run);
            }
            catch (InvocationTargetException x) {
                x.printStackTrace();
            }
            catch (InterruptedException x) {
                x.printStackTrace();
            }
        }
    }

    public void setLayout(IPlotterLayout iPlotterLayout) {
        this.plotterLayout = iPlotterLayout;
    }

    public IPlotterLayout layout() {
        return this.plotterLayout;
    }

    private class ClearRegion
    implements Runnable {
        private ClearRegion() {
        }

        public void run() {
            PlotterRegion.this.map.clear();
            PlotterRegion.this.destroyPlot();
        }
    }

    private static class AddRemove
    implements Runnable {
        private boolean add;
        private PlotterRegion region;
        private Object thing;
        private IPlotterStyle styleObj;

        AddRemove(boolean add, PlotterRegion region, Object thing) {
            this(add, region, thing, null);
        }

        AddRemove(boolean add, PlotterRegion region, Object thing, IPlotterStyle styleObj) {
            this.add = add;
            this.region = region;
            this.thing = thing;
            this.styleObj = styleObj;
        }

        public void run() {
            if (this.add) {
                this.region.add(this.thing, this.styleObj);
            } else {
                this.region.remove(this.thing);
            }
            this.region.panel.repaint();
        }
    }
}

