/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter;

import hep.aida.IPlotterRegion;
import hep.aida.ref.plotter.DummyPlotter;
import hep.aida.ref.plotter.PlotterRegion;
import jas.util.layout.PercentLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.freehep.application.PropertyUtilities;
import org.freehep.swing.Headless;
import org.freehep.util.export.ExportFileType;

public class Plotter
extends DummyPlotter {
    private String name;
    private boolean isShowing = false;
    private JPanel panel;

    protected Plotter(String name) {
        this.name = name;
        this.panel = this.createPanel();
        this.configurePanel(this.panel);
        this.createRegion();
    }

    public void writeToFile(String file, String type) throws IOException {
        this.writeToFile(file, type, System.getProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeToFile(OutputStream out, String type, Properties props) throws IOException {
        Headless headLess = null;
        if (!this.isShowing) {
            headLess = new Headless((JComponent)this.panel);
            int width = props == null ? 600 : PropertyUtilities.getInteger((Properties)props, (String)"plotWidth", (int)600);
            int height = props == null ? 400 : PropertyUtilities.getInteger((Properties)props, (String)"plotHeight", (int)400);
            this.panel.setPreferredSize(new Dimension(width, height));
            headLess.pack();
            headLess.show();
        }
        try {
            List types = ExportFileType.getExportFileTypes((String)type);
            if (types == null || types.size() == 0) {
                throw new IllegalArgumentException("Unsupported file type: " + type);
            }
            ExportFileType fileType = (ExportFileType)types.get(0);
            fileType.exportToFile(out, (Component)this.panel, null, props, "AIDA");
        }
        finally {
            if (headLess != null) {
                headLess.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeToFile(String file, String type, Properties props) throws IOException {
        int pos;
        if (type == null && (pos = file.lastIndexOf(46)) > 0) {
            type = file.substring(pos + 1);
        }
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        try {
            this.writeToFile(out, type, props);
        }
        finally {
            ((OutputStream)out).close();
        }
    }

    protected JPanel createPanel() {
        return new JPanel();
    }

    protected PlotterRegion createPlotterRegion() {
        return new PlotterRegion();
    }

    protected void configurePanel(JPanel panel) {
        panel.setLayout((LayoutManager)new PercentLayout());
        panel.setBackground(Color.white);
        panel.setPreferredSize(new Dimension(600, 600));
    }

    protected JPanel getPanel() {
        return this.panel;
    }

    protected String getTitle() {
        return this.name;
    }

    public void show() {
        if (!this.isShowing) {
            JFrame frame = new JFrame(this.name);
            frame.setContentPane(this.panel);
            frame.setDefaultCloseOperation(2);
            frame.pack();
            frame.show();
            this.isShowing = true;
        }
    }

    public void hide() {
        if (this.isShowing) {
            JFrame frame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this.panel);
            if (frame != null) {
                frame.dispose();
            }
            this.isShowing = false;
        }
    }

    protected IPlotterRegion justCreateRegion(double x, double y, double width, double height) {
        CreateRegion cr = new CreateRegion(x, y, width, height);
        Plotter.invokeOnSwingThread(cr);
        return cr.getRegion();
    }

    public void destroyRegions() {
        Plotter.invokeOnSwingThread(new DestroyRegions());
        super.destroyRegions();
    }

    public static void invokeOnSwingThread(Runnable run) {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                run.run();
            } else {
                SwingUtilities.invokeAndWait(run);
            }
        }
        catch (InvocationTargetException x) {
            x.printStackTrace();
        }
        catch (InterruptedException x) {
            x.printStackTrace();
        }
    }

    private class DestroyRegions
    implements Runnable {
        private DestroyRegions() {
        }

        public void run() {
            Plotter.this.panel.removeAll();
            Plotter.this.panel.repaint();
        }
    }

    private class CreateRegion
    implements Runnable {
        private double x;
        private double y;
        private double width;
        private double height;
        private PlotterRegion region;

        CreateRegion(double x, double y, double width, double height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public void run() {
            this.region = Plotter.this.createPlotterRegion();
            Plotter.this.panel.add((Component)this.region.getPanel(), new PercentLayout.Constraint(this.x * 100.0, this.y * 100.0, this.width * 100.0, this.height * 100.0));
        }

        IPlotterRegion getRegion() {
            return this.region;
        }
    }
}

