/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter;

import hep.aida.IPlotter;
import hep.aida.IPlotterRegion;
import hep.aida.ITitleStyle;
import hep.aida.ref.plotter.DummyPlotterRegion;
import hep.aida.ref.plotter.TitleStyle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DummyPlotter
implements IPlotter {
    private ITitleStyle titleStyle = new TitleStyle();
    private static final String[] emptyArray = new String[0];
    private List regions = new ArrayList();
    private int currentRegion = 0;

    protected DummyPlotter() {
    }

    DummyPlotter(String name) {
        this.createRegion();
    }

    protected IPlotterRegion justCreateRegion(double x, double y, double width, double height) {
        return new DummyPlotterRegion(x, y, width, height);
    }

    public void writeToFile(String file) throws IOException {
        this.writeToFile(file, null);
    }

    public void writeToFile(String file, String type) throws IOException {
        System.err.println("Warning: Dummy plotter used, no file will be written");
    }

    public void show() {
        System.err.println("Warning: Dummy plotter used, no plot will appear");
    }

    public void hide() {
    }

    public void refresh() {
    }

    public void interact() {
    }

    public IPlotterRegion next() {
        return (IPlotterRegion)this.regions.get(++this.currentRegion);
    }

    public IPlotterRegion createRegion(double x) {
        return this.createRegion(x, 0.0, 1.0 - x, 1.0);
    }

    public IPlotterRegion createRegion() {
        return this.createRegion(0.0, 0.0, 1.0, 1.0);
    }

    public IPlotterRegion createRegion(double x, double y) {
        return this.createRegion(x, y, 1.0 - x, 1.0 - y);
    }

    public IPlotterRegion createRegion(double x, double y, double w) {
        return this.createRegion(x, y, w, 1.0 - y);
    }

    public IPlotterRegion createRegion(double x, double y, double w, double h) {
        if (x < 0.0 || x > 1.0) {
            throw new IllegalArgumentException("x");
        }
        if (y < 0.0 || y > 1.0) {
            throw new IllegalArgumentException("y");
        }
        if (w < 0.0 || x + w > 1.0) {
            throw new IllegalArgumentException("w");
        }
        if (h < 0.0 || y + h > 1.0) {
            throw new IllegalArgumentException("h");
        }
        IPlotterRegion region = this.justCreateRegion(x, y, w, h);
        this.regions.add(region);
        return region;
    }

    public IPlotterRegion currentRegion() {
        return (IPlotterRegion)this.regions.get(this.currentRegion);
    }

    public void createRegions() {
        this.createRegions(1, 1, 0);
    }

    public void createRegions(int columns) {
        this.createRegions(columns, 1, 0);
    }

    public void createRegions(int columns, int rows) {
        this.createRegions(columns, rows, 0);
    }

    public void createRegions(int columns, int rows, int start) {
        if (columns <= 0) {
            throw new IllegalArgumentException("columns");
        }
        if (rows <= 0) {
            throw new IllegalArgumentException("rows");
        }
        if (start < 0 || start >= rows * columns) {
            throw new IllegalArgumentException("start");
        }
        this.destroyRegions();
        double width = 1.0 / (double)columns;
        double height = 1.0 / (double)rows;
        for (int i = 0; i < columns; ++i) {
            for (int j = 0; j < rows; ++j) {
                this.regions.add(this.justCreateRegion((double)i * width, (double)j * height, width, height));
            }
        }
        this.currentRegion = start;
    }

    public void setCurrentRegionNumber(int value) {
        if (value < 0 || value >= this.regions.size()) {
            throw new IllegalArgumentException();
        }
        this.currentRegion = value;
    }

    public int currentRegionNumber() {
        return this.currentRegion;
    }

    public IPlotterRegion region(int index) {
        if (index < 0 || index >= this.regions.size()) {
            throw new IllegalArgumentException();
        }
        return (IPlotterRegion)this.regions.get(index);
    }

    public void destroyRegions() {
        this.regions.clear();
    }

    public void clearRegions() {
        Iterator i = this.regions.iterator();
        while (i.hasNext()) {
            ((IPlotterRegion)i.next()).clear();
        }
    }

    public String[] availableParameterOptions(String str) {
        return emptyArray;
    }

    public void setParameter(String name) {
        this.setParameter(name, null);
    }

    public void setParameter(String name, String value) {
    }

    public String[] availableParameters() {
        return emptyArray;
    }

    public int numberOfRegions() {
        return this.regions.size();
    }

    public ITitleStyle titleStyle() {
        return this.titleStyle;
    }

    public void setTitle(String str) {
    }

    public String parameterValue(String str) {
        return null;
    }

    public void setTitleStyle(ITitleStyle iTitleStyle) {
        this.titleStyle = iTitleStyle;
    }
}

