/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.optimizer.minuit;

import hep.aida.IFunction;
import hep.aida.ref.optimizer.AbstractOptimizer;
import hep.aida.ref.optimizer.OptimizerResult;
import hep.aida.ref.optimizer.minuit.MinuitCommands;
import hep.aida.ref.optimizer.minuit.MinuitOptimizerConfiguration;

public class MinuitOptimizer
extends AbstractOptimizer {
    private MinuitCommands minuitCommands = new MinuitCommands();

    public MinuitOptimizer() {
        this.result = new OptimizerResult();
        this.configuration = new MinuitOptimizerConfiguration(this);
        this.domainConstraint = null;
    }

    public void optimize() {
        this.minuitCommands.resetMinuit();
        if (this.function == null) {
            throw new IllegalArgumentException("Cannot optimize!! The function was not set correctely!");
        }
        this.minuitCommands.setFunction(this.function, this);
        String method = this.configuration.method();
        int maxIterations = this.configuration.maxIterations();
        double tolerance = this.configuration.tolerance();
        this.minuitCommands.optimize(method, maxIterations, tolerance);
        this.minuitCommands.updateFunction(this);
        this.result.setCovarianceMatrix(this.minuitCommands.getCovarianceMatrix());
        this.result.setOptimizationStatus(this.minuitCommands.getStatus());
    }

    public void minosAnalysis() {
        this.minuitCommands.minos();
    }

    public void setFunction(IFunction function) {
        super.setFunction(function);
        this.minuitCommands.setFunction(function, this);
    }

    protected MinuitCommands commands() {
        return this.minuitCommands;
    }

    public double[][] calculateContour(String parName1, String parName2, int nPoints, double nSigmas) {
        return this.commands().calculateContour(parName1, parName2, nPoints, nSigmas);
    }

    public void reset() {
        super.reset();
        this.minuitCommands.resetMinuit();
    }
}

