/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.optimizer.minuit;

import hep.aida.IFunction;
import hep.aida.ext.IVariableSettings;
import hep.aida.ref.optimizer.minuit.MinuitOptimizer;
import java.util.ArrayList;

public class MinuitCommands {
    private static IFunction function = null;
    private String[] variableNames;
    private int[] parInfo = new int[2];
    private double[] minInfo = new double[3];
    private double[] arglist = new double[100];
    private ArrayList varList = new ArrayList();
    protected static final int MATRIX_NOT_CALCULATED = 0;
    protected static final int MATRIX_DIAGONAL_APPROX = 1;
    protected static final int MATRIX_FULL_FORCED_POS = 2;
    protected static final int MATRIX_FULL_ACCURATE = 3;
    protected static final int NO_OUTPUT = -1;
    protected static final int MINIMAL_OUTPUT = 0;
    protected static final int NORMAL_OUTPUT = 1;
    protected static final int DETAILED_OUTPUT = 2;
    protected static final int MAXIMAL_OUTPUT = 3;
    protected static final int SIMPLEX_MIN = 0;
    protected static final int MIGRAD_MIN = 1;
    protected static final int MINIMIZE_MIN = 2;

    protected static native void jmninit(int var0, int var1, int var2);

    protected static native void jmnseti(String var0);

    protected static native int jmnparm(int var0, String var1, double var2, double var4, double var6, double var8);

    protected static native int jmnexcm(String var0, double[] var1, int var2);

    protected static native int jmnpout(int var0, String[] var1, double[] var2);

    protected static native int jmnstat(double[] var0, int[] var1);

    protected static native void jmnemat(double[] var0, int var1);

    protected static native void jmnerrs(int var0, double[] var1);

    protected static native void jmncont(int var0, int var1, int var2, double[] var3, double[] var4, int[] var5);

    protected MinuitCommands() {
        MinuitCommands.jmninit(5, 6, 7);
    }

    public void setPrintLevel(int printLevel) throws IllegalArgumentException {
        this.arglist[0] = printLevel;
        MinuitCommands.jmnexcm("SET PRINT", this.arglist, 1);
    }

    protected void resetMinuit() {
        function = null;
        this.variableNames = null;
        this.varList.clear();
        MinuitCommands.jmnexcm("CLEAR", this.arglist, 0);
    }

    public static double evaluateFunction(double[] vars) {
        return function.value(vars);
    }

    public static double[] evaluateDerivatives(double[] vars) {
        return function.gradient(vars);
    }

    public static void initializeFunction() {
    }

    public static void finalizeFunction() {
    }

    protected void setFunction(IFunction function, MinuitOptimizer optimizer) {
        MinuitCommands.function = function;
        this.variableNames = function.variableNames();
        if (this.variableNames == null || this.variableNames.length == 0) {
            throw new IllegalArgumentException("Cannot optimize!! There are no variables in this function!");
        }
        for (int i = 0; i < this.variableNames.length; ++i) {
            String varName = this.variableNames[i];
            IVariableSettings varSet = optimizer.variableSettings(varName);
            double value = varSet.value();
            if (Double.isNaN(value)) {
                throw new IllegalArgumentException("No initial value set for variable " + varName);
            }
            if (varSet.isBound()) {
                this.addVariable(varName, value, varSet.stepSize(), varSet.lowerBound(), varSet.upperBound());
            } else {
                this.addVariable(varName, value, varSet.stepSize(), 0.0, 0.0);
            }
            if (!varSet.isFixed()) continue;
            this.fixVariable(varName);
        }
        if (this.getNVariables() == 0) {
            throw new IllegalArgumentException("Cannot optimize!! There are no free variable registered in Minuit!");
        }
    }

    protected void updateFunction(MinuitOptimizer optimizer) {
        for (int i = 0; i < this.variableNames.length; ++i) {
            String varName = this.variableNames[i];
            IVariableSettings varSet = optimizer.variableSettings(varName);
            if (varSet.isFixed()) continue;
            String[] name = new String[1];
            double[] vals = new double[4];
            MinuitCommands.jmnpout(i + 1, name, vals);
            varSet.setValue(vals[0]);
            varSet.setStepSize(vals[1]);
        }
    }

    protected void fixVariable(String varName) {
        this.arglist[0] = this.varList.indexOf(varName) + 1;
        if (MinuitCommands.jmnexcm("FIX", this.arglist, 1) != 0) {
            throw new RuntimeException();
        }
    }

    private void addVariable(String varName, double value, double step, double lowerBound, double upperBound) {
        if (MinuitCommands.jmnparm(this.varList.size() + 1, varName, value, step, lowerBound, upperBound) != 0) {
            throw new RuntimeException();
        }
        this.varList.add(varName);
    }

    protected int getStatus() {
        return MinuitCommands.jmnstat(this.minInfo, this.parInfo);
    }

    protected int getNVariables() {
        MinuitCommands.jmnstat(this.minInfo, this.parInfo);
        return this.parInfo[0];
    }

    protected double getErrorDef() {
        MinuitCommands.jmnstat(this.minInfo, this.parInfo);
        return this.minInfo[2];
    }

    protected void setErrorDef(int errDef) {
        if (errDef == 0 || errDef == 1) {
            this.arglist[0] = 1.0;
        } else if (errDef == 2) {
            this.arglist[0] = 0.5;
        }
        if (MinuitCommands.jmnexcm("SET ERR", this.arglist, 1) != 0) {
            throw new RuntimeException();
        }
    }

    protected void setErrorDefinition(double errDef) {
        this.arglist[0] = errDef;
        if (MinuitCommands.jmnexcm("SET ERR", this.arglist, 1) != 0) {
            throw new RuntimeException();
        }
    }

    protected void setUseFunctionGradient(boolean useFunctionGradient) {
        if (useFunctionGradient) {
            if (MinuitCommands.jmnexcm("SET GRADIENT", this.arglist, 1) != 0) {
                throw new RuntimeException();
            }
            this.arglist[0] = 1.0;
            if (MinuitCommands.jmnexcm("SET NOGRADIENT", this.arglist, 0) != 0) {
                throw new RuntimeException();
            }
        }
    }

    protected void setStrategy(int strategy) {
        this.arglist[0] = strategy;
        if (MinuitCommands.jmnexcm("SET STRATEGY", this.arglist, 1) != 0) {
            throw new RuntimeException();
        }
    }

    protected void setPrecision(double precision) {
        this.arglist[0] = precision;
        if (MinuitCommands.jmnexcm("SET EPSMACHINE", this.arglist, 1) != 0) {
            throw new RuntimeException();
        }
    }

    protected void optimize(String method, int maxIterations, double tolerance) {
        this.arglist[0] = 1.0;
        if (MinuitCommands.jmnexcm("CALL FCN", this.arglist, 1) != 0) {
            throw new RuntimeException();
        }
        int nArg = 2;
        this.arglist[0] = maxIterations;
        this.arglist[1] = tolerance;
        if (method.startsWith("IMP")) {
            nArg = 1;
        }
        MinuitCommands.jmnexcm(method, this.arglist, nArg);
    }

    protected void minos() {
        this.internMinos(0);
    }

    private void internMinos(int nArg) {
        if (function == null) {
            throw new RuntimeException("A function has to be provided before minimizing!!!");
        }
        if (MinuitCommands.jmnexcm("MINOS", this.arglist, nArg) != 0) {
            throw new RuntimeException();
        }
    }

    protected double[][] calculateContour(String parName1, String parName2) {
        return this.calculateContour(parName1, parName2, 20);
    }

    protected double[][] calculateContour(String parName1, String parName2, int nPoints) {
        return this.calculateContour(parName1, parName2, nPoints, 1.0);
    }

    protected double[][] calculateContour(String parName1, String parName2, int nPoints, double nSigmas) {
        double errDef = this.getErrorDef();
        if (nSigmas < 1.0) {
            throw new IllegalArgumentException("The number of sigmas has to at least 1");
        }
        this.setErrorDefinition(nSigmas * nSigmas * errDef);
        int parIndex1 = this.varList.indexOf(parName1) + 1;
        int parIndex2 = this.varList.indexOf(parName2) + 1;
        double[] xPoints = new double[nPoints];
        double[] yPoints = new double[nPoints];
        int[] nFound = new int[1];
        MinuitCommands.jmncont(parIndex1, parIndex2, nPoints, xPoints, yPoints, nFound);
        int pointFound = nFound[0];
        double[][] contour = new double[2][pointFound];
        for (int i = 0; i < pointFound; ++i) {
            contour[0][i] = xPoints[i];
            contour[1][i] = yPoints[i];
        }
        this.setErrorDefinition(errDef);
        return contour;
    }

    protected double[][] getCovarianceMatrix() {
        int nDim = this.getNVariables();
        double[][] covMatrix = new double[nDim][nDim];
        double[] matrix = new double[nDim * nDim];
        MinuitCommands.jmnemat(matrix, nDim);
        for (int i = 0; i < nDim; ++i) {
            for (int j = 0; j < nDim; ++j) {
                covMatrix[i][j] = matrix[i * nDim + j];
            }
        }
        return covMatrix;
    }

    static {
        String libName = "minuitAdapter";
        try {
            System.loadLibrary(libName);
        }
        catch (Throwable t) {
            throw new RuntimeException("Problem loading the library " + libName + " " + t.getMessage());
        }
    }
}

