/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.optimizer;

import hep.aida.IAnnotation;
import hep.aida.IFunction;
import hep.aida.ext.IVariable;
import hep.aida.ref.function.AbstractModelFunction;
import hep.aida.ref.function.Variable;
import java.util.Random;

public class TrialFunctions
extends AbstractModelFunction {
    private String PARABOLA_1D = "parabola_1d";
    private String PARABOLA_2D = "parabola_2d";
    private String PARABOLA_3D = "parabola_3d";
    private String PARABOLA_4D = "parabola_4d";
    private String PARABOLA_5D = "parabola_5d";
    private IVariable[] variables;
    private String[] variableNames;
    private IVariable[] parameters;
    private String[] parameterNames;
    private int dimension;
    private Random rnd = new Random();

    public TrialFunctions(String functionType) {
        if (functionType.equals(this.PARABOLA_1D)) {
            this.dimension = 1;
        } else if (functionType.equals(this.PARABOLA_2D)) {
            this.dimension = 2;
        } else if (functionType.equals(this.PARABOLA_3D)) {
            this.dimension = 3;
        } else if (functionType.equals(this.PARABOLA_4D)) {
            this.dimension = 4;
        } else if (functionType.equals(this.PARABOLA_5D)) {
            this.dimension = 5;
        } else {
            System.out.println("Function not supported");
            return;
        }
        this.variables = new IVariable[this.dimension];
        this.parameters = new IVariable[this.dimension];
        this.variableNames = new String[this.dimension];
        this.parameterNames = new String[this.dimension];
        for (int i = 0; i < this.dimension; ++i) {
            String varName = "var" + i;
            String parName = "par" + i;
            double value = this.rnd.nextGaussian();
            this.variables[i] = new Variable(varName, "", value, -10.0, 10.0);
            this.variableNames[i] = varName;
            this.parameters[i] = new Variable(parName, "", i + 1);
            this.parameterNames[i] = parName;
        }
    }

    public int dimension() {
        return this.dimension;
    }

    public String label() {
        return "";
    }

    public double parameter(String str) {
        throw new UnsupportedOperationException();
    }

    public String[] parameterNames() {
        return this.parameterNames;
    }

    public double[] parameterValues() {
        return null;
    }

    public double[] parameters() {
        throw new UnsupportedOperationException();
    }

    public void setNormalization(double param) {
    }

    public boolean supportsNormalization() {
        return false;
    }

    public double value() throws IllegalArgumentException {
        double val = 1.0;
        for (int i = 0; i < this.dimension; ++i) {
            val += (double)(i + 1) * Math.pow(this.variables[i].value() - this.parameters[i].value(), 2.0);
        }
        return val;
    }

    public double value(double[] values) {
        for (int i = 0; i < this.dimension; ++i) {
            this.variables[i].setValue(values[i]);
        }
        return this.value();
    }

    public double value(double[] values, double[] values1) throws IllegalArgumentException {
        return 0.0;
    }

    public IVariable variable(String str) {
        for (int i = 0; i < this.dimension; ++i) {
            if (!this.variables[i].name().equals(str)) continue;
            return this.variables[i];
        }
        return null;
    }

    public IVariable[] variables() {
        return this.variables;
    }

    public IAnnotation annotation() {
        throw new UnsupportedOperationException();
    }

    public String codeletString() {
        throw new UnsupportedOperationException();
    }

    public double[] gradient(double[] values) {
        throw new UnsupportedOperationException();
    }

    public int indexOfParameter(String str) {
        throw new UnsupportedOperationException();
    }

    public boolean isEqual(IFunction iFunction) {
        throw new UnsupportedOperationException();
    }

    public int numberOfParameters() {
        throw new UnsupportedOperationException();
    }

    public boolean providesGradient() {
        throw new UnsupportedOperationException();
    }

    public void setParameter(String str, double param) {
        throw new UnsupportedOperationException();
    }

    public void setParameters(double[] values) {
        throw new UnsupportedOperationException();
    }

    public String variableName(int param) {
        throw new UnsupportedOperationException();
    }

    public String[] variableNames() {
        return this.variableNames;
    }

    public void setTitle(String str) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public String title() {
        throw new UnsupportedOperationException();
    }
}

