/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.histogram;

import hep.aida.IAxis;
import hep.aida.IHistogram2D;
import hep.aida.ref.AidaUtils;
import hep.aida.ref.histogram.Histogram;
import hep.aida.ref.histogram.UnfillableHistogramException;
import hep.aida.ref.histogram.binner.BasicBinner2D;
import hep.aida.ref.histogram.binner.Binner2D;
import hep.aida.ref.histogram.binner.EfficiencyBinner2D;
import java.util.Map;

public class Histogram2D
extends Histogram
implements IHistogram2D {
    private double meanX = 0.0;
    private double rmsX = 0.0;
    private double meanY = 0.0;
    private double rmsY = 0.0;
    private IAxis xAxis;
    private IAxis yAxis;
    private Binner2D binner2D;

    public Histogram2D() {
        super("", "", 2, "");
    }

    public Histogram2D(String name, String title, IAxis xAxis, IAxis yAxis) {
        this(name, title, xAxis, yAxis, "");
    }

    protected Histogram2D(String name, String title, IAxis xAxis, IAxis yAxis, String options) {
        super(name, title, 2, options);
        this.initHistogram2D(xAxis, yAxis, options);
    }

    public void fill(double x, double y) {
        this.fill(x, y, 1.0);
    }

    public void fill(double x, double y, double weight) {
        if (!this.isFillable()) {
            throw new UnfillableHistogramException();
        }
        int xBin = this.mapBinNumber(this.xAxis.coordToIndex(x), this.xAxis());
        int yBin = this.mapBinNumber(this.yAxis.coordToIndex(y), this.yAxis());
        this.binner2D.fill(xBin, yBin, x, y, weight);
        this.meanX += x * weight;
        this.rmsX += x * x * weight;
        this.meanY += y * weight;
        this.rmsY += y * y * weight;
        ++this.allEntries;
        this.sumOfWeights += weight;
        this.sumOfWeightsSquared += weight * weight;
        if (this.isValid) {
            this.fireStateChanged();
        }
    }

    public void reset() {
        super.reset();
        this.binner2D.clear();
        this.meanX = 0.0;
        this.rmsX = 0.0;
        this.meanY = 0.0;
        this.rmsY = 0.0;
    }

    public int extraEntries() {
        int n = 0;
        int i = this.xAxis.bins();
        while (--i >= -2) {
            int j = this.yAxis.bins();
            while (--j >= -2) {
                if (i >= 0 && j >= 0) continue;
                n += this.binEntries(i, j);
            }
        }
        return n;
    }

    public double sumAllBinHeights() {
        double sum = 0.0;
        int i = this.xAxis.bins();
        while (--i >= -2) {
            int j = this.yAxis.bins();
            while (--j >= -2) {
                sum += this.binHeight(i, j);
            }
        }
        return sum;
    }

    public double sumExtraBinHeights() {
        int sum = 0;
        int i = this.xAxis.bins();
        while (--i >= -2) {
            int j = this.yAxis.bins();
            while (--j >= -2) {
                if (i >= 0 && j >= 0) continue;
                sum = (int)((double)sum + this.binHeight(i, j));
            }
        }
        return sum;
    }

    public double minBinHeight() {
        double min = Double.NaN;
        for (int i = 1; i <= this.xAxis.bins(); ++i) {
            for (int j = 1; j <= this.yAxis.bins(); ++j) {
                if (!Double.isNaN(min) && !(this.binHeight(i, j) <= min)) continue;
                min = this.binHeight(i, j);
            }
        }
        return min;
    }

    public double maxBinHeight() {
        double max = Double.NaN;
        for (int i = 1; i <= this.xAxis.bins(); ++i) {
            for (int j = 1; j <= this.yAxis.bins(); ++j) {
                if (!Double.isNaN(max) && !(this.binHeight(i, j) >= max)) continue;
                max = this.binHeight(i, j);
            }
        }
        return max;
    }

    public int binEntries(int indexX, int indexY) {
        return this.binner2D.entries(this.mapBinNumber(indexX, this.xAxis()), this.mapBinNumber(indexY, this.yAxis()));
    }

    public int binEntriesX(int indexX) {
        int n = 0;
        for (int j = -2; j < this.yAxis().bins(); ++j) {
            n += this.binEntries(indexX, j);
        }
        return n;
    }

    public int binEntriesY(int indexY) {
        int n = 0;
        for (int i = -2; i < this.xAxis().bins(); ++i) {
            n += this.binEntries(i, indexY);
        }
        return n;
    }

    public double binHeight(int indexX, int indexY) {
        return this.binner2D.height(this.mapBinNumber(indexX, this.xAxis()), this.mapBinNumber(indexY, this.yAxis()));
    }

    public double binHeightX(int indexX) {
        double d = 0.0;
        for (int j = -2; j < this.yAxis().bins(); ++j) {
            d += this.binHeight(indexX, j);
        }
        return d;
    }

    public double binHeightY(int indexY) {
        double d = 0.0;
        for (int i = -2; i < this.xAxis().bins(); ++i) {
            d += this.binHeight(i, indexY);
        }
        return d;
    }

    public double binError(int indexX, int indexY) {
        return this.binner2D.plusError(this.mapBinNumber(indexX, this.xAxis()), this.mapBinNumber(indexY, this.yAxis()));
    }

    public double meanX() {
        if (this.allEntries != 0) {
            return this.meanX / this.sumOfWeights;
        }
        return 0.0;
    }

    public double meanY() {
        if (this.allEntries != 0) {
            return this.meanY / this.sumOfWeights;
        }
        return 0.0;
    }

    public double rmsX() {
        if (this.allEntries != 0) {
            return Math.sqrt(this.rmsX / this.sumOfWeights - this.meanX * this.meanX / this.sumOfWeights / this.sumOfWeights);
        }
        return 0.0;
    }

    public double rmsY() {
        if (this.allEntries != 0) {
            return Math.sqrt(this.rmsY / this.sumOfWeights - this.meanY * this.meanY / this.sumOfWeights / this.sumOfWeights);
        }
        return 0.0;
    }

    public IAxis xAxis() {
        return this.xAxis;
    }

    public IAxis yAxis() {
        return this.yAxis;
    }

    public int coordToIndexX(double coordX) {
        return this.xAxis().coordToIndex(coordX);
    }

    public int coordToIndexY(double coordY) {
        return this.yAxis().coordToIndex(coordY);
    }

    public void scale(double scaleFactor) {
        if (scaleFactor <= 0.0) {
            throw new IllegalArgumentException("Illegal scale factor " + scaleFactor + " it has to be positive");
        }
        this.binner2D.scale(scaleFactor);
        this.meanX *= scaleFactor;
        this.rmsX *= scaleFactor;
        this.meanY *= scaleFactor;
        this.rmsY *= scaleFactor;
        this.sumOfWeights *= scaleFactor;
        this.sumOfWeightsSquared *= scaleFactor * scaleFactor;
    }

    public void add(IHistogram2D hist) throws IllegalArgumentException {
        if (!this.xAxis().equals(hist.xAxis())) {
            throw new IllegalArgumentException("Cannot add. Incompatible histogram binning!");
        }
        if (!this.yAxis().equals(hist.yAxis())) {
            throw new IllegalArgumentException("Cannot add. Incompatible histogram binning!");
        }
        int xbins = this.xAxis().bins() + 2;
        int ybins = this.yAxis().bins() + 2;
        double[][] newHeights = new double[xbins][ybins];
        double[][] newErrors = new double[xbins][ybins];
        double[][] newMeanXs = new double[xbins][ybins];
        double[][] newRmsXs = new double[xbins][ybins];
        double[][] newMeanYs = new double[xbins][ybins];
        double[][] newRmsYs = new double[xbins][ybins];
        int[][] newEntries = new int[xbins][ybins];
        for (int i = -2; i < this.xAxis().bins(); ++i) {
            for (int j = -2; j < this.yAxis().bins(); ++j) {
                double height1 = this.binHeight(i, j);
                double height2 = hist.binHeight(i, j);
                double h = height1 + height2;
                double meanx1 = this.binMeanX(i, j);
                double meanx2 = hist.binMeanX(i, j);
                double mx = 0.0;
                double rmsx1 = this.binRmsX(i, j);
                double rmsx2 = ((Histogram2D)hist).binRmsX(i, j);
                double rx = 0.0;
                double meany1 = this.binMeanY(i, j);
                double meany2 = hist.binMeanY(i, j);
                double my = 0.0;
                double rmsy1 = this.binRmsY(i, j);
                double rmsy2 = ((Histogram2D)hist).binRmsY(i, j);
                double ry = 0.0;
                if (h != 0.0) {
                    mx = (meanx1 * height1 + meanx2 * height2) / (height1 + height2);
                    rx = Math.sqrt((rmsx1 * rmsx1 * height1 + meanx1 * meanx1 * height1 + (rmsx2 * rmsx2 * height2 + meanx2 * meanx2 * height2)) / h - mx * mx);
                    my = (meany1 * height1 + meany2 * height2) / (height1 + height2);
                    ry = Math.sqrt((rmsy1 * rmsy1 * height1 + meany1 * meany1 * height1 + (rmsy2 * rmsy2 * height2 + meany2 * meany2 * height2)) / h - my * my);
                }
                int binx = this.mapBinNumber(i, this.xAxis());
                int biny = this.mapBinNumber(j, this.yAxis());
                newHeights[binx][biny] = h;
                newErrors[binx][biny] = Math.sqrt(Math.pow(this.binError(i, j), 2.0) + Math.pow(hist.binError(i, j), 2.0));
                newEntries[binx][biny] = this.binEntries(i, j) + hist.binEntries(i, j);
                newMeanXs[binx][biny] = mx;
                newRmsXs[binx][biny] = rx;
                newMeanYs[binx][biny] = my;
                newRmsYs[binx][biny] = ry;
            }
        }
        this.setContents(newHeights, newErrors, newEntries, newMeanXs, newRmsXs, newMeanYs, newRmsYs);
    }

    public void setMeanX(double meanX) {
        this.meanX = meanX * this.sumOfWeights;
    }

    public void setRmsX(double rmsX) {
        this.rmsX = rmsX * rmsX * this.sumOfWeights + this.meanX() * this.meanX() * this.sumOfWeights;
    }

    public void setMeanY(double meanY) {
        this.meanY = meanY * this.sumOfWeights;
    }

    public void setRmsY(double rmsY) {
        this.rmsY = rmsY * rmsY * this.sumOfWeights + this.meanY() * this.meanY() * this.sumOfWeights;
    }

    public double binMeanX(int indexX, int indexY) {
        int binx = this.mapBinNumber(indexX, this.xAxis());
        int biny = this.mapBinNumber(indexY, this.yAxis());
        return this.binner2D.meanX(binx, biny);
    }

    public double binMeanY(int indexX, int indexY) {
        int binx = this.mapBinNumber(indexX, this.xAxis());
        int biny = this.mapBinNumber(indexY, this.yAxis());
        return this.binner2D.meanY(binx, biny);
    }

    public double binRmsX(int indexX, int indexY) {
        int binx = this.mapBinNumber(indexX, this.xAxis());
        int biny = this.mapBinNumber(indexY, this.yAxis());
        return this.binner2D.rmsX(binx, biny);
    }

    public double binRmsY(int indexX, int indexY) {
        int binx = this.mapBinNumber(indexX, this.xAxis());
        int biny = this.mapBinNumber(indexY, this.yAxis());
        return this.binner2D.rmsY(binx, biny);
    }

    public void setBinError(int indexX, int indexY, double error) {
        int binx = this.mapBinNumber(indexX, this.xAxis());
        int biny = this.mapBinNumber(indexY, this.yAxis());
        this.binner2D.setBinContent(binx, biny, this.binEntries(indexX, indexY), this.binHeight(indexX, indexY), error, error, this.binMeanX(indexX, indexY), this.binRmsX(indexX, indexY), this.binMeanY(indexX, indexY), this.binRmsY(indexX, indexY));
    }

    public void setContents(double[][] heights, double[][] errors, int[][] entries, double[][] meanXs, double[][] rmsXs, double[][] meanYs, double[][] rmsYs) {
        this.reset();
        for (int i = 0; i < this.xAxis().bins() + 2; ++i) {
            int mi = i == 0 ? -2 : (i == this.xAxis().bins() + 1 ? -1 : i - 1);
            for (int j = 0; j < this.yAxis().bins() + 2; ++j) {
                int mj = j == 0 ? -2 : (j == this.yAxis().bins() + 1 ? -1 : j - 1);
                double h = heights[i][j];
                double mx = meanXs != null ? meanXs[i][j] : (this.xAxis().binLowerEdge(mi) + this.xAxis().binUpperEdge(mi)) / 2.0;
                double my = meanYs != null ? meanYs[i][j] : (this.yAxis().binLowerEdge(mj) + this.yAxis().binUpperEdge(mj)) / 2.0;
                double rx = rmsXs != null ? rmsXs[i][j] : (this.xAxis().binUpperEdge(mi) - this.xAxis().binLowerEdge(mi)) / Math.sqrt(12.0);
                double ry = rmsYs != null ? rmsYs[i][j] : (this.yAxis().binUpperEdge(mj) - this.yAxis().binLowerEdge(mj)) / Math.sqrt(12.0);
                int e = entries != null ? entries[i][j] : (int)h;
                this.binner2D.setBinContent(i, j, e, h, errors[i][j], errors[i][j], mx, rx, my, ry);
                this.allEntries += e;
                if (!(Double.isNaN(mx) || Double.isNaN(my) || Double.isInfinite(mx) || Double.isInfinite(my))) {
                    this.meanX += mx * h;
                    this.rmsX += rx * rx * h + mx * mx * h;
                    this.meanY += my * h;
                    this.rmsY += ry * ry * h + my * my * h;
                }
                this.sumOfWeights += h;
            }
        }
    }

    public void initHistogram2D(IAxis xAxis, IAxis yAxis, String options) {
        this.xAxis = xAxis;
        this.yAxis = yAxis;
        Map optionMap = AidaUtils.parseOptions(options);
        String type = (String)optionMap.get("type");
        if (type == null || type.equals("default")) {
            this.binner2D = new BasicBinner2D(xAxis.bins() + 2, yAxis.bins() + 2);
        } else if (type.equals("efficiency")) {
            this.binner2D = new EfficiencyBinner2D(xAxis.bins() + 2, yAxis.bins() + 2);
        } else {
            throw new IllegalArgumentException("Wrong histogram type " + type);
        }
        this.reset();
    }
}

