/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.function;

import hep.aida.ref.function.FunctionCore;

public class PolynomialCoreNotNorm
extends FunctionCore {
    protected boolean providesNormalization;

    public PolynomialCoreNotNorm(int dim, int nPar) {
        super(dim, nPar);
        this.setTitle("PolynomialCoreNotNorm::P" + nPar);
        this.providesNormalization = false;
    }

    public PolynomialCoreNotNorm(int dim, int nPar, double[] pVal) {
        super(dim, nPar, pVal);
        this.setTitle("PolynomialCoreNotNorm::P" + nPar);
        this.providesNormalization = false;
    }

    public PolynomialCoreNotNorm(String str) {
        super(1, PolynomialCoreNotNorm.getDimension(str));
        this.setTitle("PolynomialCoreNotNorm::" + str);
        this.providesNormalization = false;
    }

    public PolynomialCoreNotNorm(String str, double[] pVal) {
        super(1, PolynomialCoreNotNorm.getDimension(str), pVal);
        this.setTitle("PolynomialCoreNotNorm::" + str);
        this.providesNormalization = false;
    }

    public double functionValue(double[] var) {
        double val = 0.0;
        for (int i = 1; i < this.numberOfParameters; ++i) {
            val += this.p[i] * Math.pow(var[0], i);
        }
        return val + this.p[0];
    }

    public boolean providesGradient() {
        return true;
    }

    public double[] gradient(double[] var) {
        double[] tmp = new double[]{0.0};
        if (this.numberOfParameters == 1) {
            return tmp;
        }
        double val = this.p[1];
        for (int i = 2; i < this.numberOfParameters; ++i) {
            val += (double)i * this.p[i] * Math.pow(var[0], i - 1);
        }
        tmp[0] = val;
        return tmp;
    }

    public boolean providesParameterGradient() {
        return true;
    }

    public double[] parameterGradient(double[] var) {
        double[] tmp = new double[this.numberOfParameters];
        tmp[0] = 0.0;
        for (int i = 1; i < this.numberOfParameters; ++i) {
            tmp[i] = Math.pow(var[0], i);
        }
        return tmp;
    }

    public boolean providesNormalization() {
        return this.providesNormalization;
    }

    public double normalizationAmplitude(double[] xMin, double[] xMax) {
        throw new UnsupportedOperationException(this.title() + " *****  Can not calculate normalization for a not normalized function");
    }

    public static int getDimension(String str) {
        if (!str.toLowerCase().startsWith("p")) {
            throw new IllegalArgumentException("Polynomial Function Qualifier must start with \"P\"");
        }
        return 1 + Integer.parseInt(str.substring(1));
    }
}

