/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.function;

import hep.aida.IAnalysisFactory;
import hep.aida.IBaseHistogram;
import hep.aida.IFitData;
import hep.aida.IFunction;
import hep.aida.IFunctionFactory;
import hep.aida.IHistogram1D;
import hep.aida.IHistogram2D;
import hep.aida.IHistogramFactory;
import hep.aida.IModelFunction;
import hep.aida.IPlotter;
import hep.aida.IPlotterFactory;
import hep.aida.ITree;
import hep.aida.ITuple;
import hep.aida.ITupleFactory;
import hep.aida.ref.fitter.Fitter;
import hep.aida.ref.fitter.fitData.FitData;
import hep.aida.ref.function.PolynomialCoreNotNorm;
import java.io.IOException;
import java.util.Random;

public class PolynomialCoreNorm
extends PolynomialCoreNotNorm {
    public PolynomialCoreNorm(String str) {
        super(1, PolynomialCoreNorm.getDimension(str) - 1);
        this.setTitle("PolynomialCoreNorm::" + str);
        this.providesNormalization = true;
        String[] pNames = new String[this.numberOfParameters];
        for (int i = 0; i < this.numberOfParameters; ++i) {
            pNames[i] = "p" + (i + 1);
        }
        this.setParameterNames(pNames);
    }

    public PolynomialCoreNorm(String str, double[] pVal) {
        super(1, PolynomialCoreNorm.getDimension(str) - 1, pVal);
        this.setTitle("PolynomialCoreNorm::" + str);
        this.providesNormalization = true;
        String[] pNames = new String[this.numberOfParameters];
        for (int i = 0; i < this.numberOfParameters; ++i) {
            pNames[i] = "p" + (i + 1);
        }
        this.setParameterNames(pNames);
    }

    public double functionValue(double[] var) {
        double val = 0.0;
        for (int i = 0; i < this.numberOfParameters; ++i) {
            val += this.p[i] * Math.pow(var[0], i + 1);
        }
        return val += 1.0;
    }

    public double[] gradient(double[] var) {
        double[] tmp = new double[]{0.0};
        if (this.numberOfParameters == 0) {
            return tmp;
        }
        double val = this.p[0];
        for (int i = 1; i < this.numberOfParameters; ++i) {
            val += (double)i * this.p[i] * Math.pow(var[0], i);
        }
        tmp[0] = val;
        return tmp;
    }

    public double[] parameterGradient(double[] var) {
        double[] tmp = new double[this.numberOfParameters];
        for (int i = 0; i < this.numberOfParameters; ++i) {
            tmp[i] = Math.pow(var[0], i + 1);
        }
        return tmp;
    }

    public double normalizationAmplitude(double[] xMin, double[] xMax) {
        double val = 0.0;
        val += xMax[0] - xMin[0];
        for (int i = 0; i < this.numberOfParameters; ++i) {
            val += this.p[i] / (double)(i + 2) * (Math.pow(xMax[0], i + 2) - Math.pow(xMin[0], i + 2));
        }
        return val;
    }

    public static void main(String[] args) throws IOException {
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree tree = af.createTreeFactory().create();
        IHistogramFactory hf = af.createHistogramFactory(tree);
        ITupleFactory tf = af.createTupleFactory(tree);
        IFunctionFactory ff = af.createFunctionFactory(tree);
        IPlotterFactory pf = af.createPlotterFactory();
        IPlotter plotter = pf.create("JAS Plotter");
        plotter.createRegions(2, 2);
        IModelFunction f1 = (IModelFunction)ff.createFunctionByName("f1", "p2");
        IModelFunction f2 = (IModelFunction)ff.createFunctionByName("f2", "p2");
        IModelFunction f3 = (IModelFunction)ff.createFunctionByName("f3", "p2");
        IModelFunction f4 = (IModelFunction)ff.createFunctionByName("f4", "p2");
        IHistogram1D hist1 = hf.createHistogram1D("hist1", "hist1", 100, -5.0, 5.0);
        IHistogram1D hist2 = hf.createHistogram1D("hist2", "hist2", 100, -5.0, 5.0);
        IHistogram2D hist2d = hf.createHistogram2D("hist2d", "hist2d", 100, -5.0, 5.0, 10, -10.0, 0.0);
        Random r = new Random();
        ITuple tup = tf.create("tup", "tup", "double x0, double y");
        for (int i = 0; i < 20000; ++i) {
            double d;
            double x = 10.0 * (r.nextDouble() - 0.5);
            double y = r.nextDouble() * 60.0;
            if (!(y < (d = x * x - 4.0 * x + 25.0))) continue;
            hist1.fill(x);
            hist2d.fill(x, y);
            tup.fill(0, x);
            tup.fill(1, y);
            tup.addRow();
        }
        double[] chi2 = new double[]{180.0, 0.1, -20.0};
        f1.setParameters(chi2);
        f2.setParameters(chi2);
        f2.normalize(false);
        Fitter fitter = new Fitter("Chi2", "minuit", null);
        fitter.fit((IBaseHistogram)hist1, "p2");
        plotter.currentRegion().plot((IBaseHistogram)hist1);
        plotter.currentRegion().plot((IFunction)f1);
        plotter.next();
        plotter.currentRegion().plot((IBaseHistogram)hist1);
        plotter.currentRegion().plot((IFunction)f2);
        for (int i = 0; i < 1; ++i) {
            hist2.fill(0.1);
        }
        f3.normalize(true);
        f4.normalize(true);
        f3.excludeNormalizationAll();
        f3.normalizationRange(0).include(-5.0, 5.0);
        f4.excludeNormalizationAll();
        f4.normalizationRange(0).include(-5.0, 5.0);
        double[] ml = new double[]{0.1, 2.0};
        f3.setParameters(ml);
        f4.setParameters(ml);
        System.out.println("Variable names: " + f4.variableName(0));
        Object ev = null;
        FitData fd = new FitData();
        Fitter fitter2 = new Fitter("uml", "minuit", null);
        fitter2.fitParameterSettings("p0").setStepSize(0.1);
        fitter2.fitParameterSettings("p1").setStepSize(0.1);
        fitter2.fitParameterSettings("p2").setStepSize(0.1);
        String[] colNames = new String[]{"x0"};
        fd.createConnection(tup, colNames);
        fitter2.fit((IFitData)fd, (IFunction)f4);
        plotter.next();
        plotter.currentRegion().plot((IBaseHistogram)hist2);
        plotter.currentRegion().plot((IFunction)f3);
        plotter.next();
        plotter.currentRegion().plot((IBaseHistogram)hist2);
        plotter.currentRegion().plot((IFunction)f4);
        plotter.show();
    }
}

