/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.function;

import hep.aida.ref.function.BaseModelFunction;
import hep.aida.ref.function.JELFunctionCore;
import java.util.StringTokenizer;

public class JELBaseModelFunction
extends BaseModelFunction {
    private JELBaseModelFunction() {
    }

    public JELBaseModelFunction(String treeName, int dim, String valexpr, String parameters, String description, String gradexpr) {
        this.setName(treeName);
        JELFunctionCore f = this.createJELFunctionCore(dim, valexpr, parameters, gradexpr);
        this.init(description, f, f);
    }

    public JELFunctionCore createJELFunctionCore(int dim, String valexpr, String parameters, String gradexpr) {
        JELFunctionCore core = null;
        String[] parNames = null;
        int nPar = 0;
        if (parameters != null && !parameters.equals("")) {
            StringTokenizer st = new StringTokenizer(parameters, ",;");
            nPar = st.countTokens();
            if (nPar > 0) {
                parNames = new String[nPar];
            }
            int i = 0;
            while (st.hasMoreTokens()) {
                String token;
                parNames[i] = token = st.nextToken().trim();
                ++i;
            }
        }
        String[] gr = null;
        int nGr = 0;
        if (gradexpr != null && !gradexpr.equals("") && !gradexpr.trim().toLowerCase().equals("null")) {
            StringTokenizer st = new StringTokenizer(gradexpr, ",;");
            nGr = st.countTokens();
            if (nGr != dim) {
                throw new IllegalArgumentException("Dimension of the gradient (" + nGr + ") is not equal to the dimension of the function (" + dim + ")");
            }
            gr = new String[dim];
            int i = 0;
            while (st.hasMoreTokens()) {
                String token;
                gr[i] = token = st.nextToken().trim();
                ++i;
            }
        }
        core = new JELFunctionCore(dim, nPar, valexpr, parNames, gr);
        return core;
    }
}

