/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.function;

import hep.aida.IFunction;
import hep.aida.ext.IManagedFunction;
import hep.aida.ref.Annotation;
import hep.aida.ref.function.BaseModelFunction;
import hep.aida.ref.function.FunctionCore;
import hep.aida.ref.test.jaida.TestUserFunction;

public class IFunctionCoreNotNorm
extends FunctionCore {
    protected boolean providesNormalization;
    private IFunction function;

    public IFunctionCoreNotNorm(IFunction func) {
        super(func.dimension(), func.numberOfParameters(), null);
        this.function = func;
        this.initIFunctionCore();
    }

    public IFunctionCoreNotNorm(IFunction func, double[] pVal) {
        super(func.dimension(), func.numberOfParameters(), pVal);
        this.function = func;
        this.initIFunctionCore();
    }

    private void initIFunctionCore() {
        String tit = null;
        try {
            tit = this.function.annotation().value(Annotation.titleKey);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        if (tit != null && !tit.equals("")) {
            this.setTitle(tit);
        }
        this.providesNormalization = false;
        String[] names = this.function.parameterNames();
        this.setParameterNames(names);
    }

    public double functionValue(double[] var) {
        return this.function.value(var);
    }

    public boolean providesGradient() {
        return this.function.providesGradient();
    }

    public double[] gradient(double[] var) {
        return this.function.gradient(var);
    }

    public boolean providesParameterGradient() {
        return false;
    }

    public double[] parameterGradient(double[] var) {
        throw new UnsupportedOperationException(this.title() + "IFunctionCore does not provide parameter gradient");
    }

    public boolean providesNormalization() {
        return this.providesNormalization;
    }

    public double normalizationAmplitude(double[] xMin, double[] xMax) {
        throw new UnsupportedOperationException(this.title() + " *****  Can not calculate normalization for a not normalized function");
    }

    public double[] parameters() {
        return this.function.parameters();
    }

    public double parameter(String name) {
        return this.function.parameters()[this.indexOfParameter(name)];
    }

    public void setParameters(double[] params) {
        this.function.setParameters(params);
    }

    public void setParameter(String name, double x) throws IllegalArgumentException {
        String fName = this.function.parameterNames()[this.indexOfParameter(name)];
        this.function.setParameter(fName, x);
    }

    public static void main(String[] args) {
        TestUserFunction f = new TestUserFunction();
        ((IManagedFunction)f).setName("TestFunction");
        BaseModelFunction bmf = new BaseModelFunction("BaseName", "BaseTitle", (IFunction)f);
        System.out.println(bmf.toString());
        double[] parValues = new double[]{2.0, 3.0, 5.0};
        bmf.setParameters(parValues);
        for (int i = 0; i < 20; ++i) {
            double x = (double)i * 1.0;
            double y = (double)i * 2.0;
            double[] var = new double[]{x, y};
            double valueExp = parValues[0] * x * x + parValues[1] * y + parValues[2];
            double[] gradientExp = new double[]{2.0 * parValues[0] * x, parValues[1]};
            System.out.println(i + "   Value=" + bmf.value(var) + ", delta=" + (bmf.value(var) - valueExp) + ";    grad_X=" + bmf.gradient(var)[0] + ", delta=" + (bmf.gradient(var)[0] - gradientExp[0]) + ";    grad_Y=" + bmf.gradient(var)[1] + ", delta=" + (bmf.gradient(var)[1] - gradientExp[1]));
        }
        System.out.println(bmf.toString());
    }
}

