/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.function;

import hep.aida.IAnnotation;
import hep.aida.IFunction;
import hep.aida.IModelFunction;
import hep.aida.IRangeSet;
import hep.aida.ref.function.RangeSet;
import java.util.Hashtable;

public class GaussianModel
implements IModelFunction {
    private final double r2 = Math.sqrt(2.0);
    private String title = "";
    private int dimension = 1;
    private int nMaxParameters = 3;
    private double[] pars = new double[this.nMaxParameters];
    private String[] parNames = new String[]{"mean", "sigma", "norm"};
    private Hashtable parHash = new Hashtable(this.nMaxParameters);
    private Hashtable varHash = new Hashtable(this.dimension);
    private double xmin = Double.NEGATIVE_INFINITY;
    private double xmax = Double.POSITIVE_INFINITY;
    private boolean isNormalized = true;
    private int numberOfPar = 3;
    private IRangeSet[] rangeSet;
    private final double[] erfc_coef = new double[]{-0.049046121234691806, -0.14226120510371365, 0.010035582187599796, -5.768764699767485E-4, 2.741993125219606E-5, -1.1043175507344507E-6, 3.8488755420345036E-8, -1.1808582533875466E-9, 3.2334215826050907E-11, -7.991015947004549E-13, 1.7990725113961456E-14, -3.718635487818693E-16, 7.103599003714253E-18};
    private final double[] erfc2_coef = new double[]{-0.0696013466023095, -0.04110133936262089, 0.003914495866689627, -4.906395650548979E-4, 7.157479001377036E-5, -1.1530716341312328E-5, 1.9946705902019974E-6, -3.642666471599223E-7, 6.944372610005012E-8, -1.371220902104366E-8, 2.7883896610071373E-9, -5.814164724331161E-10, 1.2389204917527532E-10, -2.6906391453067435E-11, 5.942614350847911E-12, -1.3323867357581197E-12, 3.0280468061771323E-13, -6.966648814941033E-14, 1.620854541053923E-14, -3.809934465250492E-15, 9.040487815978831E-16, -2.1640061950896072E-16, 5.222102233995855E-17, -1.2697296023645554E-17, 3.1091455042761977E-18};
    private final double[] erfcc_coef = new double[]{0.07151793102029248, -0.026532434337606717, 0.0017111539779208558, -1.6375166345851787E-4, 1.9871293500552038E-5, -2.843712412766555E-6, 4.6061613089631305E-7, -8.227753025879209E-8, 1.5921418727709012E-8, -3.295071362252843E-9, 7.223439760400556E-10, -1.6648558133987297E-10, 4.010392588237665E-11, -1.004816214425731E-11, 2.608275913300334E-12, -6.991110560404025E-13, 1.9294923332617072E-13, -5.470131188754331E-14, 1.5896633097626975E-14, -4.726893980197555E-15, 1.4358733767849847E-15, -4.449510561817358E-16, 1.4048108847682335E-16, -4.5138183877642106E-17, 1.474521541045133E-17, -4.8926214069457765E-18, 1.6476121414106467E-18, -5.626817176329408E-19, 1.9474433822320786E-19};
    private final double erf_xbig = Math.sqrt(-Math.log(1.9678190753608168E-16));
    private final double erf_sqeps = Math.sqrt(2.2204460492503E-16);
    private final double erfc_xsml = -Math.sqrt(-Math.log(1.9678190753608168E-16));
    private double erfc_xmax;

    public GaussianModel() {
        this.initGaussianModel();
    }

    private void initGaussianModel() {
        this.erfc_xmax = Math.sqrt(-Math.log(9.9E-324));
        this.erfc_xmax += -0.5 * Math.log(this.erfc_xmax) / this.erfc_xmax - 0.01;
        this.normalize(true);
        this.pars[0] = 0.1;
        this.pars[1] = 1.1;
        this.pars[2] = 50.0;
        this.rangeSet = new RangeSet[this.dimension];
        this.rangeSet[0] = new RangeSet();
    }

    public int dimension() {
        return this.dimension;
    }

    public int indexOfParameter(String str) {
        for (int i = 0; i < this.numberOfParameters(); ++i) {
            if (!this.parNames[i].equals(str)) continue;
            return i;
        }
        throw new IllegalArgumentException("Parameter " + str + " does not belong to this function");
    }

    public int numberOfParameters() {
        return this.numberOfPar;
    }

    public double parameter(String str) {
        for (int i = 0; i < this.numberOfParameters(); ++i) {
            if (!this.parNames[i].equals(str)) continue;
            return this.pars[i];
        }
        throw new IllegalArgumentException("Parameter " + str + " does not belong to this function");
    }

    public String[] parameterNames() {
        String[] tmpParNames = new String[this.numberOfParameters()];
        for (int i = 0; i < this.numberOfParameters(); ++i) {
            tmpParNames[i] = this.parNames[i];
        }
        return tmpParNames;
    }

    public double[] parameters() {
        double[] tmpPars = new double[this.numberOfParameters()];
        for (int i = 0; i < this.numberOfParameters(); ++i) {
            tmpPars[i] = this.pars[i];
        }
        return tmpPars;
    }

    public boolean providesGradient() {
        return false;
    }

    public void setParameter(String str, double param) {
        for (int i = 0; i < this.numberOfParameters(); ++i) {
            if (!this.parNames[i].equals(str)) continue;
            this.pars[i] = param;
            return;
        }
        throw new IllegalArgumentException("Parameter " + str + " does not belong to this function");
    }

    public void setParameters(double[] values) {
        if (values.length != this.numberOfParameters()) {
            throw new IllegalArgumentException("Wrong number of parameters " + values.length + " !!");
        }
        for (int i = 0; i < this.numberOfParameters(); ++i) {
            this.pars[i] = values[i];
        }
    }

    public double value(double[] values) {
        double norm = 1.0;
        if (!this.isNormalized()) {
            norm = this.pars[2];
        }
        return norm * Math.exp(-Math.pow(values[0] - this.pars[0], 2.0) / (2.0 * Math.pow(this.pars[1], 2.0))) / this.normalization();
    }

    private double normalization() {
        return Math.sqrt(1.5707963267948966) * this.pars[1] * (this.erf((this.xmax - this.pars[0]) / (this.r2 * this.pars[1])) - this.erf((this.xmin - this.pars[0]) / (this.r2 * this.pars[1])));
    }

    public String variableName(int param) {
        return "x";
    }

    public String[] variableNames() {
        String[] varNames = new String[]{"x"};
        return varNames;
    }

    public boolean providesNormalization() {
        return true;
    }

    public boolean isNormalized() {
        return this.isNormalized;
    }

    public void normalize(boolean normalize) {
        this.isNormalized = normalize;
        this.numberOfPar = this.isNormalized() ? 2 : 3;
    }

    public void setNormalizationRange(double xmin, double xmax, int varIndex) {
        this.xmin = xmin;
        this.xmax = xmax;
    }

    public double[] parameterGradient(double[] values) {
        double[] der = new double[this.numberOfParameters()];
        double s = this.pars[1];
        double x0 = this.pars[0];
        double x = values[0];
        double arg = (x - x0) / s;
        double argMax = (this.xmax - x0) / s;
        double argMin = (this.xmin - x0) / s;
        double d = Math.sqrt(1.5707963267948966) * this.pars[1] * (this.erf((this.xmax - this.pars[0]) / (this.r2 * this.pars[1])) - this.erf((this.xmin - this.pars[0]) / (this.r2 * this.pars[1])));
        double v = this.value(values);
        der[0] = v / d * (-arg / s + Math.exp(-argMax * argMax / 2.0) - Math.exp(-argMin * argMin / 2.0));
        der[1] = v / d * (arg * arg / s - d / s + argMax * Math.exp(-argMax * argMax / 2.0) - argMin * Math.exp(-argMin * argMin / 2.0));
        if (der.length == 3) {
            der[2] = v / this.pars[2];
        }
        double[] der1 = new double[this.numberOfParameters()];
        double h = 1.0E-5;
        double s1 = s + h;
        double x1 = x0 + h;
        double n1 = this.pars[2] + h;
        this.setParameter("mean", x1);
        der1[0] = (this.value(values) - v) / h;
        this.setParameter("mean", x0);
        this.setParameter("sigma", s1);
        der1[1] = (this.value(values) - v) / h;
        this.setParameter("sigma", s);
        if (der.length == 3) {
            this.setParameter("norm", n1);
            der1[2] = (this.value(values) - v) / h;
            this.setParameter("norm", this.pars[2]);
        }
        return der;
    }

    public boolean providesParameterGradient() {
        return true;
    }

    public double[] gradient(double[] values) {
        throw new UnsupportedOperationException();
    }

    public IAnnotation annotation() {
        throw new UnsupportedOperationException();
    }

    public String codeletString() {
        return "codelet:gaussianModel";
    }

    public boolean isEqual(IFunction iFunction) {
        throw new UnsupportedOperationException();
    }

    public void excludeNormalizationAll() {
    }

    public void excludeNormalizationAll(int param) {
    }

    public void excludeNormalizationRange(double param, double param1, int param2) {
    }

    public void includeNormalizationAll() {
    }

    public void includeNormalizationAll(int param) {
    }

    public void includeNormalizationRange(double xmin, double xmax, int varIndex) {
        this.setNormalizationRange(xmin, xmax, varIndex);
    }

    public IRangeSet normalizationRange(int iAxis) {
        return this.rangeSet[iAxis];
    }

    private double erf(double d) {
        double d1 = Double.NaN;
        double d2 = Math.abs(d);
        d1 = d2 <= 1.0 ? (d2 <= this.erf_sqeps ? 2.0 * d / 1.772453850905516 : d * (1.0 + this.csevl(2.0 * d * d - 1.0, this.erfc_coef))) : (d2 <= this.erf_xbig ? GaussianModel.sign(1.0 - this.erfc(d2), d) : GaussianModel.sign(1.0, d));
        return d1;
    }

    private double erfc(double d) {
        double d1 = Double.NaN;
        if (d <= this.erfc_xsml) {
            d1 = 2.0;
        } else if (d <= this.erfc_xmax) {
            double d2 = Math.abs(d);
            if (d2 <= 1.0) {
                d1 = d2 < this.erf_sqeps ? 1.0 - 2.0 * d / 1.772453850905516 : 1.0 - d * (1.0 + this.csevl(2.0 * d * d - 1.0, this.erfc_coef));
            } else {
                d1 = (d2 *= d2) <= 4.0 ? Math.exp(-d2) / Math.abs(d) * (0.5 + this.csevl((8.0 / d2 - 5.0) / 3.0, this.erfc2_coef)) : Math.exp(-d2) / Math.abs(d) * (0.5 + this.csevl(8.0 / d2 - 1.0, this.erfcc_coef));
                if (d < 0.0) {
                    d1 = 2.0 - d1;
                }
            }
        } else {
            d1 = 0.0;
        }
        return d1;
    }

    private double csevl(double d, double[] ad) {
        int i = ad.length;
        double d2 = 0.0;
        double d1 = 0.0;
        double d3 = 0.0;
        double d4 = 2.0 * d;
        for (int j = i - 1; j >= 0; --j) {
            d3 = d2;
            d2 = d1;
            d1 = d4 * d2 - d3 + ad[j];
        }
        return 0.5 * (d1 - d3);
    }

    public static double sign(double d, double d1) {
        double d2 = d >= 0.0 ? d : -d;
        return d1 >= 0.0 ? d2 : -d2;
    }

    public void setTitle(String str) throws IllegalArgumentException {
        this.title = str;
    }

    public String title() {
        return this.title;
    }
}

