/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.function;

public abstract class FunctionCore {
    protected String title;
    protected int dimension;
    protected int numberOfParameters;
    protected double[] p;
    protected String[] parNames;

    public FunctionCore(int dim, int nPar) {
        this.init(dim, nPar);
    }

    public FunctionCore(int dim, int nPar, double[] parVal) {
        if (parVal != null && nPar != parVal.length) {
            throw new IllegalArgumentException("Number of parameters (" + nPar + ") is different from number of parameter values (" + parVal.length + ")");
        }
        this.init(dim, nPar);
        if (parVal != null) {
            for (int i = 0; i < nPar; ++i) {
                this.p[i] = parVal[i];
            }
        }
    }

    protected void init(int dim, int nPar) {
        this.dimension = dim;
        this.numberOfParameters = nPar;
        this.p = new double[nPar];
        this.parNames = new String[nPar];
        for (int i = 0; i < nPar; ++i) {
            this.parNames[i] = "p" + i;
            this.p[i] = 1.0;
        }
    }

    public int dimension() {
        return this.dimension;
    }

    public String title() {
        return this.title;
    }

    public void setTitle(String t) {
        this.title = t;
    }

    public abstract double functionValue(double[] var1);

    public abstract boolean providesGradient();

    public abstract double[] gradient(double[] var1);

    public abstract boolean providesParameterGradient();

    public abstract double[] parameterGradient(double[] var1);

    public abstract boolean providesNormalization();

    public abstract double normalizationAmplitude(double[] var1, double[] var2);

    public int numberOfParameters() {
        return this.numberOfParameters;
    }

    public String[] parameterNames() {
        return this.parNames;
    }

    public double[] parameters() {
        return this.p;
    }

    public double parameter(String name) {
        return this.p[this.indexOfParameter(name)];
    }

    public boolean setParameterNames(String[] params) {
        for (int i = 0; i < this.numberOfParameters(); ++i) {
            this.parNames[i] = params[i];
        }
        return true;
    }

    public int indexOfParameter(String name) {
        for (int i = 0; i < this.numberOfParameters(); ++i) {
            if (!name.equals(this.parNames[i])) continue;
            return i;
        }
        throw new IllegalArgumentException("Function \"" + this.title() + "\" does not have variable named \"" + name + "\"");
    }

    public void setParameters(double[] params) {
        for (int i = 0; i < this.numberOfParameters(); ++i) {
            this.p[i] = params[i];
        }
    }

    public void setParameter(String name, double x) throws IllegalArgumentException {
        this.p[this.indexOfParameter((String)name)] = x;
    }
}

